/* e_base.cc
 *$Header: /al/acs/src/RCS/e_base.cc,v 9.26 95/10/31 16:11:57 al Exp $
 * Base class for "cards" in the circuit description file
 */
#include "ap.h"
#include "constant.h"
#include "error.h"
#include "io.h"
#include "u_xprobe.h"
#include "e_base.h"
#include "s__.h"
#include "util.h"
/*--------------------------------------------------------------------------*/
//	char*	CKT_BASE::probe_txt(const char*)const;
//	double	CKT_BASE::probe_num(const char*)const;
	double	CKT_BASE::probe_tr_num(const char*)const
			{assert(!"CKT_BASE::tr_probe");return NOT_VALID;}
//	double	CKT_BASE::probe_ac_num(const char*)const;
	xprobe_t CKT_BASE::probe_ac_ext(const char*)const
			{assert(!"CKT_BASE::xprobe");return xprobe_t();}
/*--------------------------------------------------------------------------*/
BSMATRIXdouble	CKT_BASE::aa;
BSMATRIXdouble	CKT_BASE::lu;
BSMATRIXCOMPLEX	CKT_BASE::acx;
/*--------------------------------------------------------------------------*/
char* CKT_BASE::probe_txt(const char *what)const
{
  return ftos(probe_num(what),"           ",5,IO::formaat);
}
/*--------------------------------------------------------------------------*/
double CKT_BASE::probe_num(const char *what)const
{
  if (SIM::mode == sAC){
    return probe_ac_num(what);
  }else{
    return probe_tr_num(what);
  }
}
/*--------------------------------------------------------------------------*/
double CKT_BASE::probe_ac_num(const char *what)const
{
  int length = strlen(what);
  mod_t modifier = mtNONE;
  int want_db = FALSE;
  char parameter[LABELEN+1];
  strcpy(parameter, what);

  if (length > 2  &&  pmatch(&parameter[length-2], "DB")){
    want_db = TRUE;
    length -= 2;
  }
  if (length > 1){
    switch (to_lower(parameter[length-1])){
      case 'm': modifier = mtMAG;   length--;	break;
      case 'p': modifier = mtPHASE; length--;	break;
      case 'r': modifier = mtREAL;  length--;	break;
      case 'i': modifier = mtIMAG;  length--;	break;
      default:  modifier = mtNONE;		break;
    }
  }
  parameter[length] = '\0';
  
  xprobe_t xp = probe_ac_ext(parameter);
  if (!xp.ok){
    xp = probe_ac_ext(what);
  }
  if (!xp.ok){
    return NOT_VALID;
  }else{
    double rvalue = 0.;
    if (modifier == mtNONE)
      modifier = xp.modifier;
    switch (modifier){
      case mtMAG:   rvalue = abs(xp.value);    	 break;
      case mtPHASE: rvalue = arg(xp.value)*RTOD; break;
      case mtREAL:  rvalue = real(xp.value);	 break;
      case mtIMAG:  rvalue = imag(xp.value);	 break;
      default:	    assert(!"acprobe");		 break;
    }
    if (want_db){
      return xp.dbscale * log10(max(rvalue,VOLTMIN));
    }
    return rvalue;
  }
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
