/* io.h
 $Header: /al/acs/src/RCS/io.h,v 9.21 95/10/21 18:11:05 al Exp $
 * shared data for all io functions
 * other io related stuff, like files and formatting
 */
#ifndef IO_H
#define IO_H
#include "md.h"
/*--------------------------------------------------------------------------*/
class CS;
/*--------------------------------------------------------------------------*/
class IO {
public:
 static int mstdin;
 static int mstdout;
 static int mstderr;
 static int mprint;
 static int where;		/* where to send data, multi-format */
 static int formaat;		/* how to format io.  Basic option. */
 static FILE *whence;		/* get file from.  std C file. */
 static int suppresserrors;
 static int echoflag;		/* not used */
 static int printflag;		/* not used */
 static int incipher;		/* flag: decrypt input file */
 static int outcipher;		/* flag: encrypt output file */
 static int pack;		/* flag: convert whitespace to tabs on out */
 static int ploton;
 static int plotset;
 static FILE *stream[MAXHANDLE+1];	/* reverse of fileno() */
};
/*--------------------------------------------------------------------------*/
/* contrl */	void	initio(int,FILE*);
		void	decipher(char*);
		void	outreset();
		int	outset(CS&,const char*,const char*);
/* findf */	char*	findfile(const char*,const char*,int);
/* ftos */	char*	ftos(double,const char*,int,int);
/* getln */	char* 	getlines(char*,int,FILE*);
/* itos */	char*	itos(int,char*,int,int);
/* out */	void	mtab(int,int);
		void	mprintf(int,const char*,...);
		void	mputs(const char*,int);
		void	mputc(int,int);
/* trim */	char	*trim(char*);
/* utos */	char*	utos(unsigned,char*,int);
/* xopen */	void	xclose(FILE**);
		FILE*	xopen(CS&,const char*,const char*);

#define FMTEXP  1
#define FMTSIGN 2
#define FMTFILL 4
#define FMTFIX  8
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
