/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 */

static	char	*rcsid = "$Header: error.c,v 1.2 94/06/19 11:22:12 nau Exp $";

/* error and debug funtions
 */

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>

#ifdef _POSIX_SOURCE
#include <unistd.h>
#endif

#include "global.h"

#include "data.h"
#include "error.h"
#include "dialog.h"
#include "file.h"

/* ---------------------------------------------------------------------------
 * output of warning message
 */
void MyWarning(Format, va_alist)
char *Format;
va_dcl
{
	va_list	args;

	va_start(args);
	fprintf(stderr, "%s (%i): warning, ", Progname, getpid());
	vfprintf(stderr, Format, args);
	fflush(stderr);
	va_end(args);
}

/* ---------------------------------------------------------------------------
 * output of warning message in a dialog window
 */
void MyWarningDialog(Format, va_alist)
char *Format;
va_dcl
{
	va_list	args;
	char	s[1024];

	va_start(args);
	vsprintf(s, Format, args);
	va_end(args);
	WarningDialog(Output.Toplevel, s);
}

/* ---------------------------------------------------------------------------
 * output of fatal error message
 */
void MyFatal(Format, va_alist)
char *Format;
va_dcl
{
			va_list	args;
	static	int		flag = 0;

	va_start(args);
	fprintf(stderr, "%s (%i): fatal, ", Progname, getpid());
	vfprintf(stderr, Format, args);
	fflush(stderr);
	va_end(args);

		/* try to save the layout but prevent endless loop from 
		 * second fatal error
		 */
	if (!flag)
	{
		flag = 1;
		EmergencySave();
	}
	exit(1);
}

/* ---------------------------------------------------------------------------
 * default error handler for X11 errors
 */
void X11ErrorHandler(String Msg)
{
	MyFatal("X11 fatal error: %s\n", Msg);
}
