
#ifndef _bytesex_h
#define _bytesex_h

#ifdef linux
#include <endian.h>
#else
#ifdef sparc
#include <sys/byteorder.h>
#else
#ifdef _SGI_SOURCE
#include <sys/endian.h>
#else
#ifdef _INCLUDE_HPUX_SOURCE
#include <machine/param.h>
#else
#ifdef __mips
#include <sex.h>
#else
#error	Compiling for an unknown architecture!
#endif /* DEC */
#endif /* HPUX */
#endif /* SGI */
#endif /* sparc */
#endif /* linux */

#ifndef LITTLE_ENDIAN
#define LITTLE_ENDIAN	1234
#define BIG_ENDIAN	4321
#endif

#ifdef _BIG_ENDIAN
#define BYTE_ORDER	BIG_ENDIAN
#endif

#ifdef LITTLEENDIAN	/* DEC -- Little Endian */
#define BYTE_ORDER LITTLE_ENDIAN
#endif

/* Macros to access the high and low byte of a short int */
#define HIBYTE(word)	(((word)>>8)&0xff)
#define LOBYTE(word)	((word)&0xff)

#if BYTE_ORDER == LITTLE_ENDIAN

/* Swap bytes from big-endian to this machine's type.
   The input data is assumed to be always in big-endian format.
*/
static inline void
byteswap(unsigned short *array, int nshorts)
{
	for (; nshorts-- > 0; array++)
		*array= HIBYTE(*array) | (LOBYTE(*array) << 8);
}

/* Macros to change the byte order of input values */
#define bytesexl(x)	(x = \
        ((x << 24) | ((x & 0xff00) << 8) | ((x >> 8) & 0xff00) | (x >> 24)))
#define bytesexs(x)	(x = (x << 8) | (x >> 8))

#else
static inline void
byteswap(unsigned short *array, int nshorts)
{ return; }

#define bytesexl(x)	(x)
#define bytesexs(x)	(x)

#endif /* Endianness */

#endif /* _BYTESEX_H */
