/* The score daemon -- runs on the Maelstrom Score Server */

#include <stdio.h>
#include <signal.h>
#include <errno.h>
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>

#include "netscore.h"

struct {
	char    name[20];
	int     wave;
	long    score;
} scores[10];

char *addr2host(struct sockaddr *addrptr, char *host);

int Init_Server(int port)
{
	static int         sockfd;
	struct sockaddr_in serv_addr;
	int                i;

	/* Open a TCP socket (an Internet stream socket).  */
	if ( (sockfd=socket(AF_INET, SOCK_STREAM, 0)) < 0 )
		return(-1);

	/* Bind our local address so that the client can send to us.  */
	memset(&serv_addr, 0, sizeof(serv_addr));
	serv_addr.sin_family      = AF_INET;
	serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
	serv_addr.sin_port        = htons(port);

	if ( bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr) ) 
									< 0)
		return(-1);

	if ( listen(sockfd, 3) < 0 )
		return(-1);

	return(sockfd);
}

int main(int argc, char *argv[])
{
	int             sockfd;
	int		i;

	if ( (sockfd=Init_Server(SCORE_PORT)) < 0 ) {
		perror("Can't set up server");
		exit(0);
	}

	for ( ; ; ) {
		int		   newfd;
		struct sockaddr_in cli_addr;
		char               remotehost[128];
		int                nlen;
		char               netbuf[1024], *request, *params;

		/* Accept the connection */
tryagain:
		i = sizeof(cli_addr);
		if ( (newfd=accept(sockfd, (struct sockaddr *)&cli_addr, &i))
									< 0 ) {
			if ( errno == EINTR )
				goto tryagain;
			else {
				perror("accept() error");
				exit(-1);
			}
		}
		(void) addr2host((struct sockaddr *)&cli_addr, remotehost);

		/* Print a Welcome banner */
		sprintf(netbuf,
			"Welcome to the Official Maelstrom Score Server!\n");
		write(newfd, netbuf, strlen(netbuf));

		/* Read the response */
		if ( (nlen=read(newfd, netbuf, 1024)) <= 0 ) {
			close(newfd);
			continue;
		}
		printf("Connect from %s!\n", remotehost);
		
		/* Parse the request */
		for ( request=params=netbuf; *params; ++params ) {
			if ( (*params == ' ') || (*params == '\n') ) {
				*params = '\0';
				++params;
				break;
			}
		}
		if ( strcmp(request, "SHOWSCORES") == 0 ) {
			/* Simple, for now */
			FILE *scores_fp;

			/* Read first scores file */
			if ( (scores_fp=fopen(argv[1], "r")) == NULL ) {
				perror(argv[1]);
				exit(3);
			}
			(void) fread(&scores[0], sizeof(scores), 1, scores_fp);
			fclose(scores_fp);

			sprintf(netbuf,
				"Name			Score	Wave\n");
			write(newfd, netbuf, strlen(netbuf));
			for ( i=0; i<10; ++i ) {
				sprintf(netbuf,
				"%-20s	%-3.1ld	%d\n", scores[i].name, 
					scores[i].score, scores[i].wave);
				write(newfd, netbuf, strlen(netbuf));
			}
		}
		close(newfd);
	}
}

/* A function to convert a sockaddr_in structure to its corresponding
   hostname (or its IP address if the hostname can't be found)  
*/

char *addr2host(struct sockaddr *addrptr, char *host)
{
	struct in_addr peeraddr;        /* The address of the connector */
	struct hostent *hp;
	int i;
	char *ptr, tmp[12];


	/*
         * The set of four bytes in the third buffer position are
         * the 32 bit ip address of the connector.
         */
        memcpy(&peeraddr.s_addr, &(addrptr->sa_data[2]), 
                                                sizeof(peeraddr.s_addr));
	
	/* Look up the address in the host tables */
	if ( (hp=gethostbyaddr((char *)(&peeraddr.s_addr),
                                sizeof(peeraddr.s_addr), AF_INET)) == NULL ) {
		/* Convert it to a dot-ip address */
		*host='\0';
		for ( i=0, ptr=(char *)&peeraddr.s_addr; i<3; ++i, ++ptr ) {
			sprintf(tmp, "%d.", 
				((int)*ptr < 0)?((int)*ptr+256):(int)*ptr);
			strcat(host, tmp);
		} 
		sprintf(tmp, "%d", ((int)*ptr < 0)?((int)*ptr+256):(int)*ptr);
		strcat(host, tmp);
	}
        else
                strcpy(host, hp->h_name);

	return(host);
}

