
/* X11 Graphics routines for Maelstrom!  (By Sam Lantinga) */

#ifndef _x11_framebuf_h
#define _x11_framebuf_h

#include "framebuf.h"

#include <X11/Xutil.h>
#include <X11/xpm.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <X11/extensions/XShm.h>

/*
#define USE_BG_PIXMAP
*/
/* Define USE_BG_PIXMAP above if you want to use the
	"shared memory background pixmap"
   feature of X11 instead of a shared memory XImage.

   It turns out that a shared memory XImage is faster; the overhead seen
   in original testing was "XCopyArea()" to the shared image, rather than
   manipulating the shared image directly.
*/

#define XFADE_OUT	0
#define XFADE_IN	1

/* This class allocates a 640x480 frame-buffer and provides high-level
   routines to blit images into it.  Well, it also provides access to
   other X11 based drawing routines.
*/
class X11_FrameBuf : public FrameBuf {

public:
	X11_FrameBuf(unsigned short width, unsigned short height,
				int FullScreen, char *title, char **icon);
	~X11_FrameBuf();

	int            Alloc_Cmap(int polite, Color Cmap[]);
	int            Alloc_Private_Cmap(Color Cmap[]);
	void           RefreshArea(int x0, int y0, int width, int height);
	void           Refresh(void);
	void           Hide_Cursor(void);
	void           Show_Cursor(void);
	void           Fade(int steps);
	void           FlushEvents(void);
	int            NumEvents(void);
	void           GetEvent(XEvent *event);
	int            KeyToAscii(XEvent *event, char *buf, int buflen,
								KeySym *key);
	void           Flush(int sync);

protected:
	void get_color_info (unsigned long mask, unsigned long *shift, 
							unsigned long *prec);
	void RefreshAll(void);		// Refresh the full-screen too

	Display *display;		// The X11 display connection
	Window   MainWin;		// Our window on the display
	unsigned long Event_mask;	// The events we wait for
	Colormap colormap;		// The current colormap
	Colormap private_cmap;		// A private colormap?
	Atom     wm_del_win;		// The delete window flag
	GC       gc;			// The current graphics context
	int      was_repeating;		// Was the keyboard repeating?

	XShmSegmentInfo shminfo;	// The shared memory segment info
#ifdef USE_BG_PIXMAP
	Pixmap  X_pixmap;		// The shared background pixmap
	XImage *X_image;		// ...or shared memory image
	int     use_ximage;		// Which do we use?
#else
	XImage *X_image;		// The shared memory screen image
#endif

	Cursor cursor, nocursor;

	int fullscreen;			// Are we full-screen?
	int root_width;			// The width of the root screen
	int root_height;		// The height of the root screen
	Window TopWin;			// The top-level Maelstrom window
	unsigned long White;		// The white pixel

	int truecolor, bpp;		// If truecolor, and bits per pixel
	unsigned char *trueshared_mem;	// The truecolor pixmap
	unsigned long red_prec;		// Red color precision for truecolor
	unsigned long green_prec;	// Green color precision for truecolor
	unsigned long blue_prec;	// Blue color precision for truecolor
	unsigned long red_shift;	// Red color shift for truecolor
	unsigned long green_shift;	// Green color shift for truecolor
	unsigned long blue_shift;	// Blue color shift for truecolor
	unsigned long True_Colors[NUM_COLORS];	// The truecolor "colormap"
};
#endif /* _x11_framebuf_h */
