
/* Written by Peter Ekberg, peda@lysator.liu.se */

#include <vgagl.h>
#include <vga.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include "thrust.h"

byte chcolor=20;
byte chpaper=0;
byte chflag=0;

void
printgc(word offset, byte ch)
{
  int x;
  int y;
  char width = font[ch][0];
  byte bits=1<<(width-1);
  byte bit=bits;

  for(y=1; y<6; y++, bit=bits) {
    for(x=0; x<width; x++, bit>>=1) {
      if(font[ch][y] & bit)
	*(graph_mem+offset+x) = chcolor;
      else if(chflag)
	*(graph_mem+offset+x) = chpaper;
    }
    if(chflag)
      *(graph_mem+offset+x) = chpaper;
    offset+=320;
  }
}

int
printgs(int x, int y, char *string)
{
  byte i;
  byte len=strlen(string);
  byte ch;
  word offset=x+320*y;
  char xc;
  int ox=x;

  for(i=0; i<len; i++)
    if((ch=*(string+i)) < 96)
      switch(ch)
	{
	case 10:
	  y+=6;
	  offset += 1920;
	  break;
	case 13:
	  offset = (x=ox)+320*y;
	  break;
	default:
	  printgc(offset,ch);
	  offset += (xc=font[ch][0]+1);
	  x += xc;
	}
  return(x);
}

int
readgs(int x, int y, char string[], int maxc, int maxp, char flag)
{
  int xc;
  word offset;
  word offsetcursor;
  int i,j;
  int key;
  byte ch;
  byte temp=chcolor;
  int leftx=x;
  byte cursor=0;

  maxp+=x;
  i=strlen(string);
  for(j=0; j<i; j++)
    string[j] = toupper(string[j]);
  x=printgs(x,y,string);
  offset=x+y*320;

  do {
    do {
      key=0;
      cursor=1-cursor;
      for(j=0; j<12 && !key; j++) {
	key=vga_getkey();
	if(!key)
	  usleep(25000L);
      }
      vga_lockvc();
      for(offsetcursor=offset+320*5, j=0; j<5; offsetcursor++, j++)
	*(graph_mem+offsetcursor)=cursor*temp;
      vga_unlockvc();
    } while(!key);
    vga_lockvc();
    for(offsetcursor=offset+320*5, j=0; j<5; offsetcursor++, j++)
      *(graph_mem+offsetcursor)=chpaper;
    vga_unlockvc();

    ch=toupper(key);
    switch(ch) {
    case 10:
      string[i]=0;
      ch=27;
      break;
    case 27:
      x=-1;
      break;
    case 127:
      if(i) {
	offset -= (xc=1+font[(int)string[--i]][0]);
	x -= xc;
	chcolor=chpaper;
	vga_lockvc();
	printgc(offset,string[i]);
	vga_unlockvc();
	chcolor=temp;
      }
      break;
    default:
      if(!font[ch][0]) {
	printf("\007");
	fflush(stdout);
      }
      else if(i!=maxc && x+(xc=1+font[ch][0])<=maxp) {
	string[i++]=ch;
	vga_lockvc();
	printgc(offset,ch);
	vga_unlockvc();
	offset+=xc;
	x+=xc;
      }
    }
  }
  while(ch!=27);

  if(flag) {
    vga_lockvc();
    for(i=y; i<y+5; i++)
      for(xc=leftx; xc<maxp; xc++)
	*(graph_mem+xc+320*i)=chpaper;
    vga_unlockvc();
  }

  return(x);
}

int
gstrlen(char *string)
{
  int len=strlen(string);
  int width=0;
  int count=0;
  int i;
  byte ch;

  for(i=0; i<len; i++)
    if((ch=*(string+i)) < 96)
      switch(ch) {
      case 13:
      case 10:
	if(count>width)
	  width=count;
	count=0;
	break;
      default:
	count += font[ch][0]+1;
      }

  return((count>width) ? count : width);
}
