/*
 * Programm XBLAST V1.2.8 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * February 19th 1996
 * started August 1993
 *
 * File: event.h
 * header file for event.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _EVENT_H
#define _EVENT_H

/*
 * global varaiables
 */

#ifndef _EVENT_C
extern DispPlayer disp_player[MAX_PLAYER];
#endif

/*
 * prototypes
 */

#ifdef _EVENT_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN void init_timer (void);
_EXTERN void game_event (int num_disp);
_EXTERN void intro_event (int num_disp);
_EXTERN void wait2_event (int num_disp);
_EXTERN int game_eval_keys(int num_player, BMPlayer *player_stat, 
			   PlayerStrings *p_string, int* pause_mode);
_EXTERN int wait_eval_keys (int num_player);
_EXTERN void clear_keys(int num_player);
_EXTERN void set_players_for_display (int disp, int player1, int player2);
_EXTERN void config_players (XBConfig *config);
_EXTERN void fade_in (int num_disp);
_EXTERN void fade_out (int num_disp);
_EXTERN void circle_in (int num_disp);
_EXTERN void wait2_two_text (int num_disp, int num_player, char *text1, 
			     char *text2);
#else
_EXTERN void init_timer ();
_EXTERN void game_event ();
_EXTERN void intro_event ();
_EXTERN void wait2_event ();
_EXTERN int game_eval_keys();
_EXTERN int wait_eval_keys ();
_EXTERN void clear_keys();
_EXTERN void set_players_for_displays ();
_EXTERN void config_players ();
_EXTERN void fade_in ();
_EXTERN void fade_out ();
_EXTERN void circle_in ();
_EXTERN void wait2_two_text ();
#endif

#undef _EXTERN

#endif
/*
 * end of file event.h
 */
