/*
 * Programm XBLAST V1.2.1 or higher
 * (C) by Oliver Vogel (e-mail: vogel@ikp.uni-koeln.de)
 * December 8th 1995
 * started August 1993
 *
 * File: maze.h
 *       include file for maze.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public Licences as by published
 * by the Free Software Foundation; either version 2; or (at your option)
 * any later version
 *
 * This program is distributed in the hope that it will entertaining,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Publis License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _MAZE_H
#define _MAZE_H

/*
 * prototypes
 */

#ifdef _MAZE_C
#define _EXTERN
#else
#define _EXTERN extern
#endif

#ifdef __STDC__
_EXTERN void init_shuffle_startpos (void);
_EXTERN void load_maze (BMPlayer *stat, int level, XBConfig *config, 
			XBSettings *setup, int *min_range, int *min_bombs);
_EXTERN void show_levels (void);
_EXTERN void set_victories (int num_victories);
_EXTERN char *get_level_name (int level);
_EXTERN char *get_level_res_name (int level);
_EXTERN char *get_level_author (int level);
_EXTERN char *get_level_tip (int level);
_EXTERN int get_game_mode (int level);
_EXTERN void unload_blocks (int num_disp);
_EXTERN void draw_maze (int player);
_EXTERN void set_redraw_rectangles (void);
_EXTERN void mark_maze (int x1, int y1, int x2, int y2);
_EXTERN void clear_redraw_map (void);
_EXTERN void update_maze (int player);
_EXTERN void update_expl (int player);
_EXTERN int check_maze (int x, int y);
_EXTERN int check_maze_free (int x, int y);
_EXTERN void set_maze_block (int x, int y, int block);
_EXTERN int get_extra (int invincible, int x, int y);
_EXTERN int distrib_special (void);
_EXTERN void distribute_extras (int bombs, int range, int extras, 
				int specials);
_EXTERN void do_bombs (void);
_EXTERN int ignite_players_bombs (int player);
_EXTERN void ignite_bombs (void);
_EXTERN int do_explosions (void);
_EXTERN void new_explosion (int player, int x, int y, int range, 
			    int remote_controlled, int malfunction, int type,
			    int type_extr, int initialdir);
_EXTERN void stun_players (BMPlayer *ps, int num_player);
_EXTERN int check_explosion (int x, int y);
_EXTERN int check_bomb (int x, int y);
_EXTERN int number_of_explosions (void);
_EXTERN void delete_outer_bombs (int range);
_EXTERN void delete_ring_bombs (int range);
_EXTERN void delete_row_bombs (int pos);
_EXTERN void delete_column_bombs (int pos);
_EXTERN void delete_upper_bombs (int y);
_EXTERN void delete_bomb_at (int x, int y);
_EXTERN void move_bomb (int x, int y, int dir);
_EXTERN void copy_expl_block(int x, int y, int block[CHARH][CHARW]);
_EXTERN void haunt_kick (int prob);
_EXTERN void do_air (BMPlayer *ps, int player);
#else
_EXTERN void init_shuffle_startpos ();
_EXTERN void load_maze ();
_EXTERN void show_levels ();
_EXTERN void set_victories ();
_EXTERN char *get_level_name ();
_EXTERN char *get_level_res_name ();
_EXTERN char *get_level_author ();
_EXTERN char *get_level_tip ();
_EXTERN int get_game_mode ();
_EXTERN void unload_blocks ();
_EXTERN void draw_maze ();
_EXTERN void set_redraw_rectangles ();
_EXTERN void mark_maze ();
_EXTERN void clear_redraw_map ();
_EXTERN void update_maze ();
_EXTERN void update_expl ();
_EXTERN int check_maze ();
_EXTERN int check_maze_free ();
_EXTERN void set_maze_block ();
_EXTERN int get_extra ();
_EXTERN int distrib_special ();
_EXTERN void distribute_extras (); 
_EXTERN void do_bombs ();
_EXTERN int ignite_players_bombs ();
_EXTERN void ignite_bombs ();
_EXTERN int do_explosions ();
_EXTERN void new_explosion ();
_EXTERN void stun_players ();
_EXTERN int check_explosion ();
_EXTERN int check_bomb ();
_EXTERN int number_of_explosions ();
_EXTERN void delete_outer_bombs ();
_EXTERN void delete_ring_bombs ();
_EXTERN void delete_row_bombs ();
_EXTERN void delete_column_bombs ();
_EXTERN void delete_upper_bombs ();
_EXTERN void delete_bomb_at ();
_EXTERN void move_bomb ();
_EXTERN void copy_expl_block();
_EXTERN void haunt_kick ();
_EXTERN void do_air ();
#endif

#undef _EXTERN

#endif
/*
 * end of file maze.h
 */
