/*
  Include declarations.
*/
#ifdef __hpux
#define _HPUX_SOURCE  1
#endif
#include <stdio.h>
#if defined(__STDC__) || defined(sgi) || defined(_AIX)
#include <stdlib.h>
#include <unistd.h>
#else
#ifdef vms
#include <stdlib.h>
#else
#include <malloc.h>
#include <memory.h>
#endif
#endif
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#ifndef __MWERKS__
#include <sys/types.h>
#include <sys/stat.h>
#else
#include <SIOUX.h>
#include <console.h>
#include <unix.h>
#include <types.h>
#include <stat.h>
#endif
#undef index
#undef assert

/*
  ImageMagick include declarations.
*/
#if defined(__cplusplus) || defined(c_plusplus)
#define class  c_class
#endif
#include "image.h"
#include "gems.h"
#include "compress.h"
#include "utility.h"
#include "monitor.h"
#include "error.h"
#include "X.h"
#include "widget.h"
#include "PreRvIcccm.h"

/*
  Define declarations.
*/
#define AbsoluteValue(x)  ((x) < 0 ? -(x) : (x))
#define DownShift(x) (((int) ((x)+(1L << 13))) >> 14)
#define Extent(string)  ((int) strlen(string))
#define False  0
#define Max(x,y)  (((x) > (y)) ? (x) : (y))
#define Min(x,y)  (((x) < (y)) ? (x) : (y))
#ifndef M_PI
#define M_PI  3.14159265358979323846
#endif
#define QuantumTick(i,image) \
  (((i+1) == image->packets) || ((i % image->rows) == 0))
#define Swap(x,y) ((x)^=(y), (y)^=(x), (x)^=(y))
#ifndef STDIN_FILENO
#define STDIN_FILENO  0
#endif
#define True  1
#define UpShift(x) ((int) (x) << 14)
#define UpShifted(x) ((int) ((x)*(1L << 14)+0.5))

/*
  Review these definitions and change them to suit your local requirements.
*/
#define CompressCommand  "|compress -c > %s"
#define DefaultDisplayGamma  "2.2"
#define DefaultFont  "Helvetica"
#define DefaultImageQuality  "75"
#define DefaultInterlace  PlaneInterlace
#define DefaultPointSize  "18"
#define DefaultPreviewGeometry  "204x204+10+10"
#define DefaultPreviewMatte  "#eee"
#define DefaultPreviewPageGeometry  "3x3"
#define DefaultTileBackground  "#696e7e"
#define DefaultTileBorder  "#000"
#define DefaultTileBorderwidth  "10"
#define DefaultTileForeground  "#600"
#define DefaultTileGeometry  "120x120+20+10"
#define DefaultTileLabel  "%f"
#define DefaultTileMatte  "#ccc"
#define DefaultTilePageGeometry  "5x4"
#define DocumentationURL  \
  "http://www.wizards.dupont.com/cristy/ImageMagick.html"
#define GunzipCommand  "|gzip -cdfq %s"
#define GzipCommand  "|gzip -cf > %s"
#define LauncherCommand  "xpaint %s"
#define PICTCommand  "|picttoppm %s"
#define PostscriptColorDevice  "pnmraw"
#define PostscriptMonoDevice  "pbmraw"
#define ReadBinaryType  "rb"
#define UncompressCommand  "|uncompress -c %s"
#define UndoCache  "16"
#define WriteBinaryType  "wb"
#define WWWCommand  "/usr/local/bin/GET %s:%s > %s 2>&1"

#ifndef vms
#define ApplicationDefaults  "/usr/lib/X11/app-defaults/"
#define BrowseCommand  "netscape %s &"
#define EditorCommand  "xterm -title \"Edit Image Comment\" -e vi %s"
#define PostscriptCommand \
  "gs -sDEVICE=%s -q -dNOPAUSE -dSAFER %s -sOutputFile=%s -- %s < /dev/null > /dev/null"
#define PreferencesDefaults  "~/."
#define PrinterCommand  "lp -c %s"
#define RGBColorDatabase  "/usr/lib/X11/rgb.txt"
#define ShowImageCommand \
  "display -immutable -window_group 0x%lx -title \"%s of %s\" tmp:%s &"
#else
#define ApplicationDefaults  "decw$system_defaults:"
#define BrowseCommand "mosaic %s"
#define EditorCommand  "cre/term/wait edit/tpu %s"
#define PostscriptCommand \
  "gs \"-sDEVICE=%s\" -q \"-dNOPAUSE\" \"-dSAFER\" \"%s\" \"-sOutputFile=%s\" -- \"%s\""
#define PreferencesDefaults  "decw$user_defaults:"
#define PrinterCommand  "print/delete %s"
#define RGBColorDatabase  "sys$common:[sysmgr]decw$rgb.dat"
#define ShowImageCommand \
  "display -immutable -window_group 0x%lx -title \"%s of %s\" tmp:%s"
#endif

#ifndef __MWERKS__
#define ReadCommandlLine(argc,argv)
#else
#define HasJPEG
#define HasPNG
#define HasTIFF
#define ReadCommandlLine(argc,argv)  argc=ccommand(argv); puts(Version);
#endif

/*
  Page geometries:
*/
#define PCLPageGeometry  "612x792+43+43"
#define PCLDensityGeometry  "75x75"
#define PSDensityGeometry  "72x72"
#define PSPageGeometry  "612x792+43+43"
#define TextPageGeometry  "612x792+43+43"
/*
  3D effects.
*/
#define AccentuateModulate  UpScale(80)
#define HighlightModulate  UpScale(125)
#define ShadowModulate  UpScale(135)
#define DepthModulate  UpScale(185)
#define TroughModulate  UpScale(110)
