#ifndef _DAVIS_WINDOW_H_
#define _DAVIS_WINDOW_H_
#include "buffer.h"

struct Window_Type
  {
      unsigned char *beg_pos;   /* buffer pos of top line */
      int beg_line;             /* line number of top */
      int curs_line;            /* line number of curs pos */
      int curs_col;             /* column number of curs pos */
      unsigned char *curs_pos;  /* pos of curs pos */
      int col;                  /* column offset */
      int n_lines;              /* number of lines of buffer (mode dependent) */
      int top;                  /* screen location of top */
      int bot;                  /* screen location of bot */
      int display;              /* value of MOST_S_OPT for selective display */
      char *status;             /* status line */
      Buffer *buf;              /* buffer structure in window */
      struct Window_Type *next; /* next window */
      struct Window_Type *prev; /* prev window */
      int flags;                /* Squeeze lines, etc.. */
      int lock;                 /* true if locked */
  };
typedef struct Window_Type Window;

extern Window *Most_Win;
extern Window *Most_Top_Win;
extern unsigned char *Most_Curs_Pos;
extern int Most_Column;
extern int Most_Curs_Row;
extern int Most_Curs_Col;
extern char Most_Mini_Buf[256];
extern int Most_Selective_Display;
extern int Most_Restore_Width_To;
extern int Most_Display_Inited;

extern int most_split_window (void);
extern void most_toggle_lock(void);
extern void most_update_window(int); /* moves window to have arg lines on the top */
extern void most_update_status(void);
extern void most_redraw_window(void);    /* redraws window updating the structure */
extern void most_window_buffer(void);
extern void most_init_display(void);
extern void most_reset_display(void);
extern void most_other_window(int);
extern void most_set_window(Window *);
extern void most_update_windows(int);
extern void most_message(char *, int);
extern void most_put_message(void);
extern void most_clear_minibuffer(void);
extern void most_check_minibuffer(void);
extern void most_free_window_buffer(void);
extern void most_select_minibuffer(void);
extern void most_exit_minibuffer(void);
extern int most_read_from_minibuffer(char *, char *);
extern void most_redraw_display(void);
extern void most_one_window(void);
extern void most_two_windows(void);
extern void most_delete_window(void);
extern void most_save_win_flags(Window *);
extern void most_free_windows (void);
extern void most_flush_message (char *);
extern void most_point_cursor (void);
#endif

