/*
** Copyright (c) 1996 Thorsten Kukuk 
**
** This file is part of the NYS YP Server.
**
** The NYS YP Server is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS YP Server is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
** 
** You should have received a copy of the GNU General Public
** License along with the NYS YP Server; see the file COPYING.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Author: Thorsten Kukuk <kukuk@uni-paderborn.de>
*/

static char rcsid[] = "$Id: yppush_xdr.c,v 1.0.4.1 1996/07/14 15:10:45 kukuk Exp $";

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "system.h"

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <memory.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "yp.h"

#include "yp_msg.h"
#include "yppush.h"

#if !defined(HAVE_XDR_YPPUSHRESP_XFR)

static bool_t xdr_yppush_status(XDR *xdrs, yppush_status *objp)
{
  if (!xdr_enum(xdrs, (enum_t *)objp)) 
    return (FALSE);

  return (TRUE);
}

static bool_t xdr_yppushresp_xfr(XDR *xdrs, struct yppushresp_xfr *objp)
{
  if (!xdr_u_int(xdrs, &objp->transid))
    return (FALSE);
  
  if (!xdr_yppush_status(xdrs, &objp->status))
    return (FALSE);
  
  return (TRUE);
}
#endif

#if !defined(HAVE_XDR_YPMAP_PARMS)

static bool_t _xdr_domainname(XDR *xdrs, domainname *objp)
{
  if (!xdr_string(xdrs, objp, YPMAXDOMAIN))
    return (FALSE);

  return (TRUE);
}

static bool_t xdr_ypmap_parms(XDR *xdrs, struct ypmap_parms *objp)
{
  if (!_xdr_domainname(xdrs, &objp->domain))
    return (FALSE);
    
  if (!xdr_mapname(xdrs, &objp->map))
    return (FALSE);
    
  if (!xdr_u_int(xdrs, &objp->ordernum))
    return (FALSE);
    
  if (!xdr_peername(xdrs, &objp->peer))
    return (FALSE);
    
  return (TRUE);
}
#endif

#if !defined(HAVE_XDR_YPREQ_XFR)

bool_t xdr_ypreq_xfr(XDR *xdrs, ypreq_xfr *objp)
{
  if (!xdr_ypmap_parms(xdrs, &objp->map_parms)) 
    return (FALSE);

  if (!xdr_u_int(xdrs, &objp->transid)) 
    return (FALSE);

  if (!xdr_u_int(xdrs, &objp->prog))
    return (FALSE);
  
  if (!xdr_u_int(xdrs, &objp->port))
    return (FALSE);
  
  return (TRUE);
}
#endif

char *yppush_err_string(enum yppush_status status) 
{
  switch(status) 
    {
    case YPPUSH_SUCC:      return "Success";
    case YPPUSH_AGE:       return "Master's version not newer";
    case YPPUSH_NOMAP:	   return "Can't find server for map";
    case YPPUSH_NODOM:	   return "Domain not supported";
    case YPPUSH_RSRC:	   return "Local resource alloc failure";
    case YPPUSH_RPC:	   return "RPC failure talking to server";
    case YPPUSH_MADDR:	   return "Can't get master address";
    case YPPUSH_YPERR:	   return "YP server/map db error";
    case YPPUSH_BADARGS:   return "Request arguments bad";
    case YPPUSH_DBM:	   return "Local dbm operation failed";
    case YPPUSH_FILE:	   return "Local file I/O operation failed";
    case YPPUSH_SKEW:	   return "Map version skew during transfer";
    case YPPUSH_CLEAR:	   return "Can't send \"Clear\" req to local ypserv";
    case YPPUSH_FORCE:	   return "No local order number in map  use -f flag.";
    case YPPUSH_XFRERR:	   return "ypxfr error";
    case YPPUSH_REFUSED:   return "Transfer request refused by ypserv";
    }
  return "YPPUSH: Unknown Error, this should not happen!";
}

static void *yppushproc_null_1(void * req, CLIENT * rqstp) 
{
  static void *resp;

  if(verbose_flag > 1)
    yp_msg("yppushproc_null_1\n");

  return &resp;
}

yppushresp_xfr *yppushproc_xfrresp_1_svc(void *req, struct svc_req * rqstp)
{
  static yppushresp_xfr resp;
  struct sockaddr_in *sin;
  char *h;
  struct hostent *hp;
  
  if(verbose_flag > 1)
    yp_msg("yppushproc_xfrresp_1_svc\n");

  sin = svc_getcaller(rqstp->rq_xprt);
  
  hp = gethostbyaddr((char *) &sin->sin_addr.s_addr,
		     sizeof (sin->sin_addr.s_addr), AF_INET);
  h = (hp && hp->h_name) ? hp->h_name : inet_ntoa(sin->sin_addr);

  memcpy(&resp, (yppushresp_xfr*)req, sizeof(yppushresp_xfr));
  if(verbose_flag)
    {
      yp_msg("Status received from ypxfr on %s:\n",h);
      yp_msg("\tTransfer %sdone: %s\n",resp.status==YPPUSH_SUCC?"":"not ",
	     yppush_err_string(resp.status));
    }
  else
    if (resp.status!=YPPUSH_SUCC)
      yp_msg("%s: %s\n", h, yppush_err_string(resp.status));

  return &resp;
}

void yppush_xfrrespprog_1( struct svc_req *rqstp, SVCXPRT *transp)
{
  union {
    int fill;
  } argument;
  static char *result;
  static bool_t (*xdr_argument)(XDR *, void *), (*xdr_result)(XDR *, void *);
  static char *(*local)( void *, struct svc_req *);
 
  if(verbose_flag > 1)
    yp_msg("yppush_xfrrespprog_1\n");
 
  switch (rqstp->rq_proc) 
    {
    case YPPUSHPROC_NULL:
      xdr_argument = (bool_t (*)(XDR *, void *))xdr_void;
      xdr_result = (bool_t (*)(XDR *, void *))xdr_void;
      local = (char *(*)( void *, struct svc_req *)) yppushproc_null_1;
      break;
      
    case YPPUSHPROC_XFRRESP:
      xdr_argument = (bool_t (*) (XDR *, void *))xdr_yppushresp_xfr;
      xdr_result = (bool_t (*)(XDR *, void *))xdr_void;
      local = (char *(*)( void *, struct svc_req *)) yppushproc_xfrresp_1_svc;
      break;
      
    default:
      svcerr_noproc(transp);
      exit(1);
    }
  memset(&argument, '\0',  sizeof(argument));
  if (!svc_getargs(transp, xdr_argument, (void *) &argument)) 
    {
      svcerr_decode(transp);
      exit(1);
    }
  result = (*local)(&argument, rqstp);
  if (result != NULL && 
      !svc_sendreply(transp, (xdrproc_t) xdr_result, result)) 
    {
      svcerr_systemerr(transp);
    }
  if (!svc_freeargs(transp, xdr_argument, (void *) &argument)) 
    {
      yp_msg("unable to free arguments\n");
      exit(1);
      if (rqstp->rq_proc!=YPPUSHPROC_NULL)
	exit(0);
    }
  exit(0);
}

