/* snarf, the Simple Non-interactive All-purpose Resource Fetcher
** Copyright (C) 1995 Zachary Beane
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public LIcense as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is dsitributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILIY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** The author of this program may be reached via email at
** xach@mint.net or via USPS at 17 Talmadge Rd., Waite, ME 04492, USA.
*/
/* simple.c */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdio.h>
#include "protocol.h"
#include "url.h"

int simple_get(struct url u, char *outfile)
{
  FILE *fp;
  struct hostent *host;
  struct sockaddr_in sin;
  register int s, i;
  int fd;
  char send_buf[256];
  char recv_buf[1025];

  /* get the host entry */
  if((host = gethostbyname(u.u_host)) == NULL) {
    fprintf(stderr, "%s: host not found.\n", u.u_host);
    return(0);
  }

  /* get the socket */
  if((s = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
    fprintf(stderr, "Unable to create socket, shitola.\n");
    return(0);
  }

  /* connect the socket, filling in the important stuff */
  sin.sin_family = AF_INET;
  sin.sin_port = htons(u.u_port);
  bcopy(host->h_addr, &sin.sin_addr, host->h_length);
  
  if(connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0){
    fprintf(stderr, "Connection to host %s refused.\n", u.u_host);
    return(0);
  }

  /* get a file descriptor pointing at the right place */
  if(strcmp(outfile, "-") == 0)
    fd = 1;
  else
    if((fd = open(outfile, O_WRONLY | O_CREAT, 0644)) < 0) {
      fprintf(stderr, "Unable to open output file %s for writing.\n", outfile);
      return(0);
    }

  /* fill send_buf with a valid request based on the service type */
  get_request(u, send_buf);

  /* send send_buf to the server */
  send(s, send_buf, strlen(send_buf), 0);

  /* while the server chats with us, write it down for later examination */
  while((i = read(s, recv_buf, sizeof(recv_buf))) > 0)
    write(fd, recv_buf, i);
  
  return(1);
}

/*\
This function takes the url struct and returns a valid request string
to send to the server.
\*/

int get_request(struct url u, char send_buf[])
{
  switch(getport(u.u_service)){
  case FINGER:
    get_finger_request(u, send_buf);
    break;
  case HTTP:
    get_http_request(u, send_buf);
    break;
  case GOPHER:
    get_gopher_request(u, send_buf);
    break;
  default:
    return(0);
  }

  return(1);
}

int get_finger_request(struct url u, char send_buf[])
{
  int i = 0;
  
  while(u.u_file[i] != '\0'){
    send_buf[i] = u.u_file[i];
    i++;
  }
  send_buf[i++] = '\r';
  send_buf[i++] = '\n';
  send_buf[i] = '\0';

  return(1);
}

int get_http_request(struct url u, char send_buf[])
{
  int bp = 4;
  int lp = 0;

  strcpy(send_buf, "GET ");

  for(lp = 0; u.u_path[lp] != '\0'; lp++, bp++){
    send_buf[bp] = u.u_path[lp];
  }
  
  for(lp = 0; u.u_file[lp] != '\0'; lp++, bp++){
    send_buf[bp] = u.u_file[lp];
  }

  send_buf[bp++] = '\r';
  send_buf[bp++] = '\n';
  send_buf[bp] = '\0';

  return(1);
}

int get_gopher_request(struct url u, char send_buf[])
{
  int bp = 0; /* keeps track of the buffer position */
  int lp = 0; /* keeps track of mini-sections like path and file */

  for(lp = 0; u.u_path[lp] != '\0'; lp++, bp++){
    send_buf[bp] = u.u_path[lp];
  }
  
  for(lp = 0; u.u_file[lp] != '\0'; lp++, bp++){
    send_buf[bp] = u.u_file[lp];
  }

  send_buf[bp++] = '\r';
  send_buf[bp++] = '\n';
  send_buf[bp] = '\0';

  return(1);
}
