/*  $Revision: 1.3 $
**
*/
#include <stdio.h>
#include <sys/types.h>
#include <sys/uio.h>


/*
**  "Fake" writev for sites without it.
*/
int
#if defined(__linux__) && defined(__alpha__)
writev(fd, vp, vpc)
    int			fd;
    const struct iovec	*vp;
    size_t		vpc;
#else
writev(fd, vp, vpcount)
    int			fd;
    struct iovec	*vp;
    int			vpcount;
#endif
{
    int			count;
#if defined(__linux__) && defined(__alpha__)
    int			vpcount = (int)vpc;
#endif

    for (count = 0; --vpcount >= 0; count += vp->iov_len, vp++)
	if (xwrite(fd, vp->iov_base, vp->iov_len) < 0)
	    return -1;
    return count;
}
