#include "config.h"
#include "features.h"

#include <stdio.h>
#include <string.h>


#include "hash.h"

unsigned long slrn_compute_hash (unsigned char *s, unsigned char *smax)
{
   register unsigned long h = 0, g;
   register unsigned long sum = 0;
   
   while (s < smax)
     {
	sum += *s++ | 0x20;	       /* case-insensitive */
	
	h = sum + (h << 3);
	if ((g = h & 0xE0000000U) != 0)
	  {
	     h = h ^ (g >> 24);
	     h = h ^ g;
	  }
     }
   return h;
}

#if 0
#define SIZE 1250
unsigned int bin[SIZE];

int main (int argc, char **argv)
{
   unsigned char buf[0x7FFF];
   unsigned char *b, ch;
   unsigned long hash;
   int i;
   
   while (NULL != fgets ((char *) buf, sizeof (buf) - 1, stdin))
     {
	b = buf;
	while (((ch = *b) != '!') && (ch != ':') && (ch > ' '))
	  b++;
	
	hash = slrn_compute_hash (buf, b);
	hash = hash % SIZE;
	
	/* fprintf (stdout, "%X\n", hash); */
	bin[hash] += 1;
     }
   
   for (i = 0; i < SIZE; i++)
     {
	fprintf (stdout, "%d\t%d\n", i, bin[i]);
     }
   return 0;
}
#endif
