#ifndef _SLRN_MISC_H
#define _SLRN_MISC_H

#include <stdio.h>
#include <slang.h>
extern void slrn_make_home_filename (char *, char *);
extern int slrn_make_home_dirname (char *, char *);
extern void slrn_redraw (void);
extern void (*Slrn_redraw_function)(void);
extern int Slrn_Full_Screen_Update;
extern int slrn_message (char *, ...);
extern void slrn_error (char *, ...);
extern int slrn_get_yesno (int, char *, ...);
extern int slrn_get_yesno_cancel (char *str, ...);
extern void slrn_clear_message (void);
extern void slrn_print_percent (int, int, int, int, int);
extern FILE *slrn_open_home_file (char *, char *, char *, int);
extern void slrn_suspend_cmd (void);
extern int slrn_read_integer (char *, int *, int *);
extern int slrn_read_input (char *, char *, int);
extern void update_top_status_line (void);
extern void slrn_set_color (int);
extern char slrn_get_response (char *, char *str, ...);
extern int slrn_is_fqdn (char *);
extern int slrn_init_readline (void);
extern char *slrn_make_startup_string (char *);

#define MAX_HOST_NAME_LEN 256
typedef struct
{
   char *realname;
   char *username;
   char host[MAX_HOST_NAME_LEN];
   char *replyto;
   char *org;
   char *followup_string;
   char *signature;
   char *nnrpname;
   char *nnrppass;
   char *posting_host;		       /* FQDN or NULL */
}
Slrn_User_Info_Type;

extern Slrn_User_Info_Type Slrn_User_Info;
extern void slrn_get_user_info (void);
extern int slrn_edit_file (char *, unsigned int);
extern  int slrn_mail_file (char *, int, unsigned int, char *, char *);

extern void slrn_article_help (void);
extern void slrn_group_help (void);
extern char *slrn_fix_regexp (char *);

extern int Slrn_Message_Present;
extern int Slrn_User_Wants_Confirmation;
extern int slrn_case_strncmp (unsigned char *, unsigned char *, unsigned int);
extern int slrn_case_strcmp (unsigned char *, unsigned char *);
extern int slrn_file_exists (char *);
extern void slrn_get_mouse_rc (int *, int *);
extern int slrn_delete_file (char *);
#ifndef VMS
extern char *Slrn_SendMail_Command;
#endif

#if SLRN_HAS_PIPING
extern FILE *slrn_popen (char *, char *);
extern int slrn_pclose (FILE *);
#endif

extern char *slrn_simple_strtok (char *, char *);
extern char *slrn_strchr (char *, char);
extern char *slrn_skip_whitespace (char *s);
extern char *slrn_trim_string (char *s);

extern int Slrn_Use_Tmpdir;
extern FILE *slrn_open_tmpfile (char *, char *);
extern int slrn_posix_system (char *, int);
extern char *Slrn_Editor;
extern int slrn_fclose (FILE *);

#endif				       /* _SLRN_MISC_H */
