#include "prompt.h"

#include <stdio.h> 
#include <unistd.h>

void Prompt::showprompt () const
{
    register char
	*cp;
    char
	cwdbuf [MAXPATH];

    if (! isatty (fileno (stdout)))
	return;

    if (! (cp = promptstring))
	cp = "\\n%/> ";
    while (*cp)
    {
	switch (*cp)
	{
	    case '%':
		cp++;
		switch (*cp)
		{
		    case '/':
			if (! getcwd (cwdbuf, MAXPATH - 1))
			    warning ("can't get current working dir");
			else
			    printf ("%s", cwdbuf);
			break;
		    default:
			putchar ('%');
			break;
		}
		break;
	    case '\\':
		cp++;
		switch (*cp)
		{
		    case 'n':
			putchar ('\n');
			break;
		    default:
			putchar ('\\');
			break;
		}
		break;
	    default:
		putchar (*cp);
		break;
	}
	if (*cp)
	    cp++;
    }
}
