#include "program/program.h"
#include "input/input.h"
#include "string/string.h" 
#include <new.h>
#include <stdio.h>
#include <stdlib.h> 

Program
    program;

static void out_of_memory ()
{
    fprintf (stderr, "%s: memory allocation failure\n",
	     program.getprogname ().get ());
    exit (1);
}

int main (int argc, char **argv)
{
    set_new_handler (out_of_memory);

    program.setprogname (argv [0]);
    program.arglist (argc, argv);
    program.setlevel ();
    if (program.isshell ())
    {
	if (! program.redirected ())
	    program.banner ();
	while (1)
	{
	    Input
		in;
	    in.read ();
	}
    }
    else
	return (program.runcommand ());
    
    return (0);
}
