#ifndef _STRING_H_
#define _STRING_H_

#include "../storable/storable.h"

class String: public Storable
{
    public:
	~String ();
	String ();
	String (String const &other);
	String (char const *s);

	String const &operator= (String const &other);

	void set (char const *s);
	void cat (String const &other);
	void cat (int ch);

	int operator== (String const &other) const;
    
	char const *get () const;
    
	Storable *dup () const;

    private:
	void copy (String const &other);
	void destroy ();

	char *data;
};

#endif
