/* Copyright (C) 1994 
            Olav Woelfelschneider (wosch@rbg.informatik.th-darmstadt.de)

 This library is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include "McApp.h"
#include "McGadget.h"
#include "McInfoRequest.h"
#include "McDebug.h"

#ifdef linux

#include "stdio.h"
#include "fcntl.h"
#include "unistd.h"

void McDebug(McApp *app, int id) {
  int file, rd, d;
  char buf[1000], c, s[1000];
  sprintf(buf,"/proc/%d/stat",getpid());
  file=open(buf, O_RDONLY);
  rd = read(file,buf,1000);
  close(file);
  if (rd>0) {
    sscanf(buf,
   "%d %s %c %d %d %d %d %d %u %u %u %u %u %d %d %d %d %d %d %u %u %u %u",
	   &d,s,&c,&d,&d,&d,&d,&d,&d,&d,&d,&d,&d,&d,&d,
	   &d,&d,&d,&d,&d,&d,&d,&d);

    sprintf(buf, "%s: %d -> memsize=%d\n",s, id, d);
    McCreateInfoRequest(app, "Info", buf, NULL, "What, that much?",
			NULL, NULL);
  } else {
    printf("Cannot read status.\n");
  }
}

#else
void debug(int id) { }
#endif

static char *eventlist[] = {
  "","",
  "KeyPress","KeyRelease",
  "ButtonPress", "ButtonRelease",
  "MotionNotify", "EnterNotify", "LeaveNotify",
  "FocusIn", "FocusOut",
  "KeymapNotify",
  "Expose", "GraphicsExpose", "NoExpose",
  "VisibilityNotify",
  "CreateNotify",
  "DestroyNotify",
  "UnmapNotify", "MapNotify",
  "MapRequest",
  "ReparentNotify",
  "ConfigureNotify",
  "ConfigureRequest",
  "GravityNotify",
  "ResizeRequest",
  "CirculateNotify",
  "CirculateRequest",
  "PropertyNotify",
  "SelectionClear",
  "SelectionRequest",
  "SelectionNotify",
  "ColormapNotify",
  "ClientMessage",
  "MappingNotify",
};

char *McEventName(int event) {
  return eventlist[event];
}

typedef struct keysymtrans {
  KeySym key;
  char *name;
} keysymtrans;

static keysymtrans keysymtable[] = {
  { XK_VoidSymbol, "XK_VoidSymbol" },
#ifdef XK_MISCELLANY
  { XK_BackSpace, "XK_BackSpace" },
  { XK_Tab, "XK_Tab" },
  { XK_Linefeed, "XK_Linefeed" },
  { XK_Clear, "XK_Clear" },
  { XK_Return, "XK_Return" },
  { XK_Pause, "XK_Pause" },
  { XK_Scroll_Lock, "XK_Scroll_Lock" },
  { XK_Escape, "XK_Escape" },
  { XK_Delete, "XK_Delete" },
  { XK_Multi_key, "XK_Multi_key" },
  { XK_Kanji, "XK_Kanji" },
  { XK_Muhenkan, "XK_Muhenkan" },
  { XK_Henkan_Mode, "XK_Henkan_Mode" },
  { XK_Henkan, "XK_Henkan" },
  { XK_Romaji, "XK_Romaji" },
  { XK_Hiragana, "XK_Hiragana" },
  { XK_Katakana, "XK_Katakana" },
  { XK_Hiragana_Katakana, "XK_Hiragana_Katakana" },
  { XK_Zenkaku, "XK_Zenkaku" },
  { XK_Hankaku, "XK_Hankaku" },
  { XK_Zenkaku_Hankaku, "XK_Zenkaku_Hankaku" },
  { XK_Touroku, "XK_Touroku" },
  { XK_Massyo, "XK_Massyo" },
  { XK_Kana_Lock, "XK_Kana_Lock" },
  { XK_Kana_Shift, "XK_Kana_Shift" },
  { XK_Eisu_Shift, "XK_Eisu_Shift" },
  { XK_Eisu_toggle, "XK_Eisu_toggle" },
  { XK_Home, "XK_Home" },
  { XK_Left, "XK_Left" },
  { XK_Up, "XK_Up" },
  { XK_Right, "XK_Right" },
  { XK_Down, "XK_Down" },
  { XK_Prior, "XK_Prior" },
  { XK_Next, "XK_Next" },
  { XK_End, "XK_End" },
  { XK_Begin, "XK_Begin" },
  { XK_Select, "XK_Select" },
  { XK_Print, "XK_Print" },
  { XK_Execute, "XK_Execute" },
  { XK_Insert, "XK_Insert" },
  { XK_Undo, "XK_Undo" },
  { XK_Redo, "XK_Redo" },
  { XK_Menu, "XK_Menu" },
  { XK_Find, "XK_Find" },
  { XK_Cancel, "XK_Cancel" },
  { XK_Help, "XK_Help" },
  { XK_Break, "XK_Break" },
  { XK_Mode_switch, "XK_Mode_switch" },
  { XK_script_switch, "XK_script_switch" },
  { XK_Num_Lock, "XK_Num_Lock" },
  { XK_KP_Space, "XK_KP_Space" },
  { XK_KP_Tab, "XK_KP_Tab" },
  { XK_KP_Enter, "XK_KP_Enter" },
  { XK_KP_F1, "XK_KP_F1" },
  { XK_KP_F2, "XK_KP_F2" },
  { XK_KP_F3, "XK_KP_F3" },
  { XK_KP_F4, "XK_KP_F4" },
  { XK_KP_Equal, "XK_KP_Equal" },
  { XK_KP_Multiply, "XK_KP_Multiply" },
  { XK_KP_Add, "XK_KP_Add" },
  { XK_KP_Separator, "XK_KP_Separator" },
  { XK_KP_Subtract, "XK_KP_Subtract" },
  { XK_KP_Decimal, "XK_KP_Decimal" },
  { XK_KP_Divide, "XK_KP_Divide" },
  { XK_KP_0, "XK_KP_0" },
  { XK_KP_1, "XK_KP_1" },
  { XK_KP_2, "XK_KP_2" },
  { XK_KP_3, "XK_KP_3" },
  { XK_KP_4, "XK_KP_4" },
  { XK_KP_5, "XK_KP_5" },
  { XK_KP_6, "XK_KP_6" },
  { XK_KP_7, "XK_KP_7" },
  { XK_KP_8, "XK_KP_8" },
  { XK_KP_9, "XK_KP_9" },
  { XK_F1, "XK_F1" },
  { XK_F2, "XK_F2" },
  { XK_F3, "XK_F3" },
  { XK_F4, "XK_F4" },
  { XK_F5, "XK_F5" },
  { XK_F6, "XK_F6" },
  { XK_F7, "XK_F7" },
  { XK_F8, "XK_F8" },
  { XK_F9, "XK_F9" },
  { XK_F10, "XK_F10" },
  { XK_F11, "XK_F11" },
  { XK_L1, "XK_L1" },
  { XK_F12, "XK_F12" },
  { XK_L2, "XK_L2" },
  { XK_F13, "XK_F13" },
  { XK_L3, "XK_L3" },
  { XK_F14, "XK_F14" },
  { XK_L4, "XK_L4" },
  { XK_F15, "XK_F15" },
  { XK_L5, "XK_L5" },
  { XK_F16, "XK_F16" },
  { XK_L6, "XK_L6" },
  { XK_F17, "XK_F17" },
  { XK_L7, "XK_L7" },
  { XK_F18, "XK_F18" },
  { XK_L8, "XK_L8" },
  { XK_F19, "XK_F19" },
  { XK_L9, "XK_L9" },
  { XK_F20, "XK_F20" },
  { XK_L10, "XK_L10" },
  { XK_F21, "XK_F21" },
  { XK_R1, "XK_R1" },
  { XK_F22, "XK_F22" },
  { XK_R2, "XK_R2" },
  { XK_F23, "XK_F23" },
  { XK_R3, "XK_R3" },
  { XK_F24, "XK_F24" },
  { XK_R4, "XK_R4" },
  { XK_F25, "XK_F25" },
  { XK_R5, "XK_R5" },
  { XK_F26, "XK_F26" },
  { XK_R6, "XK_R6" },
  { XK_F27, "XK_F27" },
  { XK_R7, "XK_R7" },
  { XK_F28, "XK_F28" },
  { XK_R8, "XK_R8" },
  { XK_F29, "XK_F29" },
  { XK_R9, "XK_R9" },
  { XK_F30, "XK_F30" },
  { XK_R10, "XK_R10" },
  { XK_F31, "XK_F31" },
  { XK_R11, "XK_R11" },
  { XK_F32, "XK_F32" },
  { XK_R12, "XK_R12" },
  { XK_F33, "XK_F33" },
  { XK_R13, "XK_R13" },
  { XK_F34, "XK_F34" },
  { XK_R14, "XK_R14" },
  { XK_F35, "XK_F35" },
  { XK_R15, "XK_R15" },
  { XK_Shift_L, "XK_Shift_L" },
  { XK_Shift_R, "XK_Shift_R" },
  { XK_Control_L, "XK_Control_L" },
  { XK_Control_R, "XK_Control_R" },
  { XK_Caps_Lock, "XK_Caps_Lock" },
  { XK_Shift_Lock, "XK_Shift_Lock" },
  { XK_Meta_L, "XK_Meta_L" },
  { XK_Meta_R, "XK_Meta_R" },
  { XK_Alt_L, "XK_Alt_L" },
  { XK_Alt_R, "XK_Alt_R" },
  { XK_Super_L, "XK_Super_L" },
  { XK_Super_R, "XK_Super_R" },
  { XK_Hyper_L, "XK_Hyper_L" },
  { XK_Hyper_R, "XK_Hyper_R" },
#endif /* XK_MISCELLANY */
#ifdef XK_LATIN1
  { XK_space, "XK_space" },
  { XK_exclam, "XK_exclam" },
  { XK_quotedbl, "XK_quotedbl" },
  { XK_numbersign, "XK_numbersign" },
  { XK_dollar, "XK_dollar" },
  { XK_percent, "XK_percent" },
  { XK_ampersand, "XK_ampersand" },
  { XK_apostrophe, "XK_apostrophe" },
  { XK_quoteright, "XK_quoteright" },
  { XK_parenleft, "XK_parenleft" },
  { XK_parenright, "XK_parenright" },
  { XK_asterisk, "XK_asterisk" },
  { XK_plus, "XK_plus" },
  { XK_comma, "XK_comma" },
  { XK_minus, "XK_minus" },
  { XK_period, "XK_period" },
  { XK_slash, "XK_slash" },
  { XK_0, "XK_0" },
  { XK_1, "XK_1" },
  { XK_2, "XK_2" },
  { XK_3, "XK_3" },
  { XK_4, "XK_4" },
  { XK_5, "XK_5" },
  { XK_6, "XK_6" },
  { XK_7, "XK_7" },
  { XK_8, "XK_8" },
  { XK_9, "XK_9" },
  { XK_colon, "XK_colon" },
  { XK_semicolon, "XK_semicolon" },
  { XK_less, "XK_less" },
  { XK_equal, "XK_equal" },
  { XK_greater, "XK_greater" },
  { XK_question, "XK_question" },
  { XK_at, "XK_at" },
  { XK_A, "XK_A" },
  { XK_B, "XK_B" },
  { XK_C, "XK_C" },
  { XK_D, "XK_D" },
  { XK_E, "XK_E" },
  { XK_F, "XK_F" },
  { XK_G, "XK_G" },
  { XK_H, "XK_H" },
  { XK_I, "XK_I" },
  { XK_J, "XK_J" },
  { XK_K, "XK_K" },
  { XK_L, "XK_L" },
  { XK_M, "XK_M" },
  { XK_N, "XK_N" },
  { XK_O, "XK_O" },
  { XK_P, "XK_P" },
  { XK_Q, "XK_Q" },
  { XK_R, "XK_R" },
  { XK_S, "XK_S" },
  { XK_T, "XK_T" },
  { XK_U, "XK_U" },
  { XK_V, "XK_V" },
  { XK_W, "XK_W" },
  { XK_X, "XK_X" },
  { XK_Y, "XK_Y" },
  { XK_Z, "XK_Z" },
  { XK_bracketleft, "XK_bracketleft" },
  { XK_backslash, "XK_backslash" },
  { XK_bracketright, "XK_bracketright" },
  { XK_asciicircum, "XK_asciicircum" },
  { XK_underscore, "XK_underscore" },
  { XK_grave, "XK_grave" },
  { XK_quoteleft, "XK_quoteleft" },
  { XK_a, "XK_a" },
  { XK_b, "XK_b" },
  { XK_c, "XK_c" },
  { XK_d, "XK_d" },
  { XK_e, "XK_e" },
  { XK_f, "XK_f" },
  { XK_g, "XK_g" },
  { XK_h, "XK_h" },
  { XK_i, "XK_i" },
  { XK_j, "XK_j" },
  { XK_k, "XK_k" },
  { XK_l, "XK_l" },
  { XK_m, "XK_m" },
  { XK_n, "XK_n" },
  { XK_o, "XK_o" },
  { XK_p, "XK_p" },
  { XK_q, "XK_q" },
  { XK_r, "XK_r" },
  { XK_s, "XK_s" },
  { XK_t, "XK_t" },
  { XK_u, "XK_u" },
  { XK_v, "XK_v" },
  { XK_w, "XK_w" },
  { XK_x, "XK_x" },
  { XK_y, "XK_y" },
  { XK_z, "XK_z" },
  { XK_braceleft, "XK_braceleft" },
  { XK_bar, "XK_bar" },
  { XK_braceright, "XK_braceright" },
  { XK_asciitilde, "XK_asciitilde" },
  { XK_nobreakspace, "XK_nobreakspace" },
  { XK_exclamdown, "XK_exclamdown" },
  { XK_cent, "XK_cent" },
  { XK_sterling, "XK_sterling" },
  { XK_currency, "XK_currency" },
  { XK_yen, "XK_yen" },
  { XK_brokenbar, "XK_brokenbar" },
  { XK_section, "XK_section" },
  { XK_diaeresis, "XK_diaeresis" },
  { XK_copyright, "XK_copyright" },
  { XK_ordfeminine, "XK_ordfeminine" },
  { XK_guillemotleft, "XK_guillemotleft" },
  { XK_notsign, "XK_notsign" },
  { XK_hyphen, "XK_hyphen" },
  { XK_registered, "XK_registered" },
  { XK_macron, "XK_macron" },
  { XK_degree, "XK_degree" },
  { XK_plusminus, "XK_plusminus" },
  { XK_twosuperior, "XK_twosuperior" },
  { XK_threesuperior, "XK_threesuperior" },
  { XK_acute, "XK_acute" },
  { XK_mu, "XK_mu" },
  { XK_paragraph, "XK_paragraph" },
  { XK_periodcentered, "XK_periodcentered" },
  { XK_cedilla, "XK_cedilla" },
  { XK_onesuperior, "XK_onesuperior" },
  { XK_masculine, "XK_masculine" },
  { XK_guillemotright, "XK_guillemotright" },
  { XK_onequarter, "XK_onequarter" },
  { XK_onehalf, "XK_onehalf" },
  { XK_threequarters, "XK_threequarters" },
  { XK_questiondown, "XK_questiondown" },
  { XK_Agrave, "XK_Agrave" },
  { XK_Aacute, "XK_Aacute" },
  { XK_Acircumflex, "XK_Acircumflex" },
  { XK_Atilde, "XK_Atilde" },
  { XK_Adiaeresis, "XK_Adiaeresis" },
  { XK_Aring, "XK_Aring" },
  { XK_AE, "XK_AE" },
  { XK_Ccedilla, "XK_Ccedilla" },
  { XK_Egrave, "XK_Egrave" },
  { XK_Eacute, "XK_Eacute" },
  { XK_Ecircumflex, "XK_Ecircumflex" },
  { XK_Ediaeresis, "XK_Ediaeresis" },
  { XK_Igrave, "XK_Igrave" },
  { XK_Iacute, "XK_Iacute" },
  { XK_Icircumflex, "XK_Icircumflex" },
  { XK_Idiaeresis, "XK_Idiaeresis" },
  { XK_ETH, "XK_ETH" },
  { XK_Eth, "XK_Eth" },
  { XK_Ntilde, "XK_Ntilde" },
  { XK_Ograve, "XK_Ograve" },
  { XK_Oacute, "XK_Oacute" },
  { XK_Ocircumflex, "XK_Ocircumflex" },
  { XK_Otilde, "XK_Otilde" },
  { XK_Odiaeresis, "XK_Odiaeresis" },
  { XK_multiply, "XK_multiply" },
  { XK_Ooblique, "XK_Ooblique" },
  { XK_Ugrave, "XK_Ugrave" },
  { XK_Uacute, "XK_Uacute" },
  { XK_Ucircumflex, "XK_Ucircumflex" },
  { XK_Udiaeresis, "XK_Udiaeresis" },
  { XK_Yacute, "XK_Yacute" },
  { XK_THORN, "XK_THORN" },
  { XK_Thorn, "XK_Thorn" },
  { XK_ssharp, "XK_ssharp" },
  { XK_agrave, "XK_agrave" },
  { XK_aacute, "XK_aacute" },
  { XK_acircumflex, "XK_acircumflex" },
  { XK_atilde, "XK_atilde" },
  { XK_adiaeresis, "XK_adiaeresis" },
  { XK_aring, "XK_aring" },
  { XK_ae, "XK_ae" },
  { XK_ccedilla, "XK_ccedilla" },
  { XK_egrave, "XK_egrave" },
  { XK_eacute, "XK_eacute" },
  { XK_ecircumflex, "XK_ecircumflex" },
  { XK_ediaeresis, "XK_ediaeresis" },
  { XK_igrave, "XK_igrave" },
  { XK_iacute, "XK_iacute" },
  { XK_icircumflex, "XK_icircumflex" },
  { XK_idiaeresis, "XK_idiaeresis" },
  { XK_eth, "XK_eth" },
  { XK_ntilde, "XK_ntilde" },
  { XK_ograve, "XK_ograve" },
  { XK_oacute, "XK_oacute" },
  { XK_ocircumflex, "XK_ocircumflex" },
  { XK_otilde, "XK_otilde" },
  { XK_odiaeresis, "XK_odiaeresis" },
  { XK_division, "XK_division" },
  { XK_oslash, "XK_oslash" },
  { XK_ugrave, "XK_ugrave" },
  { XK_uacute, "XK_uacute" },
  { XK_ucircumflex, "XK_ucircumflex" },
  { XK_udiaeresis, "XK_udiaeresis" },
  { XK_yacute, "XK_yacute" },
  { XK_thorn, "XK_thorn" },
  { XK_ydiaeresis, "XK_ydiaeresis" },
#endif /* XK_LATIN1 */
#ifdef XK_LATIN2
  { XK_Aogonek, "XK_Aogonek" },
  { XK_breve, "XK_breve" },
  { XK_Lstroke, "XK_Lstroke" },
  { XK_Lcaron, "XK_Lcaron" },
  { XK_Sacute, "XK_Sacute" },
  { XK_Scaron, "XK_Scaron" },
  { XK_Scedilla, "XK_Scedilla" },
  { XK_Tcaron, "XK_Tcaron" },
  { XK_Zacute, "XK_Zacute" },
  { XK_Zcaron, "XK_Zcaron" },
  { XK_Zabovedot, "XK_Zabovedot" },
  { XK_aogonek, "XK_aogonek" },
  { XK_ogonek, "XK_ogonek" },
  { XK_lstroke, "XK_lstroke" },
  { XK_lcaron, "XK_lcaron" },
  { XK_sacute, "XK_sacute" },
  { XK_caron, "XK_caron" },
  { XK_scaron, "XK_scaron" },
  { XK_scedilla, "XK_scedilla" },
  { XK_tcaron, "XK_tcaron" },
  { XK_zacute, "XK_zacute" },
  { XK_doubleacute, "XK_doubleacute" },
  { XK_zcaron, "XK_zcaron" },
  { XK_zabovedot, "XK_zabovedot" },
  { XK_Racute, "XK_Racute" },
  { XK_Abreve, "XK_Abreve" },
  { XK_Lacute, "XK_Lacute" },
  { XK_Cacute, "XK_Cacute" },
  { XK_Ccaron, "XK_Ccaron" },
  { XK_Eogonek, "XK_Eogonek" },
  { XK_Ecaron, "XK_Ecaron" },
  { XK_Dcaron, "XK_Dcaron" },
  { XK_Dstroke, "XK_Dstroke" },
  { XK_Nacute, "XK_Nacute" },
  { XK_Ncaron, "XK_Ncaron" },
  { XK_Odoubleacute, "XK_Odoubleacute" },
  { XK_Rcaron, "XK_Rcaron" },
  { XK_Uring, "XK_Uring" },
  { XK_Udoubleacute, "XK_Udoubleacute" },
  { XK_Tcedilla, "XK_Tcedilla" },
  { XK_racute, "XK_racute" },
  { XK_abreve, "XK_abreve" },
  { XK_lacute, "XK_lacute" },
  { XK_cacute, "XK_cacute" },
  { XK_ccaron, "XK_ccaron" },
  { XK_eogonek, "XK_eogonek" },
  { XK_ecaron, "XK_ecaron" },
  { XK_dcaron, "XK_dcaron" },
  { XK_dstroke, "XK_dstroke" },
  { XK_nacute, "XK_nacute" },
  { XK_ncaron, "XK_ncaron" },
  { XK_odoubleacute, "XK_odoubleacute" },
  { XK_udoubleacute, "XK_udoubleacute" },
  { XK_rcaron, "XK_rcaron" },
  { XK_uring, "XK_uring" },
  { XK_tcedilla, "XK_tcedilla" },
  { XK_abovedot, "XK_abovedot" },
#endif /* XK_LATIN2 */
#ifdef XK_LATIN3
  { XK_Hstroke, "XK_Hstroke" },
  { XK_Hcircumflex, "XK_Hcircumflex" },
  { XK_Iabovedot, "XK_Iabovedot" },
  { XK_Gbreve, "XK_Gbreve" },
  { XK_Jcircumflex, "XK_Jcircumflex" },
  { XK_hstroke, "XK_hstroke" },
  { XK_hcircumflex, "XK_hcircumflex" },
  { XK_idotless, "XK_idotless" },
  { XK_gbreve, "XK_gbreve" },
  { XK_jcircumflex, "XK_jcircumflex" },
  { XK_Cabovedot, "XK_Cabovedot" },
  { XK_Ccircumflex, "XK_Ccircumflex" },
  { XK_Gabovedot, "XK_Gabovedot" },
  { XK_Gcircumflex, "XK_Gcircumflex" },
  { XK_Ubreve, "XK_Ubreve" },
  { XK_Scircumflex, "XK_Scircumflex" },
  { XK_cabovedot, "XK_cabovedot" },
  { XK_ccircumflex, "XK_ccircumflex" },
  { XK_gabovedot, "XK_gabovedot" },
  { XK_gcircumflex, "XK_gcircumflex" },
  { XK_ubreve, "XK_ubreve" },
  { XK_scircumflex, "XK_scircumflex" },
#endif /* XK_LATIN3 */
#ifdef XK_LATIN4
  { XK_kra, "XK_kra" },
  { XK_kappa, "XK_kappa" },
  { XK_Rcedilla, "XK_Rcedilla" },
  { XK_Itilde, "XK_Itilde" },
  { XK_Lcedilla, "XK_Lcedilla" },
  { XK_Emacron, "XK_Emacron" },
  { XK_Gcedilla, "XK_Gcedilla" },
  { XK_Tslash, "XK_Tslash" },
  { XK_rcedilla, "XK_rcedilla" },
  { XK_itilde, "XK_itilde" },
  { XK_lcedilla, "XK_lcedilla" },
  { XK_emacron, "XK_emacron" },
  { XK_gcedilla, "XK_gcedilla" },
  { XK_tslash, "XK_tslash" },
  { XK_ENG, "XK_ENG" },
  { XK_eng, "XK_eng" },
  { XK_Amacron, "XK_Amacron" },
  { XK_Iogonek, "XK_Iogonek" },
  { XK_Eabovedot, "XK_Eabovedot" },
  { XK_Imacron, "XK_Imacron" },
  { XK_Ncedilla, "XK_Ncedilla" },
  { XK_Omacron, "XK_Omacron" },
  { XK_Kcedilla, "XK_Kcedilla" },
  { XK_Uogonek, "XK_Uogonek" },
  { XK_Utilde, "XK_Utilde" },
  { XK_Umacron, "XK_Umacron" },
  { XK_amacron, "XK_amacron" },
  { XK_iogonek, "XK_iogonek" },
  { XK_eabovedot, "XK_eabovedot" },
  { XK_imacron, "XK_imacron" },
  { XK_ncedilla, "XK_ncedilla" },
  { XK_omacron, "XK_omacron" },
  { XK_kcedilla, "XK_kcedilla" },
  { XK_uogonek, "XK_uogonek" },
  { XK_utilde, "XK_utilde" },
  { XK_umacron, "XK_umacron" },
#endif /* XK_LATIN4 */
#ifdef XK_KATAKANA
  { XK_overline, "XK_overline" },
  { XK_kana_fullstop, "XK_kana_fullstop" },
  { XK_kana_openingbracket, "XK_kana_openingbracket" },
  { XK_kana_closingbracket, "XK_kana_closingbracket" },
  { XK_kana_comma, "XK_kana_comma" },
  { XK_kana_conjunctive, "XK_kana_conjunctive" },
  { XK_kana_middledot, "XK_kana_middledot" },
  { XK_kana_WO, "XK_kana_WO" },
  { XK_kana_a, "XK_kana_a" },
  { XK_kana_i, "XK_kana_i" },
  { XK_kana_u, "XK_kana_u" },
  { XK_kana_e, "XK_kana_e" },
  { XK_kana_o, "XK_kana_o" },
  { XK_kana_ya, "XK_kana_ya" },
  { XK_kana_yu, "XK_kana_yu" },
  { XK_kana_yo, "XK_kana_yo" },
  { XK_kana_tsu, "XK_kana_tsu" },
  { XK_kana_tu, "XK_kana_tu" },
  { XK_prolongedsound, "XK_prolongedsound" },
  { XK_kana_A, "XK_kana_A" },
  { XK_kana_I, "XK_kana_I" },
  { XK_kana_U, "XK_kana_U" },
  { XK_kana_E, "XK_kana_E" },
  { XK_kana_O, "XK_kana_O" },
  { XK_kana_KA, "XK_kana_KA" },
  { XK_kana_KI, "XK_kana_KI" },
  { XK_kana_KU, "XK_kana_KU" },
  { XK_kana_KE, "XK_kana_KE" },
  { XK_kana_KO, "XK_kana_KO" },
  { XK_kana_SA, "XK_kana_SA" },
  { XK_kana_SHI, "XK_kana_SHI" },
  { XK_kana_SU, "XK_kana_SU" },
  { XK_kana_SE, "XK_kana_SE" },
  { XK_kana_SO, "XK_kana_SO" },
  { XK_kana_TA, "XK_kana_TA" },
  { XK_kana_CHI, "XK_kana_CHI" },
  { XK_kana_TI, "XK_kana_TI" },
  { XK_kana_TSU, "XK_kana_TSU" },
  { XK_kana_TU, "XK_kana_TU" },
  { XK_kana_TE, "XK_kana_TE" },
  { XK_kana_TO, "XK_kana_TO" },
  { XK_kana_NA, "XK_kana_NA" },
  { XK_kana_NI, "XK_kana_NI" },
  { XK_kana_NU, "XK_kana_NU" },
  { XK_kana_NE, "XK_kana_NE" },
  { XK_kana_NO, "XK_kana_NO" },
  { XK_kana_HA, "XK_kana_HA" },
  { XK_kana_HI, "XK_kana_HI" },
  { XK_kana_FU, "XK_kana_FU" },
  { XK_kana_HU, "XK_kana_HU" },
  { XK_kana_HE, "XK_kana_HE" },
  { XK_kana_HO, "XK_kana_HO" },
  { XK_kana_MA, "XK_kana_MA" },
  { XK_kana_MI, "XK_kana_MI" },
  { XK_kana_MU, "XK_kana_MU" },
  { XK_kana_ME, "XK_kana_ME" },
  { XK_kana_MO, "XK_kana_MO" },
  { XK_kana_YA, "XK_kana_YA" },
  { XK_kana_YU, "XK_kana_YU" },
  { XK_kana_YO, "XK_kana_YO" },
  { XK_kana_RA, "XK_kana_RA" },
  { XK_kana_RI, "XK_kana_RI" },
  { XK_kana_RU, "XK_kana_RU" },
  { XK_kana_RE, "XK_kana_RE" },
  { XK_kana_RO, "XK_kana_RO" },
  { XK_kana_WA, "XK_kana_WA" },
  { XK_kana_N, "XK_kana_N" },
  { XK_voicedsound, "XK_voicedsound" },
  { XK_semivoicedsound, "XK_semivoicedsound" },
  { XK_kana_switch, "XK_kana_switch" },
#endif /* XK_KATAKANA */
#ifdef XK_ARABIC
  { XK_Arabic_comma, "XK_Arabic_comma" },
  { XK_Arabic_semicolon, "XK_Arabic_semicolon" },
  { XK_Arabic_question_mark, "XK_Arabic_question_mark" },
  { XK_Arabic_hamza, "XK_Arabic_hamza" },
  { XK_Arabic_maddaonalef, "XK_Arabic_maddaonalef" },
  { XK_Arabic_hamzaonalef, "XK_Arabic_hamzaonalef" },
  { XK_Arabic_hamzaonwaw, "XK_Arabic_hamzaonwaw" },
  { XK_Arabic_hamzaunderalef, "XK_Arabic_hamzaunderalef" },
  { XK_Arabic_hamzaonyeh, "XK_Arabic_hamzaonyeh" },
  { XK_Arabic_alef, "XK_Arabic_alef" },
  { XK_Arabic_beh, "XK_Arabic_beh" },
  { XK_Arabic_tehmarbuta, "XK_Arabic_tehmarbuta" },
  { XK_Arabic_teh, "XK_Arabic_teh" },
  { XK_Arabic_theh, "XK_Arabic_theh" },
  { XK_Arabic_jeem, "XK_Arabic_jeem" },
  { XK_Arabic_hah, "XK_Arabic_hah" },
  { XK_Arabic_khah, "XK_Arabic_khah" },
  { XK_Arabic_dal, "XK_Arabic_dal" },
  { XK_Arabic_thal, "XK_Arabic_thal" },
  { XK_Arabic_ra, "XK_Arabic_ra" },
  { XK_Arabic_zain, "XK_Arabic_zain" },
  { XK_Arabic_seen, "XK_Arabic_seen" },
  { XK_Arabic_sheen, "XK_Arabic_sheen" },
  { XK_Arabic_sad, "XK_Arabic_sad" },
  { XK_Arabic_dad, "XK_Arabic_dad" },
  { XK_Arabic_tah, "XK_Arabic_tah" },
  { XK_Arabic_zah, "XK_Arabic_zah" },
  { XK_Arabic_ain, "XK_Arabic_ain" },
  { XK_Arabic_ghain, "XK_Arabic_ghain" },
  { XK_Arabic_tatweel, "XK_Arabic_tatweel" },
  { XK_Arabic_feh, "XK_Arabic_feh" },
  { XK_Arabic_qaf, "XK_Arabic_qaf" },
  { XK_Arabic_kaf, "XK_Arabic_kaf" },
  { XK_Arabic_lam, "XK_Arabic_lam" },
  { XK_Arabic_meem, "XK_Arabic_meem" },
  { XK_Arabic_noon, "XK_Arabic_noon" },
  { XK_Arabic_ha, "XK_Arabic_ha" },
  { XK_Arabic_heh, "XK_Arabic_heh" },
  { XK_Arabic_waw, "XK_Arabic_waw" },
  { XK_Arabic_alefmaksura, "XK_Arabic_alefmaksura" },
  { XK_Arabic_yeh, "XK_Arabic_yeh" },
  { XK_Arabic_fathatan, "XK_Arabic_fathatan" },
  { XK_Arabic_dammatan, "XK_Arabic_dammatan" },
  { XK_Arabic_kasratan, "XK_Arabic_kasratan" },
  { XK_Arabic_fatha, "XK_Arabic_fatha" },
  { XK_Arabic_damma, "XK_Arabic_damma" },
  { XK_Arabic_kasra, "XK_Arabic_kasra" },
  { XK_Arabic_shadda, "XK_Arabic_shadda" },
  { XK_Arabic_sukun, "XK_Arabic_sukun" },
  { XK_Arabic_switch, "XK_Arabic_switch" },
#endif /* XK_ARABIC */
#ifdef XK_CYRILLIC
  { XK_Serbian_dje, "XK_Serbian_dje" },
  { XK_Macedonia_gje, "XK_Macedonia_gje" },
  { XK_Cyrillic_io, "XK_Cyrillic_io" },
  { XK_Ukrainian_ie, "XK_Ukrainian_ie" },
  { XK_Ukranian_je, "XK_Ukranian_je" },
  { XK_Macedonia_dse, "XK_Macedonia_dse" },
  { XK_Ukrainian_i, "XK_Ukrainian_i" },
  { XK_Ukranian_i, "XK_Ukranian_i" },
  { XK_Ukrainian_yi, "XK_Ukrainian_yi" },
  { XK_Ukranian_yi, "XK_Ukranian_yi" },
  { XK_Cyrillic_je, "XK_Cyrillic_je" },
  { XK_Serbian_je, "XK_Serbian_je" },
  { XK_Cyrillic_lje, "XK_Cyrillic_lje" },
  { XK_Serbian_lje, "XK_Serbian_lje" },
  { XK_Cyrillic_nje, "XK_Cyrillic_nje" },
  { XK_Serbian_nje, "XK_Serbian_nje" },
  { XK_Serbian_tshe, "XK_Serbian_tshe" },
  { XK_Macedonia_kje, "XK_Macedonia_kje" },
  { XK_Byelorussian_shortu, "XK_Byelorussian_shortu" },
  { XK_Cyrillic_dzhe, "XK_Cyrillic_dzhe" },
  { XK_Serbian_dze, "XK_Serbian_dze" },
  { XK_numerosign, "XK_numerosign" },
  { XK_Serbian_DJE, "XK_Serbian_DJE" },
  { XK_Macedonia_GJE, "XK_Macedonia_GJE" },
  { XK_Cyrillic_IO, "XK_Cyrillic_IO" },
  { XK_Ukrainian_IE, "XK_Ukrainian_IE" },
  { XK_Ukranian_JE, "XK_Ukranian_JE" },
  { XK_Macedonia_DSE, "XK_Macedonia_DSE" },
  { XK_Ukrainian_I, "XK_Ukrainian_I" },
  { XK_Ukranian_I, "XK_Ukranian_I" },
  { XK_Ukrainian_YI, "XK_Ukrainian_YI" },
  { XK_Ukranian_YI, "XK_Ukranian_YI" },
  { XK_Cyrillic_JE, "XK_Cyrillic_JE" },
  { XK_Serbian_JE, "XK_Serbian_JE" },
  { XK_Cyrillic_LJE, "XK_Cyrillic_LJE" },
  { XK_Serbian_LJE, "XK_Serbian_LJE" },
  { XK_Cyrillic_NJE, "XK_Cyrillic_NJE" },
  { XK_Serbian_NJE, "XK_Serbian_NJE" },
  { XK_Serbian_TSHE, "XK_Serbian_TSHE" },
  { XK_Macedonia_KJE, "XK_Macedonia_KJE" },
  { XK_Byelorussian_SHORTU, "XK_Byelorussian_SHORTU" },
  { XK_Cyrillic_DZHE, "XK_Cyrillic_DZHE" },
  { XK_Serbian_DZE, "XK_Serbian_DZE" },
  { XK_Cyrillic_yu, "XK_Cyrillic_yu" },
  { XK_Cyrillic_a, "XK_Cyrillic_a" },
  { XK_Cyrillic_be, "XK_Cyrillic_be" },
  { XK_Cyrillic_tse, "XK_Cyrillic_tse" },
  { XK_Cyrillic_de, "XK_Cyrillic_de" },
  { XK_Cyrillic_ie, "XK_Cyrillic_ie" },
  { XK_Cyrillic_ef, "XK_Cyrillic_ef" },
  { XK_Cyrillic_ghe, "XK_Cyrillic_ghe" },
  { XK_Cyrillic_ha, "XK_Cyrillic_ha" },
  { XK_Cyrillic_i, "XK_Cyrillic_i" },
  { XK_Cyrillic_shorti, "XK_Cyrillic_shorti" },
  { XK_Cyrillic_ka, "XK_Cyrillic_ka" },
  { XK_Cyrillic_el, "XK_Cyrillic_el" },
  { XK_Cyrillic_em, "XK_Cyrillic_em" },
  { XK_Cyrillic_en, "XK_Cyrillic_en" },
  { XK_Cyrillic_o, "XK_Cyrillic_o" },
  { XK_Cyrillic_pe, "XK_Cyrillic_pe" },
  { XK_Cyrillic_ya, "XK_Cyrillic_ya" },
  { XK_Cyrillic_er, "XK_Cyrillic_er" },
  { XK_Cyrillic_es, "XK_Cyrillic_es" },
  { XK_Cyrillic_te, "XK_Cyrillic_te" },
  { XK_Cyrillic_u, "XK_Cyrillic_u" },
  { XK_Cyrillic_zhe, "XK_Cyrillic_zhe" },
  { XK_Cyrillic_ve, "XK_Cyrillic_ve" },
  { XK_Cyrillic_softsign, "XK_Cyrillic_softsign" },
  { XK_Cyrillic_yeru, "XK_Cyrillic_yeru" },
  { XK_Cyrillic_ze, "XK_Cyrillic_ze" },
  { XK_Cyrillic_sha, "XK_Cyrillic_sha" },
  { XK_Cyrillic_e, "XK_Cyrillic_e" },
  { XK_Cyrillic_shcha, "XK_Cyrillic_shcha" },
  { XK_Cyrillic_che, "XK_Cyrillic_che" },
  { XK_Cyrillic_hardsign, "XK_Cyrillic_hardsign" },
  { XK_Cyrillic_YU, "XK_Cyrillic_YU" },
  { XK_Cyrillic_A, "XK_Cyrillic_A" },
  { XK_Cyrillic_BE, "XK_Cyrillic_BE" },
  { XK_Cyrillic_TSE, "XK_Cyrillic_TSE" },
  { XK_Cyrillic_DE, "XK_Cyrillic_DE" },
  { XK_Cyrillic_IE, "XK_Cyrillic_IE" },
  { XK_Cyrillic_EF, "XK_Cyrillic_EF" },
  { XK_Cyrillic_GHE, "XK_Cyrillic_GHE" },
  { XK_Cyrillic_HA, "XK_Cyrillic_HA" },
  { XK_Cyrillic_I, "XK_Cyrillic_I" },
  { XK_Cyrillic_SHORTI, "XK_Cyrillic_SHORTI" },
  { XK_Cyrillic_KA, "XK_Cyrillic_KA" },
  { XK_Cyrillic_EL, "XK_Cyrillic_EL" },
  { XK_Cyrillic_EM, "XK_Cyrillic_EM" },
  { XK_Cyrillic_EN, "XK_Cyrillic_EN" },
  { XK_Cyrillic_O, "XK_Cyrillic_O" },
  { XK_Cyrillic_PE, "XK_Cyrillic_PE" },
  { XK_Cyrillic_YA, "XK_Cyrillic_YA" },
  { XK_Cyrillic_ER, "XK_Cyrillic_ER" },
  { XK_Cyrillic_ES, "XK_Cyrillic_ES" },
  { XK_Cyrillic_TE, "XK_Cyrillic_TE" },
  { XK_Cyrillic_U, "XK_Cyrillic_U" },
  { XK_Cyrillic_ZHE, "XK_Cyrillic_ZHE" },
  { XK_Cyrillic_VE, "XK_Cyrillic_VE" },
  { XK_Cyrillic_SOFTSIGN, "XK_Cyrillic_SOFTSIGN" },
  { XK_Cyrillic_YERU, "XK_Cyrillic_YERU" },
  { XK_Cyrillic_ZE, "XK_Cyrillic_ZE" },
  { XK_Cyrillic_SHA, "XK_Cyrillic_SHA" },
  { XK_Cyrillic_E, "XK_Cyrillic_E" },
  { XK_Cyrillic_SHCHA, "XK_Cyrillic_SHCHA" },
  { XK_Cyrillic_CHE, "XK_Cyrillic_CHE" },
  { XK_Cyrillic_HARDSIGN, "XK_Cyrillic_HARDSIGN" },
#endif /* XK_CYRILLIC */
#ifdef XK_GREEK
  { XK_Greek_ALPHAaccent, "XK_Greek_ALPHAaccent" },
  { XK_Greek_EPSILONaccent, "XK_Greek_EPSILONaccent" },
  { XK_Greek_ETAaccent, "XK_Greek_ETAaccent" },
  { XK_Greek_IOTAaccent, "XK_Greek_IOTAaccent" },
  { XK_Greek_IOTAdiaeresis, "XK_Greek_IOTAdiaeresis" },
  { XK_Greek_OMICRONaccent, "XK_Greek_OMICRONaccent" },
  { XK_Greek_UPSILONaccent, "XK_Greek_UPSILONaccent" },
  { XK_Greek_UPSILONdieresis, "XK_Greek_UPSILONdieresis" },
  { XK_Greek_OMEGAaccent, "XK_Greek_OMEGAaccent" },
  { XK_Greek_accentdieresis, "XK_Greek_accentdieresis" },
  { XK_Greek_horizbar, "XK_Greek_horizbar" },
  { XK_Greek_alphaaccent, "XK_Greek_alphaaccent" },
  { XK_Greek_epsilonaccent, "XK_Greek_epsilonaccent" },
  { XK_Greek_etaaccent, "XK_Greek_etaaccent" },
  { XK_Greek_iotaaccent, "XK_Greek_iotaaccent" },
  { XK_Greek_iotadieresis, "XK_Greek_iotadieresis" },
  { XK_Greek_iotaaccentdieresis, "XK_Greek_iotaaccentdieresis" },
  { XK_Greek_omicronaccent, "XK_Greek_omicronaccent" },
  { XK_Greek_upsilonaccent, "XK_Greek_upsilonaccent" },
  { XK_Greek_upsilondieresis, "XK_Greek_upsilondieresis" },
  { XK_Greek_upsilonaccentdieresis, "XK_Greek_upsilonaccentdieresis" },
  { XK_Greek_omegaaccent, "XK_Greek_omegaaccent" },
  { XK_Greek_ALPHA, "XK_Greek_ALPHA" },
  { XK_Greek_BETA, "XK_Greek_BETA" },
  { XK_Greek_GAMMA, "XK_Greek_GAMMA" },
  { XK_Greek_DELTA, "XK_Greek_DELTA" },
  { XK_Greek_EPSILON, "XK_Greek_EPSILON" },
  { XK_Greek_ZETA, "XK_Greek_ZETA" },
  { XK_Greek_ETA, "XK_Greek_ETA" },
  { XK_Greek_THETA, "XK_Greek_THETA" },
  { XK_Greek_IOTA, "XK_Greek_IOTA" },
  { XK_Greek_KAPPA, "XK_Greek_KAPPA" },
  { XK_Greek_LAMDA, "XK_Greek_LAMDA" },
  { XK_Greek_LAMBDA, "XK_Greek_LAMBDA" },
  { XK_Greek_MU, "XK_Greek_MU" },
  { XK_Greek_NU, "XK_Greek_NU" },
  { XK_Greek_XI, "XK_Greek_XI" },
  { XK_Greek_OMICRON, "XK_Greek_OMICRON" },
  { XK_Greek_PI, "XK_Greek_PI" },
  { XK_Greek_RHO, "XK_Greek_RHO" },
  { XK_Greek_SIGMA, "XK_Greek_SIGMA" },
  { XK_Greek_TAU, "XK_Greek_TAU" },
  { XK_Greek_UPSILON, "XK_Greek_UPSILON" },
  { XK_Greek_PHI, "XK_Greek_PHI" },
  { XK_Greek_CHI, "XK_Greek_CHI" },
  { XK_Greek_PSI, "XK_Greek_PSI" },
  { XK_Greek_OMEGA, "XK_Greek_OMEGA" },
  { XK_Greek_alpha, "XK_Greek_alpha" },
  { XK_Greek_beta, "XK_Greek_beta" },
  { XK_Greek_gamma, "XK_Greek_gamma" },
  { XK_Greek_delta, "XK_Greek_delta" },
  { XK_Greek_epsilon, "XK_Greek_epsilon" },
  { XK_Greek_zeta, "XK_Greek_zeta" },
  { XK_Greek_eta, "XK_Greek_eta" },
  { XK_Greek_theta, "XK_Greek_theta" },
  { XK_Greek_iota, "XK_Greek_iota" },
  { XK_Greek_kappa, "XK_Greek_kappa" },
  { XK_Greek_lamda, "XK_Greek_lamda" },
  { XK_Greek_lambda, "XK_Greek_lambda" },
  { XK_Greek_mu, "XK_Greek_mu" },
  { XK_Greek_nu, "XK_Greek_nu" },
  { XK_Greek_xi, "XK_Greek_xi" },
  { XK_Greek_omicron, "XK_Greek_omicron" },
  { XK_Greek_pi, "XK_Greek_pi" },
  { XK_Greek_rho, "XK_Greek_rho" },
  { XK_Greek_sigma, "XK_Greek_sigma" },
  { XK_Greek_finalsmallsigma, "XK_Greek_finalsmallsigma" },
  { XK_Greek_tau, "XK_Greek_tau" },
  { XK_Greek_upsilon, "XK_Greek_upsilon" },
  { XK_Greek_phi, "XK_Greek_phi" },
  { XK_Greek_chi, "XK_Greek_chi" },
  { XK_Greek_psi, "XK_Greek_psi" },
  { XK_Greek_omega, "XK_Greek_omega" },
  { XK_Greek_switch, "XK_Greek_switch" },
#endif /* XK_GREEK */
#ifdef XK_TECHNICAL
  { XK_leftradical, "XK_leftradical" },
  { XK_topleftradical, "XK_topleftradical" },
  { XK_horizconnector, "XK_horizconnector" },
  { XK_topintegral, "XK_topintegral" },
  { XK_botintegral, "XK_botintegral" },
  { XK_vertconnector, "XK_vertconnector" },
  { XK_topleftsqbracket, "XK_topleftsqbracket" },
  { XK_botleftsqbracket, "XK_botleftsqbracket" },
  { XK_toprightsqbracket, "XK_toprightsqbracket" },
  { XK_botrightsqbracket, "XK_botrightsqbracket" },
  { XK_topleftparens, "XK_topleftparens" },
  { XK_botleftparens, "XK_botleftparens" },
  { XK_toprightparens, "XK_toprightparens" },
  { XK_botrightparens, "XK_botrightparens" },
  { XK_leftmiddlecurlybrace, "XK_leftmiddlecurlybrace" },
  { XK_rightmiddlecurlybrace, "XK_rightmiddlecurlybrace" },
  { XK_topleftsummation, "XK_topleftsummation" },
  { XK_botleftsummation, "XK_botleftsummation" },
  { XK_topvertsummationconnector, "XK_topvertsummationconnector" },
  { XK_botvertsummationconnector, "XK_botvertsummationconnector" },
  { XK_toprightsummation, "XK_toprightsummation" },
  { XK_botrightsummation, "XK_botrightsummation" },
  { XK_rightmiddlesummation, "XK_rightmiddlesummation" },
  { XK_lessthanequal, "XK_lessthanequal" },
  { XK_notequal, "XK_notequal" },
  { XK_greaterthanequal, "XK_greaterthanequal" },
  { XK_integral, "XK_integral" },
  { XK_therefore, "XK_therefore" },
  { XK_variation, "XK_variation" },
  { XK_infinity, "XK_infinity" },
  { XK_nabla, "XK_nabla" },
  { XK_approximate, "XK_approximate" },
  { XK_similarequal, "XK_similarequal" },
  { XK_ifonlyif, "XK_ifonlyif" },
  { XK_implies, "XK_implies" },
  { XK_identical, "XK_identical" },
  { XK_radical, "XK_radical" },
  { XK_includedin, "XK_includedin" },
  { XK_includes, "XK_includes" },
  { XK_intersection, "XK_intersection" },
  { XK_union, "XK_union" },
  { XK_logicaland, "XK_logicaland" },
  { XK_logicalor, "XK_logicalor" },
  { XK_partialderivative, "XK_partialderivative" },
  { XK_function, "XK_function" },
  { XK_leftarrow, "XK_leftarrow" },
  { XK_uparrow, "XK_uparrow" },
  { XK_rightarrow, "XK_rightarrow" },
  { XK_downarrow, "XK_downarrow" },
#endif /* XK_TECHNICAL */
#ifdef XK_SPECIAL
  { XK_blank, "XK_blank" },
  { XK_soliddiamond, "XK_soliddiamond" },
  { XK_checkerboard, "XK_checkerboard" },
  { XK_ht, "XK_ht" },
  { XK_ff, "XK_ff" },
  { XK_cr, "XK_cr" },
  { XK_lf, "XK_lf" },
  { XK_nl, "XK_nl" },
  { XK_vt, "XK_vt" },
  { XK_lowrightcorner, "XK_lowrightcorner" },
  { XK_uprightcorner, "XK_uprightcorner" },
  { XK_upleftcorner, "XK_upleftcorner" },
  { XK_lowleftcorner, "XK_lowleftcorner" },
  { XK_crossinglines, "XK_crossinglines" },
  { XK_horizlinescan1, "XK_horizlinescan1" },
  { XK_horizlinescan3, "XK_horizlinescan3" },
  { XK_horizlinescan5, "XK_horizlinescan5" },
  { XK_horizlinescan7, "XK_horizlinescan7" },
  { XK_horizlinescan9, "XK_horizlinescan9" },
  { XK_leftt, "XK_leftt" },
  { XK_rightt, "XK_rightt" },
  { XK_bott, "XK_bott" },
  { XK_topt, "XK_topt" },
  { XK_vertbar, "XK_vertbar" },
#endif /* XK_SPECIAL */
#ifdef XK_PUBLISHING
  { XK_emspace, "XK_emspace" },
  { XK_enspace, "XK_enspace" },
  { XK_em3space, "XK_em3space" },
  { XK_em4space, "XK_em4space" },
  { XK_digitspace, "XK_digitspace" },
  { XK_punctspace, "XK_punctspace" },
  { XK_thinspace, "XK_thinspace" },
  { XK_hairspace, "XK_hairspace" },
  { XK_emdash, "XK_emdash" },
  { XK_endash, "XK_endash" },
  { XK_signifblank, "XK_signifblank" },
  { XK_ellipsis, "XK_ellipsis" },
  { XK_doubbaselinedot, "XK_doubbaselinedot" },
  { XK_onethird, "XK_onethird" },
  { XK_twothirds, "XK_twothirds" },
  { XK_onefifth, "XK_onefifth" },
  { XK_twofifths, "XK_twofifths" },
  { XK_threefifths, "XK_threefifths" },
  { XK_fourfifths, "XK_fourfifths" },
  { XK_onesixth, "XK_onesixth" },
  { XK_fivesixths, "XK_fivesixths" },
  { XK_careof, "XK_careof" },
  { XK_figdash, "XK_figdash" },
  { XK_leftanglebracket, "XK_leftanglebracket" },
  { XK_decimalpoint, "XK_decimalpoint" },
  { XK_rightanglebracket, "XK_rightanglebracket" },
  { XK_marker, "XK_marker" },
  { XK_oneeighth, "XK_oneeighth" },
  { XK_threeeighths, "XK_threeeighths" },
  { XK_fiveeighths, "XK_fiveeighths" },
  { XK_seveneighths, "XK_seveneighths" },
  { XK_trademark, "XK_trademark" },
  { XK_signaturemark, "XK_signaturemark" },
  { XK_trademarkincircle, "XK_trademarkincircle" },
  { XK_leftopentriangle, "XK_leftopentriangle" },
  { XK_rightopentriangle, "XK_rightopentriangle" },
  { XK_emopencircle, "XK_emopencircle" },
  { XK_emopenrectangle, "XK_emopenrectangle" },
  { XK_leftsinglequotemark, "XK_leftsinglequotemark" },
  { XK_rightsinglequotemark, "XK_rightsinglequotemark" },
  { XK_leftdoublequotemark, "XK_leftdoublequotemark" },
  { XK_rightdoublequotemark, "XK_rightdoublequotemark" },
  { XK_prescription, "XK_prescription" },
  { XK_minutes, "XK_minutes" },
  { XK_seconds, "XK_seconds" },
  { XK_latincross, "XK_latincross" },
  { XK_hexagram, "XK_hexagram" },
  { XK_filledrectbullet, "XK_filledrectbullet" },
  { XK_filledlefttribullet, "XK_filledlefttribullet" },
  { XK_filledrighttribullet, "XK_filledrighttribullet" },
  { XK_emfilledcircle, "XK_emfilledcircle" },
  { XK_emfilledrect, "XK_emfilledrect" },
  { XK_enopencircbullet, "XK_enopencircbullet" },
  { XK_enopensquarebullet, "XK_enopensquarebullet" },
  { XK_openrectbullet, "XK_openrectbullet" },
  { XK_opentribulletup, "XK_opentribulletup" },
  { XK_opentribulletdown, "XK_opentribulletdown" },
  { XK_openstar, "XK_openstar" },
  { XK_enfilledcircbullet, "XK_enfilledcircbullet" },
  { XK_enfilledsqbullet, "XK_enfilledsqbullet" },
  { XK_filledtribulletup, "XK_filledtribulletup" },
  { XK_filledtribulletdown, "XK_filledtribulletdown" },
  { XK_leftpointer, "XK_leftpointer" },
  { XK_rightpointer, "XK_rightpointer" },
  { XK_club, "XK_club" },
  { XK_diamond, "XK_diamond" },
  { XK_heart, "XK_heart" },
  { XK_maltesecross, "XK_maltesecross" },
  { XK_dagger, "XK_dagger" },
  { XK_doubledagger, "XK_doubledagger" },
  { XK_checkmark, "XK_checkmark" },
  { XK_ballotcross, "XK_ballotcross" },
  { XK_musicalsharp, "XK_musicalsharp" },
  { XK_musicalflat, "XK_musicalflat" },
  { XK_malesymbol, "XK_malesymbol" },
  { XK_femalesymbol, "XK_femalesymbol" },
  { XK_telephone, "XK_telephone" },
  { XK_telephonerecorder, "XK_telephonerecorder" },
  { XK_phonographcopyright, "XK_phonographcopyright" },
  { XK_caret, "XK_caret" },
  { XK_singlelowquotemark, "XK_singlelowquotemark" },
  { XK_doublelowquotemark, "XK_doublelowquotemark" },
  { XK_cursor, "XK_cursor" },
#endif /* XK_PUBLISHING */
#ifdef XK_APL
  { XK_leftcaret, "XK_leftcaret" },
  { XK_rightcaret, "XK_rightcaret" },
  { XK_downcaret, "XK_downcaret" },
  { XK_upcaret, "XK_upcaret" },
  { XK_overbar, "XK_overbar" },
  { XK_downtack, "XK_downtack" },
  { XK_upshoe, "XK_upshoe" },
  { XK_downstile, "XK_downstile" },
  { XK_underbar, "XK_underbar" },
  { XK_jot, "XK_jot" },
  { XK_quad, "XK_quad" },
  { XK_uptack, "XK_uptack" },
  { XK_circle, "XK_circle" },
  { XK_upstile, "XK_upstile" },
  { XK_downshoe, "XK_downshoe" },
  { XK_rightshoe, "XK_rightshoe" },
  { XK_leftshoe, "XK_leftshoe" },
  { XK_lefttack, "XK_lefttack" },
  { XK_righttack, "XK_righttack" },
#endif /* XK_APL */
#ifdef XK_HEBREW
  { XK_hebrew_doublelowline, "XK_hebrew_doublelowline" },
  { XK_hebrew_aleph, "XK_hebrew_aleph" },
  { XK_hebrew_bet, "XK_hebrew_bet" },
  { XK_hebrew_beth, "XK_hebrew_beth" },
  { XK_hebrew_gimel, "XK_hebrew_gimel" },
  { XK_hebrew_gimmel, "XK_hebrew_gimmel" },
  { XK_hebrew_dalet, "XK_hebrew_dalet" },
  { XK_hebrew_daleth, "XK_hebrew_daleth" },
  { XK_hebrew_he, "XK_hebrew_he" },
  { XK_hebrew_waw, "XK_hebrew_waw" },
  { XK_hebrew_zain, "XK_hebrew_zain" },
  { XK_hebrew_zayin, "XK_hebrew_zayin" },
  { XK_hebrew_chet, "XK_hebrew_chet" },
  { XK_hebrew_het, "XK_hebrew_het" },
  { XK_hebrew_tet, "XK_hebrew_tet" },
  { XK_hebrew_teth, "XK_hebrew_teth" },
  { XK_hebrew_yod, "XK_hebrew_yod" },
  { XK_hebrew_finalkaph, "XK_hebrew_finalkaph" },
  { XK_hebrew_kaph, "XK_hebrew_kaph" },
  { XK_hebrew_lamed, "XK_hebrew_lamed" },
  { XK_hebrew_finalmem, "XK_hebrew_finalmem" },
  { XK_hebrew_mem, "XK_hebrew_mem" },
  { XK_hebrew_finalnun, "XK_hebrew_finalnun" },
  { XK_hebrew_nun, "XK_hebrew_nun" },
  { XK_hebrew_samech, "XK_hebrew_samech" },
  { XK_hebrew_samekh, "XK_hebrew_samekh" },
  { XK_hebrew_ayin, "XK_hebrew_ayin" },
  { XK_hebrew_finalpe, "XK_hebrew_finalpe" },
  { XK_hebrew_pe, "XK_hebrew_pe" },
  { XK_hebrew_finalzade, "XK_hebrew_finalzade" },
  { XK_hebrew_finalzadi, "XK_hebrew_finalzadi" },
  { XK_hebrew_zade, "XK_hebrew_zade" },
  { XK_hebrew_zadi, "XK_hebrew_zadi" },
  { XK_hebrew_qoph, "XK_hebrew_qoph" },
  { XK_hebrew_kuf, "XK_hebrew_kuf" },
  { XK_hebrew_resh, "XK_hebrew_resh" },
  { XK_hebrew_shin, "XK_hebrew_shin" },
  { XK_hebrew_taw, "XK_hebrew_taw" },
  { XK_hebrew_taf, "XK_hebrew_taf" },
  { XK_Hebrew_switch, "XK_Hebrew_switch" },
#endif /* XK_HEBREW */
};

char *McKeysymName(KeySym key) {
  int i;

  for (i=0;i<sizeof(keysymtable)/sizeof(keysymtable[0]);i++) {
    if (key==keysymtable[i].key) return keysymtable[i].name;
  }
  return "Unknown";
}

/**************************************************************************/

#ifdef THIS_IS_CRAP
void vmstat() {
  int i;

  printf("bytes_total = $%08X (%d)\n"
	 "chunks_used = $%08X (%d)\n"
	 "bytes_used  = $%08X (%d)\n"
	 "chunks_free = $%08X (%d)\n"
	 "bytes_free  = $%08X (%d)\n",
	 i=mstats->bytes_total,i,
	 i=mstats->chunks_used,i,
	 i=mstats->bytes_used,i,
	 i=mstats->chunks_free,i,
	 i=mstats->bytes_free,i);
}
#endif

/**************************************************************************/

/*
 * dump(char *adr,int size);
 *
 * dumps size bytes from adr to stdout, using hex/asc display
 *
 */
void McDump(unsigned char *adr, int size, int showadr) {
  unsigned char buf[80];
  int i,j,p;
  i=0;p=0;
  do {
    if (!i) {
      sprintf(buf,"%08X: ",showadr+p);
    }
    sprintf(&buf[i*3+10+((i>7)?1:0)],"%02X ",(unsigned char)adr[p]);
    buf[i+63]=(adr[p]>=32 && adr[p]<=126)?adr[p]:'.';
    i++;p++;
    if (i==16) {
      buf[34]=32;
      buf[58]=32;buf[59]=32;buf[60]=32;buf[61]=32;buf[62]=32;
      buf[79]=0;
      puts(buf);
      i=0;
    }
  } while(--size);
  if (i) {
    for (j=i*3+10+((i>7)?1:0);j<63;j++) buf[j]=32;
    buf[i+63]=0;
    buf[33]=32;
    buf[34]=32;
    puts(buf);
  }
}
