#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <stdio.h>
#include <string.h>
#include "McAlloc.h"
#include <X11/Xatom.h>
#include "McApp.h"
#include "McGadget.h"
#include "McDebug.h"
#include "McSlider.h"
#include "McViewBitmap.h"
#include "McSelection.h"
#include "McBuffer.h"

/**************************************************************************/

#define VIEWBITMAP ((McViewBitmap *)(gadget->specialInfo))

static void ViewBitmapCleanup(McGadget *gadget);
static int  ViewBitmapEvent(McGadget *gadget, XEvent *event);
static void ViewBitmap_slider_update(McGadget *gadget,
				     McViewBitmap *ViewBitmap);

/**************************************************************************/

McSpecialInfo *McCreateViewBitmap(unsigned int flags) {
  McViewBitmap *ViewBitmap = (McViewBitmap *) McAlloc(sizeof(McViewBitmap));
  ViewBitmap->flags = flags;
  ViewBitmap->specialInfo.updateProc = McViewBitmapUpdate;
  ViewBitmap->specialInfo.eventProc = ViewBitmapEvent;
  ViewBitmap->specialInfo.cleanupProc = ViewBitmapCleanup;
  ViewBitmap->size_x = 1;
  ViewBitmap->size_y = 1;
  ViewBitmap->home_x = 0;
  ViewBitmap->home_y = 0;
  ViewBitmap->pixmap = 0;
  ViewBitmap->depth  = 0;

  return (McSpecialInfo *)ViewBitmap;
}

static void ViewBitmapCleanup(McGadget *gadget) {
  McFree(gadget->specialInfo);
}

/**************************************************************************/

void McViewBitmapUpdate(McGadget *gadget, int busy, int all) {
  McViewBitmap *ViewBitmap = (McViewBitmap *)gadget->specialInfo;
  McWindow *mcw=gadget->mcw;
  McApp *app=mcw->app;

  if (ViewBitmap->depth>1) {
    XCopyArea(app->display, ViewBitmap->pixmap, mcw->window,
	      app->gc[GC_NORMAL],
	      ViewBitmap->home_x, ViewBitmap->home_y,
	      gadget->width, gadget->height,
	      gadget->x, gadget->y);
  } else {
    XCopyPlane(app->display, ViewBitmap->pixmap, mcw->window,
	       app->gc[GC_NORMAL],
	       ViewBitmap->home_x, ViewBitmap->home_y,
	       gadget->width, gadget->height,
	       gadget->x, gadget->y, 1);
  }

  ViewBitmap_slider_update(gadget, ViewBitmap);
}

/**************************************************************************/

static int ViewBitmapEvent(McGadget *gadget, XEvent *event) {
  return 0;
}

/**************************************************************************/

McGadget *MakeViewBitmap(McWindow *mcw, int x, int y, int w, int h) {
  McGadget *gadget;

  if (w<=0) w=mcw->w-(BW<<2);
  if (h<=0) h=mcw->h-(BW<<2);
  if (x==0) x=(mcw->w>>1)-(w>>1);	/* Center */
  if (y==0) y=(mcw->h>>1)-(h>>1);
  if (x<0) x=mcw->w+x-w-BW-BW-BW;	/* Right justify */
  if (y<0) y=mcw->h+y-h-BW-BW-BW;

  gadget = McCreateGadget(mcw, GAD_3D|GAD_H3D|GAD_ACTIVE,
			  VIEWBITMAPGADGET, x, y, w, h);
  gadget->specialInfo = McCreateViewBitmap(0);
  return gadget;
}

/**************************************************************************/

void McViewBitmapSetPixmap(McGadget *gadget, Pixmap pix, int depth,
			   int size_x, int size_y) {
  McViewBitmap *ViewBitmap = (McViewBitmap *)gadget->specialInfo;

  ViewBitmap->home_x = ViewBitmap->home_x * size_x / ViewBitmap->size_x;
  ViewBitmap->home_y = ViewBitmap->home_y * size_y / ViewBitmap->size_y;

  ViewBitmap->pixmap=pix;
  ViewBitmap->depth=depth;
  ViewBitmap->size_x=size_x;
  ViewBitmap->size_y=size_y;

  if (ViewBitmap->home_x >= size_x - gadget->width)
    ViewBitmap->home_x = size_x - gadget->width;

  if (ViewBitmap->home_y >= size_y - gadget->height)
    ViewBitmap->home_y = size_y - gadget->height;

  if (ViewBitmap->home_x < 0) ViewBitmap->home_x = 0;

  if (ViewBitmap->home_y < 0) ViewBitmap->home_y = 0;

  ViewBitmap_slider_update(gadget, ViewBitmap);

#if 0
  fprintf(stderr, "home=%d/%d size=%d/%d gadget=%d/%d\n",
	  ViewBitmap->home_x, ViewBitmap->home_y,
	  ViewBitmap->size_x, ViewBitmap->size_y,
	  gadget->width, gadget->height);	  
#endif

}

/**************************************************************************/

static void slider_ver_proc(McGadget *gadget);
static void slider_hor_proc(McGadget *gadget);

void McViewBitmapBindSliders(McGadget *bitgad,
			   McGadget *sliderhor, McGadget *sliderver) {
  McViewBitmap *ViewBitmap = (McViewBitmap *)bitgad->specialInfo;
  ViewBitmap->sliderhor = sliderhor;
  ViewBitmap->sliderver = sliderver;
  if (sliderhor) {
    sliderhor->callbackUp = sliderhor->callbackDown = slider_hor_proc;
    sliderhor->customData = bitgad;
  }
  if (sliderver) {
    sliderver->callbackUp = sliderver->callbackDown = slider_ver_proc;
    sliderver->customData = bitgad;
  }
}

static void ViewBitmap_slider_update(McGadget *gadget,
				     McViewBitmap *ViewBitmap) {
  McGadget *slidergad;

  if ((slidergad=ViewBitmap->sliderhor)) {
    McSlider *slider = (McSlider *)slidergad->specialInfo;
    int max = ViewBitmap->size_x - (gadget->width-BW-BW);
    if (max<0) max=0;
    slider->leftValue=slider->rightValue=ViewBitmap->home_x;
    McSliderSetProps(slidergad, max, ViewBitmap->size_x);
    McGadgetUpdate(slidergad);
  }

  if ((slidergad=ViewBitmap->sliderver)) {
    McSlider *slider = (McSlider *)slidergad->specialInfo;
    int max = ViewBitmap->size_y - (gadget->height-BW-BW);
    if (max<0) max=0;
    slider->leftValue=slider->rightValue=max-ViewBitmap->home_y;
    McSliderSetProps(slidergad, max, ViewBitmap->size_y);
    McGadgetUpdate(slidergad);
  }
}

static void slider_hor_proc(McGadget *gadget) {
  McSlider *slider = (McSlider *)gadget->specialInfo;
  McGadget *bitgad = (McGadget *)gadget->customData;
  McViewBitmap *ViewBitmap = (McViewBitmap *)bitgad->specialInfo;
  int col = slider->leftValue;

  if (ViewBitmap->home_x!=col) {
    ViewBitmap->home_x = col;
    McViewBitmapUpdate(bitgad, 0, 1);
  }
}

static void slider_ver_proc(McGadget *gadget) {
  McSlider *slider = (McSlider *)gadget->specialInfo;
  McGadget *bitgad = (McGadget *)gadget->customData;
  McViewBitmap *ViewBitmap = (McViewBitmap *)bitgad->specialInfo;
  int row = slider->maxValue-slider->leftValue;

  if (ViewBitmap->home_y!=row) {
    ViewBitmap->home_y = row;
    McViewBitmapUpdate(bitgad, 0, 1);
  }
}





