.\" $NCDId: @(#)AuSIOEHn.man,v 1.1 1994/09/27 00:35:17 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuSetIOErrorHandler.man,v 1.4 1994/09/20 08:10:39 sking Exp $
.TH AuSetErrorHandler 3 "1.2" "audiolib - error handling"
.SH \fBName\fP
\fBAuSetIOErrorHandler\fP \- set handler for fatal IO errors
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuBool\fP (*\fBAuSetIOErrorHandler\fP(\fIserver\fP, \fIhandler\fP))()
.br
    \fBAuServer\fP *\fIserver\fP;
.br
    \fBAuBool\fP (*\fIhandler\fP)(\fBAuServer\fP *);
.SH \fBArguments\fP
.IP \fIserver\fP 1i
Specifies the connection to the audio server.
.IP \fIhandler\fP 1i
Specifies the fatal error handler.
Use NULL to reinstall the default fatal error handler.
.SH \fBDescription\fP
\fBAuSetIOErrorHandler\fP sets the fatal I/O error handler and returns the previous error handler.
The error handler will be invoked if a system call error occurs (for example, the connection to the server was lost).
As this is assumed to be a fatal condition, the error handler routine should not return.
If the I/O error handler does return, the client process exits.
.SH \fBSee Also\fP
\fBAuServerName\fP,
\fBAuGetErrorDatabaseText\fP,
\fBAuGetErrorText\fP,
\fBAuSetErrorHandler\fP,
\fBAuSynchronize\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
