.TH Wharf 0.98a "May 1996" Wharf
.UC
.SH NAME
Wharf \- the AfterStep application "dock" module
.SH SYNOPSIS
Wharf is spawned by afterstep, so no command line invocation will work.

.SH DESCRIPTION
The Wharf module is a much worked over version of fvwm GoodStuff which
provides a button panel that is consistenet with the
look and feel of the NEXTSTEP "dock." It is called Wharf however to avoid 
copywrite problems. The user can press the buttons at any time,
and trigger invocation of a user-specified command by the window
manager. Wharf only works when afterstep is used as the window manager.

Wharf, however, does differ from the NEXTSTEP(tm) "dock" in several ways:
.RS
.nf
1. Buttons are 3-D pushable.
2. A single click is all that is necessary to activate the
   buttons(the "dock" uses a double click).
3. Buttons will not highlight when activated.
4. The three dots in the lower left corner of the button 
   were removed.
.fn
.RE

.SH COPYRIGHTS
The Wharf module is copyright 1995 by Bo Yang.  Other modifications are
copyright 1995 & 1996 Frank Fejes and Dan Weeks.

The GoodStuff program, and the concept for
interfacing this module to the Window Manager, are all original work
by Robert Nation

No guarantees or warranties or anything
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 


.SH INITIALIZATION
During initialization, \fIWharf\fP will search for a configuration
file which describes the button panel geometry, color, icons, and
actions. The format of 
this file will be described later. The configuration file will be the
one which afterstep used during its initialization.

If the Wharf executable is linked to another name, ie ln -s
Wharf Peir, then another module called Peir can be
started, with a completely different configuration than Wharf,
simply by changing the keywords Wharf??? to Peir???. This way multiple
button-bars can be used.

.SH INVOCATION
Wharf can be invoked by inserting the line 'Module Wharf' in
the .steprc file. This can be placed on a line by itself, if Wharf
is to be spawned during afterstep's initialization, or can be bound to a
menu or mouse button or keystroke to invoke it later. AfterStep will search
directory specified in the ModulePath configuration option to attempt
to locate Wharf.

.SH CONFIGURATION OPTIONS
The following options can be placed in the .steprc file

.IP "*WharfGeometry \fIgeometry\fP"
Specifies the Wharf window location and/or size. If the size is
not specified, Wharf will auto-size itself in a reasonable manner.
The geometry is a standard X11 window geometry specification.  This option is
pre-set in the NEXSTEP style section for a consistent look and feel with NEXTSTEP.
Secondary Wharf invocations from links may have their own geometry.

.IP "*WharfColumns \fIcolumns\fP"
Specifies the number of columns of buttons to be created. If unspecified,
the number of columns will be set to 1.
If the columns are set to a number greater than 1 then there will be that number
of columns with enough rows to satisfy the requested number of buttons.

.IP "*Wharf \fIlabel icon command\fP"
Specifies a window manager built-in command, as described in the afterstep
man page, which should be executed when a button is pressed. The label
field is an internal item that is still around from the GoodStuff module.
The icon field
specifies an X11 bitmap file or XPM color icon file, containing the
icon to display on the button. Wharf will search through the path
specified in the afterstep IconPath or PixmapPath configuration items to
find the icon file.

NOTE!  The XPM icons must be no larger than 48 pixels by 48 pixels in size.  Also
the icons must have one transparent pixel or the definition of a transparent color
in order to be used.

If \fIcommand\fP is an afterstep Exec command, then the button will
appear pushed in until the mouse button is released.

A single extension to the afterstep built-in command set is provided.
A command of the form:
.nf
*Wharf junk clock.xpm Swallow "Clock" asclock -shape -12 &
.fn
will cause Wharf to spawn an rclock process, and capture 
the first window whose name or resource is "Clock", and display it in
the button-bar. This is handy for applications like xclock, xbiff, and
xload. Modules can be swallowed by specifying  SwallowModule instead
of just "swallow" NOTE: if you use xclock for this application, you will want
to specify xclock -padding 0. 

For ceratian applications that overrun the 48 pixel by 48 pixel boundary of Wharf
icons and Swallowed programs there is a special option called
.I MaxSwallow.
.I MaxSwallow
will allow the application to draw itself larger than the 48x48 boundary.  It is 
invoked the same way Swallow is.
 
.IP "*WharfNoPush"
Causes the Wharf not to have the 3D button pushes for mice clicks.  This helps on
8-bit displays that tend to cause Wharf to die when buttons are pushed with the 3D 
look activated.

.SH SAMPLE CONFIGURATION
The following are excepts from a .steprc file which describe Wharf
initialization commands:

.nf
.sp
##############################################################
# Load any modules which should be started during 
# AFterStep initialization
ModulePath /usr/lib/X11/afterstep:/usr/bin/X11
Module Wharf

Module                  Wharf 
NoTitle			Wharf
NoBorder                Wharf
Sticky			Wharf
StaysOnTop		Wharf
WindowListSkip 		Wharf
*WharfGeometry          63x384-1+3
*WharfColumns           1

#button definitions
*Wharf Dopey rterm.xpm Exec "big_win" xterm -T big_win -geometry 80x50&
*Wharf Snoopy rterm.xpm Exec "small_win" xterm -T small_wi &
*Wharf Xcalc   rcalc.xpm Exec "Calculator" xcalc &
*Wharf XMag mag_glass2.xpm Exec "xmag" xmag &
*Wharf Mail mail2.xpm   Exec "xmh" xmh &
*Wharf - whatever SwallowModule "Pager" Pager 0 3
*Wharf Recycler recycle.xpm Restart  
.sp
.fi

.SH AUTHORS
Frank Fejes <frank@nina.dorknet.com> -- continued development & upgrades
Dan Weeks <dan@mango.sfasu.edu> -- man pages
