/*
 *  Printer - the OffiX print manager
 *  Copyright (c) 1996 Andr Hentz
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <X11/Intrinsic.h>
#include <OffiX/DragAndDrop.h>
#include "Main.h"

#ifdef XSHAPE
	#include <X11/extensions/shape.h>
#endif

#include <stdio.h>

#ifdef XPM
#include <X11/xpm.h>
#include "printer.xpm"
#include "printer_idle.xpm"
#else
#include "printer.xbm"
#include "printer_mask.xbm"
#include "printer_idle.xbm"
#include "printer_idle_mask.xbm"
#endif

/*---------------- Public functions -----------------*/
void ReadIcons(void);
void UpdateIcon(int Flag);


static Pixmap	EmptyPrinterIcon,EmptyPrinterMask;
static Pixmap	PrinterIcon,PrinterMask;
static Window IconWindow;

void
ReadIcons(void)
{
	XSetWindowAttributes attributes;
	XWMHints *hints;
	Display 	*dpy=XtDisplay(toplevel);
	int Width=30,Height=25;
	int scrn=DefaultScreen(dpy);
	int dpth=XDefaultDepth(dpy,scrn);
	unsigned long valuemask=0;
	Window win=DefaultRootWindow(dpy);
#ifdef XPM
	XpmAttributes xpmattributes;
#endif
    	/* Now create the icon window */
	IconWindow=XCreateWindow(dpy,win,0,0,Width,Height,0,
				 CopyFromParent,CopyFromParent,
				 CopyFromParent,valuemask,&attributes);
	
	/* Now tell the window manager that the icon window is ours */
	hints=XAllocWMHints();
	hints->flags=IconWindowHint; /* | StateHint ;*/
	hints->icon_window=IconWindow;
	hints->initial_state=IconicState;
	XSetWMHints(dpy,XtWindow(toplevel),hints);
	XFree(hints);

	/* Create the pixmaps accordingly		       *
	 * All the pixmaps MUST have the same height and width */
#ifdef XPM
	xpmattributes.depth=dpth;
	xpmattributes.valuemask=XpmSize | XpmDepth;
	XpmCreatePixmapFromData(dpy,win,printer_idle_xpm,&EmptyPrinterIcon,&EmptyPrinterMask,
				&xpmattributes);
	XpmCreatePixmapFromData(dpy,win,printer_xpm,&PrinterIcon,
				&PrinterMask,&xpmattributes);
	Width=xpmattributes.width;
	Height=xpmattributes.height;
#else
	EmptyPrinterIcon=XCreatePixmapFromBitmapData(dpy,win,printer_idle_bits,
			printer_idle_width,printer_idle_height,BlackPixel(dpy,scrn),
			WhitePixel(dpy,scrn),dpth);
	EmptyPrinterMask=XCreateBitmapFromData(dpy, win,printer_idle_mask_bits,
			printer_idle_mask_width,printer_idle_mask_height);
	PrinterIcon=XCreatePixmapFromBitmapData(dpy, win,printer_bits,
			printer_width,printer_height,
			BlackPixel(dpy,scrn),WhitePixel(dpy,scrn),dpth);
	PrinterMask=XCreateBitmapFromData(dpy, win,printer_mask_bits,
			printer_mask_width,printer_mask_height);
	Width=printer_width;
	Height=printer_height;
#endif
		
#ifdef HAVE_XTREGISTERDRAWABLE
	/* Register the icon window to a non-toplevel widget	*
	 * This widget must be drop-registered in order to	*
	 * receive icon drops.					*/
	XtRegisterDrawable(dpy,IconWindow,JobsList);
#endif
}

void
UpdateIcon(int Flag)
{
	Pixmap *icon,*mask;
	Display 	*dpy;

	dpy=XtDisplay(toplevel);
	
	if(Flag) { icon=&PrinterIcon;  mask=&PrinterMask; }
	else	 { icon=&EmptyPrinterIcon; mask=&EmptyPrinterMask; }

#ifdef XSHAPE
	XShapeCombineMask(dpy,IconWindow,ShapeBounding,0,0,
			  *mask,ShapeSet);
#endif
	XSetWindowBackgroundPixmap(dpy,IconWindow,*icon);
	XClearWindow(dpy,IconWindow);
}
