.\"
.\" Copyright ([\d,\s]*) by Hewlett-Packard Company, Ardent Computer, 
.\" 
.\" Permission to use, copy, modify, distribute, and sell this documentation 
.\" for any purpose and without fee is hereby granted, provided that the above
.\" copyright notice and this permission notice appear in all copies.
.\" Ardent, and Hewlett-Packard make no representations about the 
.\" suitability for any purpose of the information in this document.  It is 
.\" provided \`\`as is'' without express or implied warranty.
.\" 
.\" $XConsortium: XSetMode.man /main/7 1995/12/15 14:10:05 gildea $
.ds xL Programming with Xlib
.TH XSetDeviceMode 3X11 "Release 6.1" "X Version 11" "X FUNCTIONS"
.SH NAME
XSetDeviceMode \- change the mode of a device
.SH SYNTAX
XSetDeviceMode\^(\^\fIdisplay\fP, \fIdevice\fP\^, \fImode\fP\^)
.br
      Display *\fIdisplay\fP\^;
.br
      XDevice *\fIdevice\fP\^; 
.br
      int \fI_mode\fP\^; 
.SH ARGUMENTS
.TP 12
.I display
Specifies the connection to the X server.
.TP 12
.I device
Specifies the device whose mode is to be changed.
.TP 12
.I mode
Specifies the mode.
You can pass 
\fIAbsolute\fP ,
or
\fIRelative\fP.
.SH DESCRIPTION
The
\fIXSetDeviceMode\fP
request changes the mode of an input device that is capable of reporting
either absolute positional information or relative motion information.  
Not all input devices are capable of reporting motion data, and not
all are capable of changing modes from \fIAbsolute\fP to \fIRelative\fP.
.LP
\fIXSetDeviceMode\fP
can generate a \fIBadDevice\fP or
\fIBadMode\fP 
error.
.SH DIAGNOSTICS
.TP 12
\fIBadDevice\fP
An invalid device was specified.  The specified device does not exist or has 
not been opened by this client via \fIXOpenInputDevice\fP.  This error may
also occur if some other client has caused the specified device to become
the X keyboard or X pointer device via the \fIXChangeKeyboardDevice\fP or
\fIXChangePointerDevice\fP requests.
.TP 12
\fIBadMatch\fP
This error may occur if an \fIXSetDeviceMode\fP request is made 
specifying a device that has no valuators and reports no axes of motion.
.TP 12
\fIBadMode\fP
An invalid mode was specified.  This error will also be returned if the
specified device is not capable of supporting the \fIXSetDeviceMode\fP
request.
.SH "SEE ALSO"
.br
\fI\*(xL\fP
