//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "meter.h"
#include "xosview.h"

Meter::Meter( XOSView *parent, int x, int y, int width, int height, 
	      const char *title, const char *legend, int dolegends,
	      int dousedlegends ) {
  title_ = legend_ = NULL;
  Meter::title( title );
  Meter::legend( legend );
  parent_ = parent;
  dolegends_ = dolegends;
  dousedlegends_ = dousedlegends;
  priority_ = 1;
  counter_ = 0;
  resize( x, y, width, height );

  if ( parent_->getResource( "meterLabel" ) == NULL )
    parent_->addResource( "meterLabel", NULL, "yellow" );
}

Meter::~Meter( void ){
  delete[] title_;
  delete[] legend_;
}

void Meter::checkResources( void ){
  textcolor_ = parent_->allocColor( parent_->getResource( "meterLabel" ) );
}

void Meter::title( const char *title ){
  delete[] title_;
  title_ = new char[strlen( title ) + 1];
  strcpy( title_, title );
}

void Meter::legend( const char *legend ){
  delete[] legend_;
  legend_ = new char[strlen( legend ) + 1];
  strcpy( legend_, legend );
}

void Meter::resize( int x, int y, int width, int height ){
  x_ = x;
  y_ = y;
  width_ = width;
  height_ = height;
}


