#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"

extern struct setup Setup;
extern struct stat Stat;
FD_status *f_status;
struct status *Statuss;

void checkStatus(void);
void checkStatus()
{
   {
      MYSQL connection;
      if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
      {
	 char str1[91], str2[91], *ptr;
	 long secondes;
      
	 strcpy(str1, mysql_stat(&connection));
	 ptr = str1;
	 while(*ptr != 'R') ptr++;
	 *(ptr - 1) = '\0';
      
	 strcpy(str2, &str1[7]);
	 secondes = atol(str2);
	 sprintf(str2, "Uptime: %ld days, %ld hours, %ld min. %s",
		 secondes / 86400L,
		 (secondes % 86400L) / 3600L,
		 (secondes % 3600L) / 60L,
		 ptr);
	 fl_freeze_form(f_status->status);
	 fl_addto_browser(f_status->status_browser, str2);
	 mysql_close(&connection);
	 Statuss->lignes++;
	 if(Statuss->lignes > Setup.statusMaxLines)
	 {
	    fl_delete_browser_line(f_status->status_browser, 1);
	    Statuss->lignes--;
	 }
	 fl_unfreeze_form(f_status->status);
      }
   }
}

void main_status(FL_OBJECT *obj, long data)
{
  if(Stat.flagStatus) return;
  Stat.flagStatus=1;
  
  f_status = create_form_status();

  Statuss = (struct status *) calloc(1, sizeof(struct status));

  fl_show_form(f_status->status, FL_PLACE_FREE, FL_TRANSIENT, "XmysqlAdmin status");
  checkStatus();
  if(Setup.statusRefreshTime > 0)
    fl_set_timer(f_status->status_timer, Setup.statusRefreshTime);
}

void status_close(FL_OBJECT *obj, long data)
{
  fl_hide_form(f_status->status);
  fl_free_form(f_status->status);
  free(f_status);
  free(Statuss);
  Stat.flagStatus=0;
}
void status_refresh(FL_OBJECT *obj, long data)
{
  checkStatus();
}

void status_timer(FL_OBJECT *obj, long data)
{
  checkStatus();
  if(Setup.statusRefreshTime > 0)
    fl_set_timer(f_status->status_timer, Setup.statusRefreshTime);
}

