/* cp_screen.c = Screen procedures and graphic ftns for circle packing */

#include "cp_head.h"

extern int hgeo(),sgeo();
extern char *get_selection();
extern complex ss_view();
int dum_int;

int
display_call(p,datastr)
struct p_data *p;
char *datastr;
{
	int count=0,vert,fill=0,i,col,cflag,hes,length,dflag,hits,pnum;
	int dspeed,v,w;
	char *nextpoint,*endptr,next[64];
	extern struct Vertlist *node_link_parse(),*face_link_parse();
	struct Vertlist *vertlist=NULL,*trace,*facelist=NULL;
	extern struct Edgelist *node_pair_link(),*get_extended_edge();
	struct Edgelist *edgelist=NULL,*track,*eelist=NULL,*eetrack;
	complex ctr;
	extern XPoint *path_XPoints();
	XPoint *Xptr=NULL;
	struct s_data *q;

	pnum=pack_num(p);
	q=p->screen;
	dspeed=draw_speed; 
	if (!(p->status)) return 1;
	xv_set(canvas_frame[pnum],WIN_SHOW,TRUE,XV_LABEL,packlabels[pnum],0);
	nextpoint=datastr;
	if (!grab_next(&nextpoint,next) || next[0]!='-')
	 {
		disp_screen(p,p->screen->display_opt,0);
		return 1;
	 }
	hes=p->hes;
	do
	 {
for (i=strlen(next);i<5;i++) next[i]='\0'; /* clear old info */
if (next[0]!='-') return count;
if (next[1]=='w') 
	 {
		clear_canvas(p->screen);
		if (hes>okerr) unitcircle(p->screen); 
		count++;
	 }
else if (next[1]=='c') /* draw circles */
 {
	if (next[2]=='f') fill=1;
	else fill=0;
	if ((vertlist=node_link_parse(p,nextpoint,
		&endptr,&hits))!=NULL)
	 {
		nextpoint=endptr;
		col=0;
		if (fill && next[3]=='f' && next[4]=='g') col=FG_COLOR;
		else if (fill && next[3]=='b' && next[4]=='g') col=BG_COLOR; 
			/* want foreground or background color */
		trace=vertlist;
		do
		 {
		   vert=trace->v;
		   if (col) draw_any_circle(p,vert,fill,col,dspeed);
		   else draw_any_circle(p,vert,fill,
			p->packK_ptr[vert].color,dspeed);
		   count++;
		   trace=trace->next;
		 } while (trace!=NULL);
		vert_free(&vertlist);
		if (!dspeed) refresh_canvas(p->screen);
	 }
	else
	 {
		if (fill) 
		 {
			q->display_opt=0;
			panel_set(sopt[pnum],PANEL_VALUE,1,0);
		 }
		else
		 {
			q->display_opt=1;
			panel_set(sopt[pnum],PANEL_VALUE,0,0);
		 }
		disp_screen(p,p->screen->display_opt,0);
		count++;
	 }
 }
else if (next[1]=='d' && p->hes>okerr) /* show only small dot
instead of circle, sphere only.*/
 {
	for (i=1;i<=p->nodecount;i++)
	 {
		ctr=ss_view(p->screen,p->packR_ptr[i].center,1,&dum_int);
		if (cos(ctr.re)>0) /* on front */
		 {
			ctr.re=sin(ctr.im)*sin(ctr.re);
			ctr.im=cos(ctr.im);
			circle(p->screen,ctr,.005,1,FG_COLOR,1);
		 }
	 }
 }
else if (next[1]=='C') /* all circles, recomputed as drawn */
 {
	if (next[2]=='f' || next[3]=='f') fill=1;
	else fill=0;
	if (next[2]=='n' || next[3]=='n') dflag=6; /* with labels */
	else dflag=1;
	count += draw_in_order(p,dflag,fill,0,dspeed);
	if (!dspeed) refresh_canvas(p->screen); 
 } /* finished with circle cases */
else if (next[1]=='e') /* draw edges */
 {
	fill=0;
	if (next[2]=='e' && (vertlist=node_link_parse(p,nextpoint,
		&endptr,&hits))!=NULL) /* hex extended edges */
	 {
		nextpoint=endptr;
		trace=vertlist;
		while (trace && (v=trace->v)
		   && trace->next && (w=trace->next->v)) /* get pairs */
		 {
			trace=trace->next;
			if ((eelist=get_extended_edge(p,v,w,16))!=NULL)
			 {
			   eetrack=eelist;
			   do {
			   	count+=draw_edge(p,eetrack->v,
					eetrack->w,-1,dspeed);
				eetrack=eetrack->next;
			    } while (eetrack!=NULL);
			   edge_free(&eelist);
			 }
		 }
		vert_free(&vertlist);
		if (!dspeed) refresh_canvas(p->screen);
	 }
	else if ((edgelist=node_pair_link(p,nextpoint,&endptr,&hits))
		!=NULL)
	 {
		nextpoint=endptr;
		track=edgelist;
		do {
			count+=draw_edge(p,track->v,track->w,-1,dspeed);
			track=track->next;
		 } while (track!=NULL);
		edge_free(&edgelist);
		if (!dspeed) refresh_canvas(p->screen);
	 }
	else 
	 {
		q->display_opt=4;
		panel_set(sopt[pnum],PANEL_VALUE,2,0);
		disp_screen(p,p->screen->display_opt,0);
		count++;
	 }
 } /* finished with edges */
else if (next[1]=='f' || next[1]=='F') /* draw faces */
 {
	if (next[2]=='f') fill=1; /* want filled faces*/
	else fill=0;
	if ((facelist=
		face_link_parse(p,nextpoint,&endptr,&hits))!=NULL)
	 {
		nextpoint=endptr;
		if (fill)
		 {
			if (next[3]=='f' && next[4]=='g') cflag=2;
			else if (next[3]=='b' && next[4]=='g') cflag=1;
			    /* want foreground or background color? */
			else cflag=3; /* use specified color */ 
		 }
		else cflag=0;
		if (next[1]=='F')  /* locate faces as they're drawn */
		 {
		   if (next[2]=='n') 
			count += layout_facelist(p,cflag,&facelist,1,0,1,SHOW);
		   else count += layout_facelist(p,cflag,&facelist,1,0,0,SHOW);
		 }
		else count += layout_facelist(p,cflag,&facelist,0,0,0,SHOW);
	 }
	else if (next[1]=='F') /* use draworder, but recompute cents */
	 {
		if (next[2]=='C') /* also circles */
		 {
			if (next[3]=='n') dflag=8; /* with f/c labels */
			else dflag=3;
		 }
		else if (next[2]=='n') dflag=7; /* with labels */
		else dflag=2;
		count += draw_in_order(p,dflag,fill,0,dspeed);
		if (!dspeed) refresh_canvas(p->screen);
	 }				
	else 
	 {
		if (fill) 
		 {
			q->display_opt=7;
			panel_set(sopt[pnum],PANEL_VALUE,3,0);
		 }
		else
		 {
			q->display_opt=4;
			panel_set(sopt[pnum],PANEL_VALUE,2,0);
		 }
		disp_screen(p,p->screen->display_opt,0);
		count++;
	 }
 } /* finished with faces */
else if (next[1]=='s') /*  shaded polygon about vertlist */
 {
	if (next[2]=='f') fill=1;
	else fill=0;
	if ((vertlist=node_link_parse(p,nextpoint,
		&endptr,&hits))!=NULL)
	 {
		nextpoint=endptr;
		col=0;
		if (fill && next[3]=='f' && next[4]=='g') col=FG_COLOR;
		else if (fill && next[3]=='b' && next[4]=='g') col=BG_COLOR;
		trace=vertlist;
		if (p->hes<(-okerr))
			count += h_polygon(p,vertlist,fill,col,dspeed);
		else if (p->hes<okerr)
			count += e_polygon(p,vertlist,fill,col,dspeed);
		else count += s_polygon(p,vertlist,fill,col,dspeed);
		vert_free(&vertlist);
		refresh_canvas(p->screen);
	 }
 }
else if (next[1]=='n') /* label */
 {
	if (next[2]=='f') /* faces */
	 {
		if ((facelist=face_link_parse(p,
			nextpoint,&endptr,&hits))!=NULL)
		 {
			nextpoint=endptr;
			trace=facelist;
			do {
			   count += 
				draw_face_number(p,trace->v,trace->v,dspeed);
			   trace=trace->next;
			 } while (trace!=NULL);
			vert_free(&facelist);
			refresh_canvas(p->screen);
		 }
		else 
		 {
			disp_screen(p,6,0);
			count++;
		 }
	 }
	else if (next[2]=='c') /* circles */
	 {
		if ((vertlist=node_link_parse(p,
			nextpoint,&endptr,&hits))!=NULL)
		 {
			nextpoint=endptr;
			trace=vertlist;
			do {
			   count +=
				draw_cir_number(p,trace->v,trace->v,dspeed);
			   trace=trace->next;
			 } while (trace!=NULL);
			vert_free(&vertlist);
			refresh_canvas(p->screen);
		 }
		else
		 {
			disp_screen(p,5,0);
			count++;
		 }
	 }
	else if ( 			/* 'l' or 'z' */
	   (
	    (
	     next[2]=='z'  		/* given point */
		&& grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&(ctr.re))
		&& grab_next(&nextpoint,next)
		   && sscanf(next,"%lf",&(ctr.im))
		&& !(i=0)
	    )
	    ||
	    (
	     next[2]=='l'  		/* or center of circle */
		&& grab_next(&nextpoint,next)
		   && (i=atoi(next))>0 && i<=p->nodecount
	    )
	   )
	   && grab_next(&nextpoint,next) 
	   && strlen(strncpy(buf,next,32))!=0 
		)
		/* put string either at cent of i or at given ctr. */
	 {
		strcat(buf,"\0");
		if (i>0) ctr=p->packR_ptr[i].center;
		count += write_at_pt(p,ctr,buf,1); /* write string at pt. */
	 }
 } /* finished with labeling */
else if (next[1]=='g') /* display a closed path */
 {
	if ((length=pathlength)>3)
	 {
		Xptr=path_XPoints(p->screen,pathlist,&length);
		XDrawLines(display,p->screen->xpm,gc,Xptr,length,CoordModeOrigin);
		count++;
	 }
	if (next[2]=='i')  /* find and draw circles inside path. */
	 {
		count+=find_path_int(p); 
		for (i=1;i<=p->nodecount;i++)
			if (p->packK_ptr[i].plot_flag)
			   draw_any_circle(p,i,1,FG_COLOR,0);
	 }
	free(Xptr);
	refresh_canvas(p->screen);
 }
else if (next[1]=='r') /* reset */
 {
	reset_screen(p->screen);
	count++;
 }
else if (next[1]=='u') /* unit circle */
 {
	if (p->hes>0) equator(p->screen);
	else unitcircle(p->screen);
 }
else if (next[1]=='x') /* display coord axes */
 {
	coord_axes(p);
 }
else if (next[1]=='t') /* display caption (filename=default); must
	be last action requested in this disp call. */
 {
	if (strlen(strcpy(buf,nextpoint))==0) strcpy(buf,p->file_name);
	count += caption(p->screen,buf);
	return count;
 } 
else if (next[1]=='z') /* set draw_speed */
 {
 	if (next[2]=='f') dspeed = 0; /* fast (i.e. accumulate, display once*/
 	else if (next[2]=='s') dspeed =1; /* slow */
 	else dspeed=(dspeed) ? 0 : 1; /* toggle */
 }
	 } /* end of do */
	while (nextpoint!=NULL && grab_next(&nextpoint,next) );
	return count;		
} /* display_call */

disp_screen(p,opt,show) /* display pack p. Options are:
0=filled circles,  1=open circles,  2=tile by facedraworder, 
3=clear, 4=open complex, 5= label nodes, 6=label faces, 7=filled
complex, 8=open circles and open complex.*/
struct p_data *p;
int opt,show;
{
  	if (!p->status)
  		{sprintf(msgbuf,"pack %d is empty",pack_num(p));msg();return;}
	if (p->hes>0) unitcircle(p->screen);
  	if (opt==3)
	 {
		clear_canvas(p->screen);
		if (p->hes>0) unitcircle(p->screen);
		return;
	 }
	if (p->screen->unitcircle)
	 {
		if (p->hes>0) equator(p->screen);
		else unitcircle(p->screen);
	 }
	if (p->screen->coord_flag) coord_axes(p);
	if (opt==1 || opt==8) draw_circles(p,0,show); /* draw open circles */
	if (opt==1) return;
	if (opt==0) draw_circles(p,1,show); /* draw closed circles */
	if (opt==4 || opt==8) draw_complex(p,0,show);/* open complex */
	if (opt==7) draw_complex(p,1,show); 	/* draw filled complex */
	if (opt==5) draw_node_labels(p,show);	/* display node numbers */
	if (opt==6) draw_face_labels(p,show); 	/* display face numbers */
	return;
} /* disp_screen */

int
unitcircle(q) /* scales data for unit circle, screen q, and calls for circle */
struct s_data *q;
{
	complex zero;

	zero.re=0;zero.im=0;
	return (circle(q,zero,1.0,0,0,1)); /* open circle */
} /* unitcircle */

int
equator(q) /* put equator on screen q if spherical */
struct s_data *q;
{
	complex ctr;
	extern complex ss_view();

	ctr.re=0.0;ctr.im=M_PI;
	return s_circle(q,ss_view(q,ctr,1,&dum_int),M_PI/2.0,0,BG_COLOR,1);
} /* equator */

coord_axes(p) /* display coord axes on screen */
struct p_data *p;
{
	int front;
	complex pt,end1,end2;
	float V[3];
	extern complex ss_view();

	if (p->hes<okerr)
	 {
		end1.re=-1.1;end2.re=1.1;
		end1.im=end2.im=0.0;
		kline(p->screen,end1,end2,-1,1);
		end1.re=end2.re=0.0;
		end1.im=-1.1;end2.im=1.1;
		kline(p->screen,end1,end2,-1,1);
		return;
	 }
/* x-axis */
	end1.re=end1.im=0.0;
	end2.re=0.0;end2.im=M_PI/2.0;
	pt=ss_view(p->screen,end2,1,&front);
	s_pt_to_vec(pt,V);
	end2.re=V[1]*1.1;end2.im=V[2]*1.1;
	kline(p->screen,end1,end2,-1,1);
/* y-axis */
	end2.re=M_PI/2.0;end2.im=M_PI/2.0;
	pt=ss_view(p->screen,end2,1,&front);
	s_pt_to_vec(pt,V);
	end2.re=V[1]*1.1;end2.im=V[2]*1.1;
	kline(p->screen,end1,end2,-1,1);
/* z-axis */
	end2.re=0.0;end2.im=0.0;
	pt=ss_view(p->screen,end2,1,&front);
	s_pt_to_vec(pt,V);
	end2.re=V[1]*1.1;end2.im=V[2]*1.1;
	kline(p->screen,end1,end2,-1,1);
} /* coord_axes */
	
int
kline(q,end1,end2,col,show) /* like kline, use FG_COLOR if col==-1 */
struct s_data *q;
int col,show;
complex end1,end2;
{
	int x1,x2,y1,y2,n=0;
	complex n1,n2;

	if ((end1.re==end2.re && end1.im==end2.im) || 
		line_ck(end1,end2,q->box))
	 {
		r_to_pix(end1,&n1,q->pix_box,
			q->box,Aspect);
		r_to_pix(end2,&n2,q->pix_box,
			q->box,Aspect);
		while ((fabs(n1.re)>2000.0 || fabs(n1.im)>2000.0 
			|| fabs(n2.re)>2000.0 || fabs(n2.im)>2000.0) && n<5)
		 {
			if (fabs(n1.re)>2000.0 || fabs(n1.im)>2000.0)
			 {
				n++;
				n1.re=(n1.re+2*n2.re)/3.0;
				n1.im=(n1.im+2*n2.im)/3.0;
			 }
			if (fabs(n2.re)>2000.0 || fabs(n2.im)>2000.0)
			 {
				n++;
				n2.re=(n2.re+2*n1.re)/3.0;
				n2.im=(n2.im+2*n1.im)/3.0;
			 }
		 } /* shorten if line extremely long */
		x1=n1.re;y1=n1.im;
		x2=n2.re;y2=n2.im;
		if (col>=0)
		 {
			XSetForeground(display,gc,colors[col]);
			XDrawLine(display,q->xpm,gc,x1,y1,x2,y2);
			XSetForeground(display,gc,fgcolor);
		 }
		else XDrawLine(display,q->xpm,gc,x1,y1,x2,y2);
		if (show) refresh_canvas(q);
		return 1;
	 }
	return 0;
} /* kline */

int
caption(q,datastr) /* writes buffer contents as title on screen */
struct s_data *q;
char *datastr;
{
	int x,y;

	x=40; /* offset from edge */
	y=q->pix_box.ry-q->pix_box.ly-x;
	XDrawString(display,q->xpm,gc,x,y,buf,strlen(datastr));
	refresh_canvas(q);
	return 1;
} /* caption */

clear_canvas(q)		/* clear canvas q */
struct s_data *q;
{
	XSetForeground(display,gc,bgcolor);
	XFillRectangle(display,q->xpm,gc,0,0,MAX_PIXEL,MAX_PIXEL);
	XSetForeground(display,gc,fgcolor);
	refresh_canvas(q);
} /* clear_canvas */

int
shownumber(q,n,pt,show) /* print number in canvas. */
struct s_data *q;
int n,show;
complex pt;
{
	int x,y;
	char num[10]; /* buffer for digits */
	complex normpt;

	r_to_pix(pt,&normpt,q->pix_box,
		q->box,Aspect);
	if ((x=(int)normpt.re)>q->pix_box.rx || x < 0
	   || (y=(int)normpt.im) > q->pix_box.ry || y < 0)
		return 0; /* pt off screen */
	if (n>10) x -= 5;
	if (n>100) x -= 5; /* shift a little for better positioning */
	sprintf(num,"%d",n);
	XDrawString(display,q->xpm,gc,x,y,num,strlen(num));
	if (show) refresh_canvas(q);
	return 1;
} /* shownumber */

int
draw_in_order(p,flag,fill,pl,show) /* draw faces and/or circles in drawingorder,
but draw and recompute as you go along. E.g., will give 'ghosts'.
flag: 1=circles,2=faces,3=both. +5 --> also labels. If pl is set, then
place first face; else, leave in current location. */
struct p_data *p;
int flag,fill,pl,show;
{
	int nf,ind,a,b,c,ck=0;

	nf=p->first_face;
	if (pl) place_face(p,nf,p->faces[nf].index_flag);
	if (flag==1 || flag==3 || flag==6 || flag==8)
	 {
		ind=p->faces[nf].index_flag;
		a=p->faces[nf].vert[ind];
		b=p->faces[nf].vert[(ind+1) % 3];
		c=p->faces[nf].vert[(ind+2) % 3];
		draw_any_circle(p,a,fill,p->packK_ptr[a].color,show);
		draw_any_circle(p,b,fill,p->packK_ptr[c].color,show);
		draw_any_circle(p,c,fill,p->packK_ptr[c].color,show);
		if (flag==6 || flag==8)
		 {
			draw_cir_number(p,a,a,show);
			draw_cir_number(p,b,b,show);
			draw_cir_number(p,c,c,show);
		 }
	 }
	if (flag==2 || flag==3 || flag==7 || flag==8)
		draw_any_face(p,nf,fill,p->faces[nf].color,show);
	if (flag==7 || flag==8) draw_face_number(p,nf,nf,show);
	while ( (nf=p->faces[nf].next_face)!=p->first_face 
		&& ck<2*p->facecount && nf>0 && nf <= p->facecount)
	 {
		comp_center_face(p,nf,-1);
		if (flag==1 || flag==3|| flag==6 || flag==8)
		 {
			c=p->faces[nf].vert[(p->faces[nf].index_flag + 2) % 3];
			draw_any_circle(p,c,fill,p->packK_ptr[c].color,show); 
				/* new circle */
			if (flag==6 || flag==8) draw_cir_number(p,c,c,show);
		 }
		if (flag==7 || flag==8) draw_face_number(p,nf,nf,show);
		if (flag==2 || flag==3 || flag==7 || flag==8)
			draw_any_face(p,nf,fill,p->faces[nf].color,show);
		ck++;
	 }
	if (nf!=p->first_face) /* some error */
		return 0;
	return 1;
} /* draw_in_order */

int
layout_report(p,v,flag) /* recompute centers using drawing order as
in draw_in_order. Report all locations of vertex v. flag means to
place first face. Note that this changes center data. */
struct p_data *p;
int v,flag;
{
struct Centlist
 {
	complex z;
	struct Centlist *next;
 } *centlist,*ctmp,*ctrace;

	int start=0,move=0,j,nf,vert,vflag=1,ck=0;
	complex a,g,w,I,modw,newz,z,y;
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	centlist=NULL;
	if (v>0 && v<=p->nodecount) vflag=0;
	nf=p->first_face;	
	if (flag) place_face(p,nf,p->faces[nf].index_flag);
	for (j=0;j<3;j++) /* initial location of v */
		if (p->faces[nf].vert[j]==v) /* record first center */
		 {
		   start=j+1;
		   ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
		   ctmp->z=pR_ptr[v].center;
		   if (!centlist) centlist=ctrace=ctmp;
		   else ctrace=ctrace->next=ctmp;
		 }
	while ( (nf=p->faces[nf].next_face)!=p->first_face 
		&& ck<2*p->facecount && nf>0 && nf <= p->facecount)
	 {
		comp_center_face(p,nf,-1);
		vert=p->faces[nf].vert[(p->faces[nf].index_flag + 2) % 3];
		if (!vflag && vert==v) 
			/* record center */
		 {
		   move++;
		   ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
		   ctmp->z=pR_ptr[v].center;
		   if (!centlist) centlist=ctrace=ctmp;
		   else ctrace=ctrace->next=ctmp;
		 }
		ck++;
	 }
	if (nf!=p->first_face) /* some error */
		return 0; 
	if (!vflag && start && move) 
		/* if v in first face and has moved, give final location */
	 {
		   ctmp=(struct Centlist *)calloc(1,sizeof(struct Centlist));
		   ctmp->z=pR_ptr[v].center;
		   if (!centlist) centlist=ctrace=ctmp;
		   else ctrace=ctrace->next=ctmp;
	 }
/* normalize */
	a=pR_ptr[p->alpha].center;
	g=pR_ptr[p->gamma].center;
	norm_any_pack(p,a,g);
/* adjust locations reported for v because of normalization */
	if (centlist)
	 {
		sprintf(msgbuf,"Locations of vertex %d, p%d: ",
			v,pack_num(p));
		msg();
		ctrace=centlist;
		while (ctrace)
		 {
		   z=newz=ctrace->z;
		   if (p->hes< (-okerr)) /* hyp */
			newz=mob_norm(z,a,g);
		   else if (p->hes < okerr) /* eucl */
		    {
			w=csub(g,a);
			I.re=0; I.im=cAbs(w);
			modw=cdiv(I,w);
			y=csub(z,a);
			newz=cmult(modw,y);
		    }
		   sprintf(msgbuf,"% .10e + % .10e i ;",newz.re,newz.im);
		   msg();
		   ctmp=ctrace;
		   ctrace=ctrace->next;
		   free(ctmp);
		 }
	 }
	return (vflag+start+move); /* error if this is zero */
} /* layout_report */

int
draw_complex(p,ff,show) /* draw whole complex. fill flag. */
struct p_data *p;
int ff,show;
{
	int k,j,jj;
	complex end1,end2;

	if (!p->status) return 0;
	if (ff) /* filled complex is done by faces */
	  for (k=1;k<=p->facecount;k++) 
		draw_any_face(p,k,1,p->faces[k].color,show);
	else /* otherwise, draw edges by vert */ 
	 {
		for (k=1;k<=p->nodecount;k++) 
			p->packK_ptr[k].plot_flag=0;
		for (k=1;k<=p->nodecount;k++)
		 {
			end1=p->packR_ptr[k].center;
			for (j=0;j<p->packK_ptr[k].num 
				+ p->packK_ptr[k].bdry_flag;j++)
			 {
				jj=p->packK_ptr[k].flower[j];
				if (!p->packK_ptr[jj].plot_flag)
				 {
				   end2=p->packR_ptr[jj].center;
				   if (p->hes<0) 
					hgeo(p->screen,end1,end2,-1,0);
				   else if (p->hes>0)
					sgeo(p->screen,end1,end2,-1,0);
				   else  
					kline(p->screen,end1,end2,-1,0);
				 }
			 }
			p->packK_ptr[k].plot_flag=1;
		 }
	 }
	refresh_canvas(p->screen); 
	return 1;
} /* draw_complex */

int
layout_facelist(p,flag,facelist,fix,l_face,nflag,show) /* lay out
faces from facelist; display if show. 
flag: 0=open, 1=background, 2=foreground, 3=color. fix=1 means to 
locate faces successively as drawn (changing stored
centers). facelist is cleared. l_face="live face" may be given; 
if nflag, draw face numbers. */
struct p_data *p;
int flag,fix,l_face,nflag,show;
struct Vertlist **facelist;
{
	int col=0,fill=0,n,v1,v2,v3,vv=0;
	float o1,o2,o3;
	struct Vertlist *trace;
	struct K_data *pK_ptr;
	struct R_data *pR_ptr;

	pK_ptr=p->packK_ptr;pR_ptr=p->packR_ptr;
	if ((*facelist)==NULL) return 0;
	switch(flag)
	 { case 1:{fill=1;col=BG_COLOR;break;}
	   case 2:{fill=1;col=FG_COLOR;break;}
	   case 3:{fill=1;break;}
	 }
	trace=*facelist;
		/* find first */
	if (l_face>0 && l_face<=p->facecount) vv=l_face;
	do {
			/* if fix, draw successive ones as contig. */
		if (fix)
		 {
		   if ( (n=nghb_tri(p,vv,trace->v))<0 )
			n=p->faces[trace->v].index_flag;
			/* if not contig, use index_flag */
		   v1=p->faces[trace->v].vert[n];
		   v2=p->faces[trace->v].vert[(n+1)%3];
		   v3=p->faces[trace->v].vert[(n+2)%3];

	if (p->overlap_status) /* oj for edge opposite vj */
	 {
		o1=pK_ptr[v2].overlaps[nghb(p,v2,v3)];
		o2=pK_ptr[v3].overlaps[nghb(p,v3,v1)];
		o3=pK_ptr[v1].overlaps[nghb(p,v1,v2)];
	 }
	else o1=o2=o3=1.0;
	any_compcenter(p->hes,
		pR_ptr[v1].center,pR_ptr[v2].center,&pR_ptr[v3].center,
		pR_ptr[v1].rad,pR_ptr[v2].rad,&pR_ptr[v3].rad,o1,o2,o3);
			/* compute and store new center */
		 }

		while (trace!=NULL && trace->v==vv) trace=trace->next;
					/* skip repeats */
		if (trace==NULL) break;
		vv=trace->v;
		if ( show && vv>0 && vv<=(p->facecount) )
		 {
		   if (flag==3) col=p->faces[vv].color;
		   draw_any_face(p,vv,fill,col,1);
		   if (nflag) draw_face_number(p,vv,vv,0);
		 }
		trace=trace->next;
	 } while (trace!=NULL);
	vert_free(facelist);
	return vv;
} /* layout_facelist */

struct Vertlist *
parse_facepath(p,path,livenode) /* list faces along given path. Pass
(possible) start and ending node. */
struct p_data *p;
struct Pathlist *path;
int *livenode;
{
	int pn,flag,k;
	complex ctr[3],pt,normpt;
	float dum,det;
	struct Vertlist *thelist,*trace,*nodelist;
	extern struct Vertlist *tri_search();
	struct R_data *pR_ptr;
	extern float row_col();

	pR_ptr=p->packR_ptr;
	pn=pack_num(p);
	thelist=NULL;
	if(path==NULL) return NULL;
	pt.re=path->x;pt.im=path->y;
	if (*livenode<1 || *livenode>p->facecount 
	   || !pt_in_tri(p,*livenode,pt.re,pt.im)) 
		*livenode=0;
	if (*livenode)
	 {
		trace=thelist=(struct Vertlist *)
			calloc(1,sizeof(struct Vertlist));
		trace->v=*livenode;
	 }
	else {while (path!=NULL && thelist==NULL)
	 {
		r_to_pix(pt,&normpt,p->screen->pix_box,p->screen->box);
		if ( (nodelist=tri_search(pn,
	   	   (int)(normpt.re),(int)(normpt.im)))!=NULL)
		 {
			trace=thelist=(struct Vertlist *)
			   calloc(1,sizeof(struct Vertlist));
			trace->v=*livenode=nodelist->v;
			vert_free(&nodelist);
		 }
		path=path->next;
	 }}
	if (path==NULL) return thelist;
	while (path!=NULL)
	 {
		for (k=0;k<=2;k++)
		 {
		   if (p->hes<0) 
			h_to_e_data(pR_ptr[p->faces[*livenode].vert[k]].
	   	           center,pR_ptr[p->faces[*livenode].vert[k]].rad,
		           &ctr[k],&dum);
		   else ctr[k]=pR_ptr[p->faces[*livenode].vert[k]].center;
		 }
		if ((ctr[0].re*(ctr[1].im-ctr[2].im)
		   -ctr[1].re*(ctr[0].im-ctr[2].im)
		   +ctr[2].re*(ctr[0].im-ctr[1].im))>0) det=1.0;
		else det=-1.0;
		while (path!=NULL 
		   && (det*row_col(path->x,path->y,
			ctr[1].re,ctr[2].re,ctr[1].im,ctr[2].im))>0
	   	   && (det*row_col(path->x,path->y,
			ctr[2].re,ctr[0].re,ctr[2].im,ctr[0].im))>0
	   	   && (det*row_col(path->x,path->y,
			ctr[0].re,ctr[1].re,ctr[0].im,ctr[1].im))>0 )
			path=path->next;
		flag=0;
		while (path!=NULL && !flag)
		 {
			pt.re=path->x;pt.im=path->y;
			r_to_pix(pt,&normpt,p->screen->pix_box,
				p->screen->box);
			if ( ((nodelist=tri_search(pn,
	   	  	 (int)(normpt.re),(int)(normpt.im)))!=NULL) && 
			 nodelist->v!=*livenode )
			 {
				trace->next=(struct Vertlist *)
				   calloc(1,sizeof(struct Vertlist));
				trace=trace->next;
				trace->v=*livenode=nodelist->v;
				vert_free(&nodelist);
				flag=1;
			 }
			path=path->next;
		 }
	 }
	return thelist;
} /* parse_facepath */

int
draw_node_labels(p,show)
struct p_data *p;
int show;
{
	int i;
	
	if (!p->status) return 0;
	for (i=1;i<=p->nodecount;i++)
		draw_cir_number(p,i,i,show);
	refresh_canvas(p->screen);
	return 1;
} /* draw_node_labels */

int
draw_cir_number(p,v,n,show) /* write n at center of circle v */
struct p_data *p;
int v,n,show;
{
	int front;
	float stretch;
	complex ctr;
	
	if (!p->status) return 0;
	stretch=1.0+(p->screen->box.rx-p->screen->box.lx)*15/
	   (p->screen->pix_box.rx-p->screen->pix_box.lx); 
		/* to shift horocycle labels a little to miss circle*/
	if (p->hes<0 && p->packR_ptr[v].rad<0)
	 {
		 ctr.re=p->packR_ptr[v].center.re*stretch;
		 ctr.im=p->packR_ptr[v].center.im*stretch;
	 } 
	else if (p->hes>okerr) 
	 {
		ctr=ss_view(p->screen,p->packR_ptr[v].center,1,&front);
		if (!front) return 0;
		ctr=s_pt_to_visual_plane(ctr);
	}
	else ctr=p->packR_ptr[v].center;
	return (shownumber(p->screen,n,ctr,show));
} /* draw_cir_number */

int
write_at_pt(p,pt,datastr,show) /* write string at pt on screen (for 
sphere, need to convert). */
struct p_data *p;
complex pt;
char *datastr;
int show;
{
	int front,x,y;
	complex normpt;
	
	if (p->hes>okerr) /* sphere */
	 {
		pt=ss_view(p->screen,pt,1,&front);
		if (!front) return 0;
		pt=s_pt_to_visual_plane(pt);
	 }
	r_to_pix(pt,&normpt,p->screen->pix_box,p->screen->box,Aspect);
	if ((x=(int)normpt.re)<=p->screen->pix_box.rx 
	   && x >= 0
	   && (y=(int)normpt.im) <= p->screen->pix_box.ry 
	   && y >= 0) /* on screen */
	 {
		XDrawString(display,p->screen->xpm,gc,x,y,
			datastr,strlen(datastr));
		if (show) refresh_canvas(p->screen);
	 }
	return 1;
} /* write_at_pt */

int
draw_face_labels(p,show)
struct p_data *p;
int show;
{
	int k;

	if (!p->status) return 0;
	for (k=1;k<=p->facecount;k++) 
		draw_face_number(p,k,k,show);
	refresh_canvas(p->screen);
	return 1;
} /* draw_face_labels */

int
draw_face_number(p,face,n,show) /* number n in face face */
struct p_data *p;
int face,n,show;
{
	int i0,i1,i2,front;
	complex ctr,p0,p1,p2;
	extern complex sph_tri_center();
	struct R_data *pR_ptr;

	pR_ptr=p->packR_ptr;
	i0=p->faces[face].vert[0];p0=pR_ptr[i0].center;
	i1=p->faces[face].vert[1];p1=pR_ptr[i1].center;
	i2=p->faces[face].vert[2];p2=pR_ptr[i2].center;
	if (p->hes<=0)
	 {
		ctr.re=(p0.re+p1.re+p2.re)*.33333;
		ctr.im=(p0.im+p1.im+p2.im)*.33333;
	 }
	if (p->hes>0)
	 {
		ctr=sph_tri_center(p0,p1,p2);
		ctr=ss_view(p->screen,ctr,1,&front);
		if (!front) return 0;
		ctr=s_pt_to_visual_plane(ctr);
	 }
	return (shownumber(p->screen,n,ctr,show));

} /* draw_face_number */

complex
ss_view(q,pt,flag,front) /* Convert real to apparent pt on sphere
(flag=1) or vice verse (flag=0), based on disp_trans settings, screen q.
front=1 if pt is on front of sphere. */ 
struct s_data *q;
int flag,*front;
complex pt;
{
	float x,y,z,xx,yy,zz;
	complex ans;

	x=sin(pt.im)*cos(pt.re);
	y=sin(pt.im)*sin(pt.re);
	z=cos(pt.im);
	if (flag)
	 {
		xx=q->disp_trans[0][0]*x+
		  q->disp_trans[0][1]*y+
		  q->disp_trans[0][2]*z;
		yy=q->disp_trans[1][0]*x+
		  q->disp_trans[1][1]*y+
		  q->disp_trans[1][2]*z;
		zz=q->disp_trans[2][0]*x+
		  q->disp_trans[2][1]*y+
		  q->disp_trans[2][2]*z;
	 }
	else
	 {
		xx=q->disp_inv_trans[0][0]*x+
		  q->disp_inv_trans[0][1]*y+
		  q->disp_inv_trans[0][2]*z;
		yy=q->disp_inv_trans[1][0]*x+
		  q->disp_inv_trans[1][1]*y+
		  q->disp_inv_trans[1][2]*z;
		zz=q->disp_inv_trans[2][0]*x+
		  q->disp_inv_trans[2][1]*y+
		  q->disp_inv_trans[2][2]*z;
	 }
	if (xx>=0) *front=1;else *front=0;
	ans.re=aTan2(yy,xx);
	ans.im=acos(zz);
	return ans;
} /* ss_view */

complex
proj_to_sph(a,b) /* project (a,b) to sphere. */
float a,b;
{
	float dist,z;
	complex ans;

	if ((dist=a*a+b*b)>1.0) 
	 {ans.re=ans.im=0.0;return ans;} /* default is north pole */
	z=sqrt(1-dist);
	ans.re=aTan2(b,a);
	ans.im=acos(z);
	return ans;
} /* proj_to_sph */

int
draw_circles(p,ff,show) /* draw whole pack */
struct p_data *p;
int ff,show;
{
	int i;

	for (i=1;i<=p->nodecount;i++)
		draw_any_circle(p,i,ff,
			p->packK_ptr[i].color,show);
	refresh_canvas(p->screen);
	return 1;
} /* draw_circles */

XPoint *
path_XPoints(q,path,length) /* converts path to list of XPoints 
w.r.t. screen q, returns ptr, max pts is length, returns new 
length*/
struct s_data *q;
int *length;
struct Pathlist *path;
{
	int count=0;
	XPoint *Xptr=NULL;
	struct Pathlist *trace;
	complex pt,normpt;

	if (path==NULL 
		|| ((Xptr=(XPoint *)malloc((*length)*sizeof(XPoint)))==NULL) )
			return (NULL); /* no path */
	trace=path;
	while (trace!=NULL && count<*length)
	 {
		pt.re=trace->x;pt.im=trace->y;
		r_to_pix(pt,&normpt,q->pix_box,
			q->box,Aspect);
		(Xptr+count)->x=(short)(normpt.re);
		(Xptr+count)->y=(short)(normpt.im);
		trace=trace->next;
		count++;
	 }
	*length=count;
	return (Xptr);
} /* path_XPoints */
		
refresh_canvas(q) /* puts pixmap onto canvas */
struct s_data *q;
{
	int snum=screen_num(q);
	
	if (canvas[snum])
	 {
	   XCopyArea(display,q->xpm,q->xid,gc,0,0,
		q->pix_box.rx,q->pix_box.ry,0,0);
	   XFlush(display); /* ?? put this after next? */
	   if ((int) xv_get(manip_frame[snum],WIN_SHOW))
		xv_set(manip_frame[snum],WIN_SHOW,TRUE,0);
	 }
} /* refresh_canvas */

set_cursor(q,m) /* set ms_flag, set item, set cursor */
struct s_data *q;
int m;
{
	int code,snum=screen_num(q);
	Canvas canvas_q;

	canvas_q=canvas[snum];
	if (packdata[snum].locks) /* pack is locked */
		if (m>1 && m <8 && m!=5) m=0;
	q->ms_flag=m;
	switch(m)
	 {
case 0: /* desensitized mouse */
 {
	if (packdata[snum].locks) xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, lock_cursor,0);
	else if (current_p==snum) xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, act_can_cursor,0);
	else xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR,inact_can_cursor,0);	
	code=0;
	break;
 }
case 2: /* add_cir */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, add_cursor,0);
	code=1;
	break;
 }
case 3: /* rm_cir */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, delete_cursor,0);
	code=3;
	break;
 }
case 4: /* enfold */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, enfold_cursor,0);
	code=2;
	break;
 }
case 5: /* coords */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, axes_cursor,0);
	code=9;
	break;
 }
case 6: /* inc_rad */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR,incr_cursor,0);
	code=4;
	break;
 }
case 7: /* dec_rad */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR,decr_cursor,0);
	code=5;
	break;
 }
case 8: /* path */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR,path_cursor,0);
	code=7;
	break;
 }
case 9: /* project */
 {
	xv_set(canvas_paint_window(canvas_q),
		WIN_CURSOR, proj_cursor,0);
	code=10;
	break;
 }
	 } /* end of switch */
 	panel_set(manip_item[snum],PANEL_VALUE,code,0);
} /* set_cursor */


/* ==================== various message printers ===================== */

	/* message in panel */

msg() /* send msgbuf contents to message subwindow */
{
	int textlength;

	if (line_cmds_only)
	 {
	 	fprintf(stdout,emsgbuf);
	 	return;
	 }
	xv_set(msg_sw,TEXTSW_INSERTION_POINT,TEXTSW_INFINITY,0);
	textlength=strlen(msgbuf)-1;
	if (textlength<0) return;
	if (textlength>254) msgbuf[256]='\0';
	if (msgbuf[textlength]!='\n') strcat(msgbuf,"\n");
	textsw_insert(msg_sw,msgbuf,strlen(msgbuf));
	if ( (textlength=((int)xv_get(msg_sw,TEXTSW_LENGTH)-MSG_LENGTH))>0 )
	 {
		textsw_erase(msg_sw,0,textlength+1);
	 }
	textsw_possibly_normalize(msg_sw,
		(Textsw_index)xv_get(msg_sw,TEXTSW_INSERTION_POINT));
	XFlush(display);
} /* msg */

emsg() /* send emsgbuf contents to message subwindow */
{
	int textlength;

	if (line_cmds_only)
	 {
	 	fprintf(stdout,emsgbuf);
	 	return;
	 }
	xv_set(msg_sw,TEXTSW_INSERTION_POINT,TEXTSW_INFINITY,0);
	textlength=strlen(msgbuf)-1;
	if (textlength<0) return;
	if (textlength>264) emsgbuf[266]='\0';
	if (msgbuf[textlength]!='\n') strcat(emsgbuf,"\n");
	textsw_insert(msg_sw,emsgbuf,strlen(emsgbuf));
	if ( (textlength=((int)xv_get(msg_sw,TEXTSW_LENGTH)-MSG_LENGTH))>0 )
	 {
		textsw_erase(msg_sw,0,textlength+1);
	 }
	textsw_possibly_normalize(msg_sw,
		(Textsw_index)xv_get(msg_sw,TEXTSW_INSERTION_POINT));
	window_bell(msg_sw);window_bell(msg_sw);
	XFlush(display);
} /* emsg */

	/* in history subwindow */
hmsg(msg) char *msg;
{
	xv_set(log_sw,TEXTSW_INSERTION_POINT,TEXTSW_INFINITY,NULL);
	textsw_insert(log_sw,msg,strlen(msg));
/*	textsw_possibly_normalize(log_sw,
		(Textsw_index) xv_get(log_sw,TEXTSW_INSERTION_POINT));
*/
} 

	/* set labels of packs */
pmsg(i,msg) int i;char *msg;
{
	if (strlen(msg)>45) msg[45]='\0';
	strcpy(packlabels[i]+8,msg);
	set_pack_labels();
}

	/* message out to remote procedure */

msg_remote(i) int i;
{
	if (i<0 || i > NUM_PROC || !remote[i].pid) return;
	if (strlen(msgbuf)>255) msgbuf[256]='\0';
	if (msgbuf[strlen(msgbuf)]!='\n') strcat(msgbuf,"\n");
	fprintf(remote[i].fp_to_remote,"%s",msgbuf);
	fflush(remote[i].fp_to_remote);
}

canvmsg(i) int i;
{xv_set(canvas_frame[i],XV_LABEL,packlabels[i],0);}

set_pack_labels()
{
	switch (NUM_PACKS)
	 {
case 4:
 {
	xv_set(active_pack_item,PANEL_CHOICE_STRINGS,
		packlabels[0],
		packlabels[1],
		packlabels[2],
		packlabels[3],0,
		0);
	break;
 }
case 3:
 {
	xv_set(active_pack_item,PANEL_CHOICE_STRINGS,
		packlabels[0],
		packlabels[1],
		packlabels[2],0,
		0);
	break;
 }
case 2:
 {
	xv_set(active_pack_item,PANEL_CHOICE_STRINGS,
		packlabels[0],
		packlabels[1],0,
		0);
	break;
 }
case 1:
 {
	xv_set(active_pack_item,PANEL_CHOICE_STRINGS,
		packlabels[0],0,
		0);
 }
	 }
} /* set_pack_labels */

int
sphere_view(q,datastr) /* set transforms for spherical graphing */
struct s_data *q;
char *datastr;
{
	int i,j;
	float ax=0.0,ay=0.0,az=0.0;

	stripsp(datastr);
	if (*datastr=='-')
	 {
			/* default settings */
		if (*(datastr+1)=='d') 
		 {
			for (i=0;i<3;i++) 
			 {
				for (j=0;j<3;j++)
					q->disp_trans[i][j]=
					q->disp_inv_trans[i][j]=0.0;
				q->disp_trans[i][i]=
				   q->disp_inv_trans[i][i]=1.0;
			 }
			sph_rotation(0.0,-0.1*M_PI,-0.03*M_PI,
				q->disp_trans,
				q->disp_inv_trans);
		 }
		else if (*(datastr+1)=='i') /* incr change */
		 {
			if (sscanf(datastr+2,"%lf %lf %lf",&ax,&ay,&az)>0)
			 {
			   sph_rotation(ax*M_PI,ay*M_PI,az*M_PI,
				q->disp_trans,
				q->disp_inv_trans);
			 }
		 }
		return 1;
	 }
	if (sscanf(datastr,"%lf %lf %lf",&ax,&ay,&az)>0)
	 {
		for (i=0;i<3;i++) 
		 {
			for (j=0;j<3;j++)
				q->disp_trans[i][j]=
				q->disp_inv_trans[i][j]=0.0;
			q->disp_trans[i][i]=
			   q->disp_inv_trans[i][i]=1.0;
		 }
		sph_rotation(ax*M_PI,ay*M_PI,az*M_PI,
			q->disp_trans,
			q->disp_inv_trans);
	 }
	return 1;
} /* sphere_view */
