### $Id: deriv.q,v 1.1.1.1 1996/11/13 15:38:45 bates Exp $
 # Support functions
##*## deriv - symbolic differentiation for expressions

deriv <-
  ## Symbolic differentiation of expressions
  function(expr, ...) UseMethod("deriv")

deriv.default <-
  function(expr, namevec, function.arg = NULL, tag = ".expr")
{
  max.express <- unlist(options("expressions"))
  if(max.express < 1000) {
    options(expressions = 1000)		# this function is highly recursive
    on.exit(options(expressions = max.express))
  }
  assign("tag", tag, frame = 1)
  assign(".elist", NULL, frame = 1)
  npar <- length(namevec)
  fval <- exprgen(expr)
  ders <- 1:npar
  for(i in 1:npar) {
    di <- D(expr, namevec[i])
    if(!(ders[i] <- exprgen(di)))
      ders[i] <- addlist(di)
  }
  nexpr <- length(.elist)
  .elist <- c(.elist, paste(tag, c(fval, 0, ders), sep = ""))
  nextended <- length(.elist)
  expressions <- parse(text = .elist)
  graddef <- nexpr + 2	
  ## fold expressions.  Do not fold those used more than once
  nofold <- c(logical(nexpr), rep(T, npar + 2))
  nofold <- nofold | apply(outer(all.names(expressions),
				 paste(tag, 1:nextended, sep = ""), "=="),
			   2, sum) > 1
  parentemplate <- expression((a))[[1]]
  for(i in (1:nexpr)[!nofold]) {
    thisname <- paste(tag, i, sep = "")
    subst <- parentemplate
    subst[[2]] <- expressions[i][[1]]
    for(j in (i + 1):nextended) {
      if(match(thisname, all.names(expressions[j]), 0)) {
	thisexpr <- expressions[j][[1]]
	if(is.name(thisexpr))
	  thisexpr <- subst[[2]]
	else for(k in 1:length(thisexpr))
	  if(is.name(thisexpr[[k]]) && thisexpr[[k]] == 
	     thisname) thisexpr[[k]] <- subst
	expressions[j][[1]] <- thisexpr
	break
      }
    }
  }
  nams <- c(paste(tag, 1:nexpr, sep = ""), ".value", ".grad",
	    paste(".grad[ ,\"", namevec, "\"]", sep = ""))
  out <- parse(text = c("{", paste(nams, "<-", 0, sep = ""), "}"))
  body <- out[[1]]
  for(i in (1:nextended)[nofold])
    body[[i]][[2]] <- expressions[i][[1]]
  body[[graddef]][[2]] <- parse(text = c("array(0,c(length(.value),",
				    npar, "),list(NULL,",
				    deparse(namevec), "))"))[[1]]
  body <- body[nofold]
  added <- parse(text = c("attr(.value,\"gradient\") <- .grad", ".value"))
  body <- c(body, added)
  mode(body) <- "{"
  if(length(function.arg)) {
    if(is.function(function.arg))
      value <- function.arg
    else if(is.recursive(function.arg)) {
      value <- vector("expression", length(function.arg) + 1)
      value[ - length(value)] <- function.arg
    }
    else {
      value <- vector("expression", length(function.arg) + 1)
      names(value) <- c(as.character(function.arg), "")
    }
    mode(value) <- "function"
    value[[length(value)]] <- body
    ## manipulate the body so it puts the correct names on the gradient columns
    if (any(missng <- is.na(match(namevec, names(value))))) {
      warning(paste("The name(s)", paste(namevec[missng]),
		    "are not arguments to the function"))
      return(value)
    }
    replacement <-
      parse(text = paste(".actualArgs <- match.call()[",
		deparse(namevec), "];",
		"if (all(unlist(lapply(as.list(.actualArgs), is.name)))) {}")
	    )
    mode(replacement) <- "{"
    first.grad <- match(as.name(".grad"), unlist(lapply(body[-length(body)],
							"[[", 1)))
    gradCalc <-
      c(body[first.grad:(length(body) - 2)],
	parse(text = "dimnames(.grad) <- list(NULL, .actualArgs)"),
	body[length(body) - 1])
    mode(gradCalc) <- "{"
    replacement[[2]][[2]] <- gradCalc
    body <- c(body[1:(first.grad - 1)], replacement, body[length(body)])
    value[[length(value)]] <- body
    value
  }
  else {
    out[[1]] <- body
    out
  }
}

deriv.formula <-
  function(expr, namevec, function.arg = NULL, tag = ".expr")
{
  expr <- expr[[length(expr)]]
  NextMethod("deriv")
}

### This file is automatically placed in Outline minor mode.
### The file is structured as follows:
### Chapters:     ^L # 
### Sections:    ##*##
### Subsections: ###*###
### Components:  non-comment lines flushed left
###              Random code beginning with a ####* comment

### Local variables:
### mode: S
### mode: outline-minor
### outline-regexp: "\^L\\|\\`#\\|##\\*\\|###\\*\\|[a-zA-Z]\\|####\\*"
### End:
