## Make sure that as.expression() is generic:

as.expression <- function(x,...) UseMethod("as.expression")
as.expression.default <- function(x)
  .Internal(as.vector(x, "expression"))

## Use a version of as.function.polynomial() which works in R
## (By Thomas Lumley <thomas@biostat.washington.edu>, 1998/04/27)

as.function.polynomial <- function(p) {
  pnom <- make.character(p, style = "h")
  ftext <- paste("function(x, nm = as.character(x)) { val <- ",
                 pnom,
                 "; if(!inherits(val, \"polynomial\"))",
                 "names(val) <- nm; val}",
                 sep = "")
  eval(parse(text = ftext)[[1]])
}

## Provide solve.polynomial(), apparently by BV himself, but for some
## reason not in the version of the pkg on statlib ...

solve.polynomial <- function(a, b, ...) {
  ## intended to solve a(x) = 0 for x (or a(x) = b(x) if b is not
  ## missing).
  if(!missing(b))
    a <- a - b
  a <- unclass(a)
  if(a[1] == 0) {
    z <- rle(a)$lengths[1]
    a <- a[ - (1:z)]
    r <- rep(0, z)
  }
  else r <- numeric(0)
  switch(as.character(length(a)),
	 "0" = ,
	 "1" = r,
	 "2" = sort(c(r,  - a[1]/a[2])),
	 {
	   a <- rev(a)
	   a <- (a/a[1])[-1]
	   M <- rbind( - a, cbind(diag(length(a) - 1), 0))
	   sort(c(r, eigen(M, symmetric = F, only.values = T)$values))
	 })
}
