"codamenu.diags.crosscorr" <-
function () 
{
        next.menu <- "codamenu.diags.crosscorr"
        crosscorr.out <- crosscorr(work.dat, combine.chains = coda.options("combine.corr"))
        if (coda.options("combine.corr") & nchain(work.dat) > 
                1) 
                cat("Pooling over chains:", chanames(work.dat), 
                        sep = "\n", collapse = "\n")
        print(crosscorr.out, digits = coda.options("digits"))
        cat("\nCross Correlation Plots Menu\n")
        cat("****************************\n")
        choices <- c("Change options", "Plot Cross Correlations", 
                "Return to Diagnostics Menu")
        pick <- menu(choices)
        if (pick == 0) 
                next.menu <- "quit"
        else switch(pick, change.tfoption("Combine chains", "combine.corr"), 
                {
                        crosscorr.plot(work.dat, combine.chains = coda.options("combine.corr"))
                        mpause3()
                }, next.menu <- "codamenu.diags")
        return(next.menu)
}
