"gelman.shrink.plot" <-
function (x, confidence = 0.95, transform = F, bin.width, max.bins, 
        auto.layout = T) 
{
        oldpar <- NULL
        if (auto.layout) 
                oldpar <- par(mfrow = set.mfrow(Nchains = nchain(x), 
                        Nparms = nvar(x)))
        oldpar <- c(oldpar, par(set.scale()))
        on.exit(oldpar)
        if (!missing(bin.width)) {
                if (!missing(max.bins)) 
                        nbin <- min(floor((niter(x) - 50)/bin.width), 
                                max.bins)
                else nbin <- floor((niter(x) - 50)/bin.width)
        }
        else {
                if (!missing(max.bins)) 
                        nbin <- max.bins
                else nbin <- min(floor((niter(x) - 50)/10), 50)
        }
        bin <- floor((niter(x) - 50)/nbin)
        shrink <- array(dim = c(nrow = nbin + 1, ncol(x), 2))
        for (i in 1:nbin) {
                shrink[i, , ] <- gelman.diag(x[1:(50 + (i - 1) * 
                        bin), , ])$confshrink
        }
        shrink[nbin + 1, , ] <- gelman.diag(x)$confshrink
        title.scale <- par("cex") * switch(coda.options("ps.plot"), 
                1, 0.85, 0.7)
        scale <- par("cex") * switch(coda.options("ps.plot"), 
                1, 0.8, 0.6)
        all.na <- apply(is.na(shrink[, , 1, drop = F]), 2, all)
        if (any(all.na)) {
                cat("\n******* Error: *******\nCannot compute Gelman & Rubin's diagnostic for any chain \nsegments for variables", 
                        colnames(x)[all.na], "\nThis indicates convergence failure ==> Run chains for more iterations\n")
        }
        else for (j in 1:ncol(x)) {
                ymin <- min(c(1, shrink[, j, ]), na.rm = T)
                ymax <- max(c(1, shrink[, j, ]), na.rm = T)
                ylim <- range(pretty(c(ymin, ymax)))
                time.x <- unclass(time(x))[c(50 + 0:(nbin - 1) * 
                        bin, niter(x))]
                xlim <- range(pretty(time.x))
                plot(time.x, shrink[, j, 1], type = "l", xlab = "Last iteration in segment", 
                        ylab = "Shrink factor", cex = scale, 
                        xlim = xlim, ylim = ylim, axes = F)
                axis(1, at = pretty(c(50, 50 + (1:nbin) * bin) + 
                        i, 3), cex = scale, labels = format(pretty(c(50, 
                        50 + (1:nbin) * bin) + i, 3)))
                par(crt = 90, srt = 90)
                axis(2, at = pretty(c(ymin, ymax), 2), cex = scale, 
                        labels = format(pretty(c(ymin, ymax), 
                                2)))
                par(crt = 0, srt = 0)
                box()
                lines(time.x, shrink[, j, 2], lty = 2, col = "blue")
                abline(h = 1, lty = 4)
                i <- start(x) - 2
                legend(xlim[2], ylim[2], legend = c("median", 
                        paste(50 * (confidence + 1), "%", sep = "")), 
                        lty = c(1, 2), cex = scale * 0.7, bty = "n", 
                        col = c("black", "blue"), xjust = 1, 
                        yjust = 1)
                title(main = colnames(x)[j], cex = title.scale)
                if ((nna <- sum(is.na(shrink[, j, 1])))) {
                        cat("\n******* Warning: *******\nCould not compute Gelman & Rubin's diagnostic for", 
                                nna, "chain segments\n")
                }
                if (j != ncol(x) && mpause2()) 
                        break
        }
}
