"mcmc" <-
function (data = NA, start = 1, end = numeric(0), thin = 1, ts.eps = .Options$ts.eps) 
{
        if (is.vector(data)) {
                ndata <- length(data)
                nvar <- 1
                nchains <- 1
                data <- array(data, c(ndata, nvar, nchains))
        }
        else if (is.matrix(data)) {
                ndata <- nrow(data)
                nvar <- ncol(data)
                nchains <- 1
                data.dimnames <- dimnames(data)
                data <- array(data, c(ndata, nvar, nchains))
                dimnames(data) <- c(data.dimnames, NA)
        }
        else if (is.array(data) && length(dim(data)) == 3) {
                ndata <- dim(data)[1]
                nvar <- dim(data)[2]
                nchains <- dim(data)[3]
        }
        else stop("Can\'t coerce data to mcmc object")
        if (length(start) > 1) 
                stop("Invalid start")
        if (length(end) > 1) 
                stop("Invalid end")
        if (length(thin) != 1) 
                stop("Invalid thin")
        if (missing(end)) 
                end <- start + (ndata - 1) * thin
        else if (missing(start)) 
                start <- end - (ndata - 1) * thin
        if (thin > 1 && abs(thin - round(thin)) < ts.eps) 
                thin <- round(thin)
        nobs <- floor((end - start)/thin + 1.01)
        if (ndata < nobs) 
                stop("Start, end and thin incompatible with data")
        else {
                end <- start + thin * (nobs - 1)
                if (nobs < ndata) 
                        data <- data[1:nobs, , , drop = FALSE]
        }
        attr(data, "tspar") <- c(start, end, thin)
        attr(data, "class") <- "mcmc"
        data
}
