"plot.to.file" <-
function () 
{
        while (T) {
                cat("\nDo you want to save current plots as a postscript file (y/n) ?\n")
                ans <- scan(what = character(), nmax = 1, strip.white = T)
                if (length(ans) > 0) 
                        break
        }
        if (ans == "Y" | ans == "y") {
                while (T) {
                        cat("\nEnter name you want to call this postscript file:\n")
                        ps.name <- scan(what = character(), nmax = 1, 
                                strip.white = T)
                        if (length(ps.name) > 0) 
                                break
                }
                if (!is.null(Version()$language) && Version()$language == 
                        "R") 
                        save.plot(ps.name)
                else {
                        tmp <- switch(coda.options("ps.plot"), 
                                printgraph(method = "postscript", 
                                 file = ps.name, horizontal = T, 
                                 print = F, paper = "a4", width = 9, 
                                 height = 6, maximize = F), printgraph(method = "postscript", 
                                 file = ps.name, horizontal = F, 
                                 print = F, paper = "a4", width = 6, 
                                 height = 9, maximize = F), printgraph(method = "postscript", 
                                 file = ps.name, horizontal = F, 
                                 print = F, paper = "a4", width = 6, 
                                 height = 4, maximize = F))
                        if (is.null(tmp)) {
                                # default option 
                                printgraph(method = "postscript", 
                                 file = ps.name, horizontal = F, 
                                 print = F, paper = "a4", width = 6, 
                                 height = 9, maximize = F)
                        }
                }
        }
}
