"set.scale.windows" <-
function () 
{
        mrows <- par("mfrow")[1]
        mcols <- par("mfrow")[2]
        plot.dim <- mrows + mcols - 1
        if (plot.dim > 7) 
                plot.dim <- 7
        if (mrows >= 6 & mcols < 6) 
                plot.dim <- 8
        if (mrows < 6 & mcols >= 6) 
                plot.dim <- 9
        if (mrows >= 6 & mcols >= 6) 
                plot.dim <- 10
        oma <- c(1, 0, 3.8, 0)
        mgp <- c(1.5, 0.4, 0)
        mar <- c(3.25, 3.5, 1.5, 2)
        cex <- switch(plot.dim, 0.9, 0.8, 0.7, 0.65, 0.6, 0.5, 
                0.425, 0.375, 0.2, 0.2)
        lab <- if (plot.dim < 3 & coda.options("ps.plot") < 3) {
                c(4, 4, 5)
        }
        else {
                if (plot.dim < 6) 
                        c(4, 2, 4)
                else c(3, 2, 3)
        }
        return(oma = oma, mgp = mgp, mar = mar, cex = cex, lab = lab)
}
