\name{densplot}
\title{Probability density function estimate from MCMC output}

\usage{densplot(x, combine.chains = F, bwf)}

\arguments{
\item{x}{An mcmc object}
\item{combine.chains}{By default, separate density estimates
are calculated for each chain in \code{x}. If \code{combine.chains} = T
then information from all chains in \code{x} is combined.}
\item{bwf}{Function for calculating the bandwidth.  If omitted,
the bandwidth is calculate by 1.06 times the minimum of the standard
deviation and the interquartile range divided by 1.34 times the sample
size to the negative one fifth power.
}

\description{
Displays a plot of the density estimate for each variable in \code{x},
calculated by the \code{density} function.
}

\seealso{
\code{\link{density}}, \code{\link{plot.mcmc}}
}
