;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Expand/lambda.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:44:53 1994                          */
;*    Last change :  Tue May  6 10:47:28 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The lambda macro-expansion.                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_lambda
   (import tools_args
	   tools_progn
	   tools_misc
	   expand_eps
	   engine_param)
   (export internal-definition?
	   (expand-lambda                      ::obj ::procedure)
	   (internal-begin-expander::procedure ::procedure)))

;*---------------------------------------------------------------------*/
;*    internal-definition? ...                                         */
;*---------------------------------------------------------------------*/
(define internal-definition? #f)

;*---------------------------------------------------------------------*/
;*    expand-lambda ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-lambda x e)
   (let ((old-internal internal-definition?))
      (set! internal-definition? #t)
      (let ((res (match-case x
		    ((?lam ?args . (and ?body (not ())))
		     (with-lexical (args*->args-list args)
				   '_
				   (lambda ()
				      (let ((e (internal-begin-expander e)))
					 `(,lam ,args
					     ,(e (normalize-progn body) e))))))
		    (else
		     (error #f "Illegal `lambda' form" x)))))
	 (set! internal-definition? old-internal)
	 (replace! x res))))
  
;*---------------------------------------------------------------------*/
;*    internal-begin-expander ...                                      */
;*---------------------------------------------------------------------*/
(define (internal-begin-expander old-expander)
   (lambda (expr expander)
      (let ((res (if (and (pair? expr) (eq? (car expr) 'begin))
		     (if (not (null? (cdr expr)))
			 `(begin ,@(lambda-defines
				    (map (lambda (x) (expander x expander))
					 (cdr expr))))
			 (error #f "Illegal `begin' form" expr))
		     (old-expander expr expander))))
	 (if (pair? res)
	     (replace! expr res)
	     res))))

;*---------------------------------------------------------------------*/
;*    lambda-defines ...                                               */
;*---------------------------------------------------------------------*/
(define (lambda-defines body)
   (let loop ((oldforms  body)
	      (newforms '())
	      (vars     '())
	      (decls    '()))
      (if (pair? oldforms)
	  (let ((form (car oldforms)))
	     (match-case form
		((define ?var ?val)
		 (loop (cdr oldforms)
		       newforms
		       (cons var vars)
		       (cons `(,var ,val)
			     decls)))
		(else
		 (loop (cdr oldforms)
		       (cons form newforms)
		       vars
		       decls))))
	  (cond
	     ((null? newforms)
	      (error #f "Illegal `begin' form" body))
	     ((not (null? vars))
	      `((letrec ,decls
		   ,(normalize-progn (reverse newforms)))))
	     (else
	      body)))))
