;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/User/user.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Dec 29 14:52:11 1994                          */
;*    Last change :  Tue Jul 16 08:28:47 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The entry user point                                             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module user_user
   (include "Engine/pass.sch"
	    "Ast/unit.sch")
   (import  engine_param
	    module_include
	    tools_speek
	    tools_error)
   (export  (user-walk units)))

;*---------------------------------------------------------------------*/
;*    user-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (user-walk units)
   (if (procedure? *user-pass*)
       (let ((unit (get-toplevel-unit)))
	  (pass-prelude *user-pass-name*)
	  (if (procedure? (unit-sexp* unit))
	      ;; a freezed unit (such as the eval
	      ;; unit) cannot be use walked.
	      'nothing
	      (unit-sexp*-set! unit (*user-pass* (unit-sexp* unit))))
	  (pass-postlude 'dummy))
       'done))


