
/*
 * PGP.C	- run pgpverify
 *
 */

#include "defs.h"

Prototype int PGPVerify(Connection *conn, const char *art, int artLen, char **ppgp);

/*
 * PGPVerify()
 *
 * pgpverify < article, if output is non-null it contains the pgp userid
 */

int
PGPVerify(Connection *conn, const char *art, int artLen, char **ppgp)
{
    int r = -1;
    int fds[2];
    pid_t pid;
    char *argv[3] = { PGP_VERIFY_PATH, PGP_VERIFY_ARG0, NULL };

    if ((pid = RunProgramPipe(fds, RPF_STDIN|RPF_STDOUT, argv)) > 0) {
	/*
	 * write article to pgpverify, result answer
	 */
	char buf[256];
	int n;
	int lcr = 0;
	FILE *fo = fdopen(fds[1], "w");

	for (n = 0; n < artLen; ++n) {
	    if (lcr == 0 && art[n] == '\r') {
		lcr = 1;
		continue;
	    }
	    if (art[n] == '\n')
		lcr = 0;
	    if (lcr) {
		fputc('\r', fo);
	    }
	    fputc((int)(uint8)art[n], fo);
	    lcr = 0;
	}
	fflush(fo);
	if (ferror(fo))
	    logit(LOG_ERR, "write error sending article to pgpverify");
	fclose(fo);

	{
	    int v = 0;
	    for (n = 0; n < sizeof(buf); n += v) {
		v = read(fds[0], buf + n, sizeof(buf) - n);
		if (v <= 0)
		    break;
	    }
	    if (n > 0 && buf[n-1] == '\n')
		--n;
	    if (n > 0 && buf[n-1] == '\r')
		--n;
	    if (n == sizeof(buf))
		--n;
	    buf[n] = 0;

	    /*
	     * if non-null answer, pgp-verify succeeded
	     */
	    if (n) {
		r = 1;
		*ppgp = zallocStr(&conn->co_MemPool, buf);
		if (DebugOpt)
		    printf("PGPVERIFY SUCCESS: %s\n", *ppgp);
	    } else {
		if (DebugOpt)
		    printf("PGPVERIFY FAILED\n");
		logit(LOG_INFO, "control message, pgpverify authentication failed");
	    }
	}
	close(fds[0]);
	waitpid(pid, NULL, 0);
    } else {
	logit(LOG_ERR, "Unable to run %s", argv[0]);
    }
    return(r);
}

