/*
 * xep80_fonts.c - XEP80 Font emulation
 *
 * Copyright (C) 2007 Mark Grebe
 *
 * This file is part of the Atari800 emulator project which emulates
 * the Atari 400, 800, 800XL, 130XE, and 5200 8-bit computers.
 *
 * Atari800 is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Atari800 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Atari800; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "config.h"
#ifdef XEP80_EMULATION
#include "atari.h"
#include "xep80_fonts.h"
#include <string.h>

#define NORM_FONT			0
#define REV_FONT            XEP80_FONTS_REV_FONT_BIT
#define UNDER_FONT          XEP80_FONTS_UNDER_FONT_BIT
#define REV_UNDER_FONT      (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_UNDER_FONT_BIT)
#define BLK_FONT            XEP80_FONTS_BLK_FONT_BIT
#define REV_BLK_FONT        (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)
#define UNDER_BLK_FONT      (XEP80_FONTS_UNDER_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)
#define REV_UNDER_BLK_FONT  (XEP80_FONTS_REV_FONT_BIT | XEP80_FONTS_UNDER_FONT_BIT | XEP80_FONTS_BLK_FONT_BIT)

int XEP80_FONTS_inited = FALSE;

UBYTE atari_font[XEP80_FONTS_NUM_FONT_SETS][XEP80_FONTS_CHAR_COUNT][XEP80_CHAR_HEIGHT][XEP80_CHAR_WIDTH] =

{{
{{0,0,0,0,0,0,0,}, /* Character 0 */
 {0,0,0,0,0,0,0,},
 {0,1,1,0,1,1,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,1,1,1,1,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 1 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,1,}, /* Character 2 */
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 },
{{0,0,0,1,0,0,0,}, /* Character 3 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 4 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 5 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,1,}, /* Character 6 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 },
{{1,0,0,0,0,0,0,}, /* Character 7 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 },
{{0,0,0,0,0,0,1,}, /* Character 8 */
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 9 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 },
{{1,0,0,0,0,0,0,}, /* Character 10 */
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,1,1,1,1,}, /* Character 11 */
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,0,0,0,}, /* Character 12 */
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 13 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 14 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 15 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 16 */
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 17 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 18 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 19 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {1,1,1,1,1,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 20 */
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 21 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,0,0,0,0,0,0,}, /* Character 22 */
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 23 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 24 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,0,0,0,}, /* Character 25 */
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,1,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 26 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 27 */
 {0,1,1,1,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 28 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 29 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 30 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 31 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 32 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 33 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 34 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 35 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 36 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 37 */
 {0,1,1,0,0,0,0,},
 {0,1,1,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 38 */
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 39 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 40 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 41 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 42 */
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 43 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 44 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 45 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 46 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 47 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 48 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 49 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 50 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 51 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 52 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 53 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 54 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 55 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 56 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 57 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 58 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 59 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 60 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 61 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 62 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 63 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 64 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 65 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 66 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 67 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 68 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 69 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 70 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 71 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 72 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 73 */
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 74 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 75 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 76 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 77 */
 {0,1,0,0,0,1,0,},
 {0,1,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 78 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 79 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 80 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 81 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 82 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 83 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 84 */
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 85 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 86 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 87 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 88 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 89 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 90 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 91 */
 {0,0,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 92 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 93 */
 {0,1,1,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 94 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 95 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 96 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 97 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 98 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 99 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 100 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 101 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 102 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 103 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 104 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 105 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 106 */
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 107 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 108 */
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 109 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 110 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 111 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 112 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 113 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 114 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 115 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 116 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 117 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 118 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 119 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 120 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 121 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 122 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 123 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,1,0,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 124 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 125 */
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 126 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 127 */
 {0,0,1,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 128 */
 {1,1,1,1,1,1,1,},
 {1,0,0,1,0,0,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,0,0,0,0,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 129 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,0,}, /* Character 130 */
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 },
{{1,1,1,0,1,1,1,}, /* Character 131 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 132 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 133 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,0,}, /* Character 134 */
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 },
{{0,1,1,1,1,1,1,}, /* Character 135 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,0,},
 {1,1,1,1,1,1,0,},
 },
{{1,1,1,1,1,1,0,}, /* Character 136 */
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {1,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 137 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 },
{{0,1,1,1,1,1,1,}, /* Character 138 */
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,0,1,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,0,0,0,0,}, /* Character 139 */
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,1,1,1,}, /* Character 140 */
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 141 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 142 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 143 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 144 */
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 145 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,0,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 146 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 147 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {0,0,0,0,0,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 148 */
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 149 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,1,1,1,1,1,1,}, /* Character 150 */
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 {0,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 151 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 152 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,1,1,1,}, /* Character 153 */
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 {0,0,0,0,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 154 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 155 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 156 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 157 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 158 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 159 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 160 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 161 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 162 */
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 163 */
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 164 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 165 */
 {1,0,0,1,1,1,1,},
 {1,0,0,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,0,0,1,},
 {1,1,1,1,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 166 */
 {1,1,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 167 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 168 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 169 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 170 */
 {1,1,1,0,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 171 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 172 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 173 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 174 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 175 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 176 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 177 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 178 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 179 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 180 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 181 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 182 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 183 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 184 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 185 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 186 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 187 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 188 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 189 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 190 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 191 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 192 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,0,0,1,},
 {1,0,1,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 193 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 194 */
 {1,0,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 195 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 196 */
 {1,0,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 197 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 198 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 199 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 200 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 201 */
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 202 */
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 203 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 204 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 205 */
 {1,0,1,1,1,0,1,},
 {1,0,0,1,0,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 206 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 207 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 208 */
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 209 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 210 */
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 211 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 212 */
 {1,0,0,0,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 213 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 214 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 215 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 216 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 217 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 218 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 219 */
 {1,1,0,0,0,0,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 220 */
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 221 */
 {1,0,0,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 222 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 223 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 224 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 225 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 226 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 227 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 228 */
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 229 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 230 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 231 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 232 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 233 */
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 234 */
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 235 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 236 */
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 237 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,1,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 238 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,0,0,1,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 239 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 240 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 241 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 242 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,0,0,1,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 243 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 244 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 245 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 246 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 247 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 248 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 249 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 250 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 251 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,0,1,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 252 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 253 */
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 254 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 255 */
 {1,1,0,1,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
},
/* Atari Internation Character Set */
{
{{0,0,0,0,0,0,0,}, /* Character 0 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 1 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 2 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 3 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 4 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 5 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 6 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 7 */
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 8 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 9 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 10 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 11 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 12 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 13 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 14 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 15 */
 {0,0,0,0,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 16 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 17 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 18 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 19 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 20 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 21 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 22 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 23 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 24 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 25 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 26 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 27 */
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 28 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 29 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 30 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 31 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 32 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 33 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 34 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 35 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 36 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 37 */
 {0,1,1,0,0,0,0,},
 {0,1,1,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 38 */
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 39 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 40 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 41 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 42 */
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 43 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 44 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 45 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 46 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 47 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 48 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 49 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 50 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 51 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 52 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 53 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 54 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 55 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 56 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 57 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 58 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 59 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 60 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 61 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 62 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 63 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 64 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 65 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 66 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 67 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 68 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 69 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 70 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 71 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 72 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 73 */
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 74 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 75 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 76 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 77 */
 {0,1,0,0,0,1,0,},
 {0,1,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 78 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 79 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 80 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 81 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 82 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 83 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 84 */
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 85 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 86 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 87 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 88 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 89 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 90 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 91 */
 {0,0,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 92 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 93 */
 {0,1,1,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 94 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 95 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 96 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 97 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 98 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 99 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 100 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 101 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 102 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 103 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 104 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 105 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 106 */
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 107 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 108 */
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 109 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 110 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 111 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 112 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 113 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 114 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 115 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 116 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 117 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 118 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 119 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 120 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 121 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 122 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 123 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,1,0,0,0,}, /* Character 124 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 125 */
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 126 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 127 */
 {0,0,1,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 128 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 129 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 130 */
 {1,1,0,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 131 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 132 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 133 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 134 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 135 */
 {1,1,0,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 136 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 137 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 138 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 139 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 140 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 141 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 142 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 143 */
 {1,1,1,1,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 144 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 145 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 146 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 147 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 148 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 149 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 150 */
 {1,1,0,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,0,0,1,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 151 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 152 */
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 153 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 154 */
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 155 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 156 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 157 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 158 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 159 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 160 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 161 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 162 */
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 163 */
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 164 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 165 */
 {1,0,0,1,1,1,1,},
 {1,0,0,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,0,0,1,},
 {1,1,1,1,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 166 */
 {1,1,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 167 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 168 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 169 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 170 */
 {1,1,1,0,1,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 171 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 172 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 173 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 174 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 175 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 176 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 177 */
 {1,1,1,0,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 178 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 179 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 180 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 181 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 182 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 183 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 184 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 185 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 186 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 187 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 188 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 189 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 190 */
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 191 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 192 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,0,0,1,},
 {1,0,1,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 193 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 194 */
 {1,0,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 195 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 196 */
 {1,0,0,0,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,1,0,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 197 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 198 */
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 199 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 200 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 201 */
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 202 */
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 203 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 204 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 205 */
 {1,0,1,1,1,0,1,},
 {1,0,0,1,0,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 206 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 207 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 208 */
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 209 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 210 */
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 211 */
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 212 */
 {1,0,0,0,0,0,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 213 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 214 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 215 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 216 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 217 */
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 218 */
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 219 */
 {1,1,0,0,0,0,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 220 */
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 221 */
 {1,0,0,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 222 */
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 223 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 224 */
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 225 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 226 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 227 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 228 */
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 229 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 230 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 231 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 232 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 233 */
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 234 */
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,0,1,1,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 235 */
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,0,1,1,1,1,},
 {1,0,1,0,1,1,1,},
 {1,0,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 236 */
 {1,1,0,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 237 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,1,0,1,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 238 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,0,0,1,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 239 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 240 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 241 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 242 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,0,0,1,1,},
 {1,0,0,1,1,0,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 243 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,1,},
 {1,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 244 */
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 245 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,0,0,1,},
 {1,1,0,0,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 246 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 247 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,0,1,0,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 248 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 249 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,0,0,0,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 250 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,0,0,0,0,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 251 */
 {1,1,0,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,0,0,0,0,0,1,},
 {1,0,1,1,1,0,1,},
 {1,0,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,0,1,1,1,}, /* Character 252 */
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 {1,1,1,0,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 253 */
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,1,0,1,1,},
 {1,1,0,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,0,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 254 */
 {1,1,1,1,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,0,0,1,1,},
 {1,1,1,1,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 255 */
 {1,1,0,1,1,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,1,1,1,},
 {1,1,0,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
},

/* Internal Character Set */
{
{{0,0,0,0,0,0,0,}, /* Character 0 */
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 1 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 2 */
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 3 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 4 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 5 */
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 6 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 7 */
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 8 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 9 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 10 */
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,1,1,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 11 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 12 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 13 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 14 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 15 */
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 16 */
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,1,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 17 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 18 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 19 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 20 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 21 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 22 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 23 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 24 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 25 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 26 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 27 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 28 */
 {0,0,0,0,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 29 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 10 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 31 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 32 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 33 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 34 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 35 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 36 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 37 */
 {0,1,1,0,0,0,0,},
 {0,1,1,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 38 */
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 39 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 40 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 41 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 42 */
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 43 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 44 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 45 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 46 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 47 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 48 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 49 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 50 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 51 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 52 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 53 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 54 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 55 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 56 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 57 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 58 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 59 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 60 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 61 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 62 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 63 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 64 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 65 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 66 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 67 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 68 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 69 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 70 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 71 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 72 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 73 */
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 74 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 75 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 76 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 77 */
 {0,1,0,0,0,1,0,},
 {0,1,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 78 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 79 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 80 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 81 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 82 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 83 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 84 */
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 85 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 86 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 87 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 88 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 89 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 90 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 91 */
 {0,0,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 92 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 93 */
 {0,1,1,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 94 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 95 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 96 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 97 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 98 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 99 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 100 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 101 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 102 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 103 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 104 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 105 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 106 */
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 107 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 108 */
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 109 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 110 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 111 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 112 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 113 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 114 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 115 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 116 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 117 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 118 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 119 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 120 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 121 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 122 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 123 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 124 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 125 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 126 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 127 */
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 0 */
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 1 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 2 */
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 3 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 4 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 5 */
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 6 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 7 */
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 8 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 9 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 10 */
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,1,1,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 11 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 12 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 13 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 14 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 15 */
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 16 */
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,1,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 17 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 18 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 19 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 20 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 21 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 22 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 23 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 24 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 25 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 26 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 27 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 28 */
 {0,0,0,0,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 29 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 10 */
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 31 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 32 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 33 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 34 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 35 */
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 36 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 37 */
 {0,1,1,0,0,0,0,},
 {0,1,1,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 38 */
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 39 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 40 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 41 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 42 */
 {0,0,0,1,0,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 43 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 44 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 45 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 46 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 47 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 48 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 49 */
 {0,0,0,1,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 50 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 51 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 52 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 53 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 54 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 55 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 56 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 57 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 58 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 59 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 60 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 61 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 62 */
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 63 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 64 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,1,1,0,},
 {0,1,0,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 65 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 66 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 67 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 68 */
 {0,1,1,1,1,0,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,0,1,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 69 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 70 */
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 71 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 72 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 73 */
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 74 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 75 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 76 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 77 */
 {0,1,0,0,0,1,0,},
 {0,1,1,0,1,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 78 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 79 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 80 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 81 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 82 */
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 83 */
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 84 */
 {0,1,1,1,1,1,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 85 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 86 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 87 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 88 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 89 */
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 90 */
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 91 */
 {0,0,1,1,1,1,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 92 */
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 93 */
 {0,1,1,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 94 */
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 95 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 96 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 97 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 98 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 99 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 100 */
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 101 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 102 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 103 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 104 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 105 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 106 */
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,1,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 107 */
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,1,0,0,0,0,},
 {0,1,0,1,0,0,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 108 */
 {0,0,1,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 109 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 110 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 111 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 112 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 113 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 114 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,1,1,0,0,},
 {0,1,1,0,0,1,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 115 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,0,},
 {0,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 116 */
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 117 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,1,1,0,},
 {0,0,1,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 118 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 119 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 120 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,0,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 121 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,1,0,0,0,1,0,},
 {0,0,1,1,1,1,0,},
 {0,0,0,0,0,1,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 122 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,1,1,1,1,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 123 */
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,1,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 124 */
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 125 */
 {0,0,0,1,0,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,0,1,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,0,1,0,0,},
 {0,0,0,1,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 126 */
 {0,0,1,1,0,1,0,},
 {0,1,0,0,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 127 */
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,1,0,1,0,0,},
 {0,1,0,1,0,1,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
}
};

UBYTE block_font[XEP80_FONTS_CHAR_COUNT/2][XEP80_CHAR_HEIGHT][XEP80_CHAR_WIDTH] =
{
{{0,0,0,0,0,0,0,}, /* Character 0 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 1 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 2 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 3 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 4 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 5 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 6 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 7 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 8 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 9 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 10 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 11 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 12 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 13 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 14 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 15 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 16 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 17 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 18 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 19 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 20 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 21 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 22 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 23 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 24 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 25 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 26 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 27 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 28 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 29 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 30 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 31 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 32 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 33 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 34 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 35 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 36 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 37 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 38 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 39 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 40 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 41 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 42 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 43 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 44 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 45 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 46 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 47 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 48 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 49 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 50 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 51 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 52 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 53 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 54 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 55 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 56 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 57 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 58 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 59 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 60 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 61 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 62 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 63 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 64 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 65 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 66 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 67 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 68 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 69 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 70 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 71 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 72 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 73 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 74 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 75 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 76 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 77 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 78 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 79 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 80 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 81 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 82 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 83 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 84 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 85 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 86 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 87 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 88 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 89 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 90 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 91 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 92 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,0,0,0,1,1,}, /* Character 93 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,1,1,1,0,0,}, /* Character 94 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{1,1,1,1,1,1,1,}, /* Character 95 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 },
{{0,0,0,0,0,0,0,}, /* Character 96 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 97 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 98 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 99 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 100 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 101 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 102 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 103 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 104 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 105 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 106 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 107 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 108 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 109 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 110 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 111 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 112 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 113 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 114 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 115 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {0,0,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 116 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 117 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 118 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 119 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 120 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 121 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 122 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 123 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {0,0,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,0,0,0,0,0,}, /* Character 124 */
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {0,0,0,0,0,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,0,0,0,1,1,}, /* Character 125 */
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,0,0,0,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{0,0,1,1,1,0,0,}, /* Character 126 */
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {0,0,1,1,1,0,0,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 },
{{1,1,1,1,1,1,1,}, /* Character 127 */
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 {1,1,1,1,1,1,1,},
 }
};


UBYTE XEP80_FONTS_atari_fonts[XEP80_FONTS_NUM_FONT_SETS][XEP80_FONTS_NUM_FONTS][XEP80_FONTS_CHAR_COUNT][XEP80_CHAR_HEIGHT][XEP80_CHAR_WIDTH];

UBYTE XEP80_FONTS_oncolor = 15;
UBYTE XEP80_FONTS_offcolor = 0;

void XEP80_FONTS_InitFonts(void)
{
	int char_no, char_row, char_col, font_set;

    /* Normal Fonts */
    for (font_set=0;font_set<XEP80_FONTS_NUM_FONT_SETS;font_set++) {
        for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT;char_no++) {
            for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
                for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                    if (atari_font[font_set][char_no][char_row][char_col]) {
                        XEP80_FONTS_atari_fonts[font_set][NORM_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[font_set][NORM_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                }
            }
        }
    }
    /* Inverse Fonts */
    for (font_set=0;font_set<XEP80_FONTS_NUM_FONT_SETS;font_set++) {
        for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT;char_no++) {
            for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
                for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                    if (atari_font[font_set][char_no][char_row][char_col]) {
                        XEP80_FONTS_atari_fonts[font_set][REV_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[font_set][REV_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                }
            }
        }
    }
    /* Normal Underline Fonts */
    for (font_set=0;font_set<XEP80_FONTS_NUM_FONT_SETS;font_set++) {
        for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT;char_no++) {
            for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
                for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                    if (char_row != XEP80_FONTS_UNDER_ROW) {
                        if (atari_font[font_set][char_no][char_row][char_col]) {
                            XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                        }
                        else {
                            XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                        }
                    }
                    else {
                        if (char_no<128) {
                            XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                        }
                        else {
                            XEP80_FONTS_atari_fonts[font_set][UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                        }
                    }
                }
            }
        }
    }
    /* Rev Underline Fonts */
    for (font_set=0;font_set<XEP80_FONTS_NUM_FONT_SETS;font_set++) {
        for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT;char_no++) {
            for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
                for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                    if (char_row != XEP80_FONTS_UNDER_ROW) {
                        if (atari_font[font_set][char_no][char_row][char_col]) {
                            XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                        }
                        else {
                            XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                        }
                    }
                    else {
                        if (char_no<128) {
                            XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                        }
                        else {
                            XEP80_FONTS_atari_fonts[font_set][REV_UNDER_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                        }
                    }
                }
            }
        }
    }
    /* Block Fonts */
    for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT/2;char_no++) {
        for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
            for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                if (block_font[char_no][char_row][char_col]) {
                    XEP80_FONTS_atari_fonts[0][BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                }
                else {
                    XEP80_FONTS_atari_fonts[0][BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                }
            }
        }
    }
    memcpy(XEP80_FONTS_atari_fonts[0][BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][BLK_FONT][0],
           XEP80_FONTS_CHAR_COUNT/2*XEP80_CHAR_HEIGHT*XEP80_CHAR_WIDTH); 
    /* Inverse Block Fonts */
    for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT/2;char_no++) {
        for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
            for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                if (block_font[char_no][char_row][char_col]) {
                    XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                }
                else {
                    XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                }
            }
        }
    }
    memcpy(XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][REV_BLK_FONT][0],
          XEP80_FONTS_CHAR_COUNT/2*XEP80_CHAR_HEIGHT*XEP80_CHAR_WIDTH); 
    /* Normal Underline Block Fonts */
    for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT/2;char_no++) {
        for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
            for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                if (char_row != XEP80_FONTS_UNDER_ROW) {
                    if (block_font[char_no][char_row][char_col]) {
                        XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                }
                else {
                    if (char_no<128) {
                        XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                }
            }
        }
    }
    memcpy(XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][UNDER_BLK_FONT][0],
          XEP80_FONTS_CHAR_COUNT/2*XEP80_CHAR_HEIGHT*XEP80_CHAR_WIDTH); 
    /* Rev Underline Block Fonts */
    for (char_no = 0;char_no<XEP80_FONTS_CHAR_COUNT/2;char_no++) {
        for (char_row=0;char_row<XEP80_CHAR_HEIGHT;char_row++) {
            for (char_col=0;char_col<XEP80_CHAR_WIDTH;char_col++) {
                if (char_row != XEP80_FONTS_UNDER_ROW) {
                    if (block_font[char_no][char_row][char_col]) {
                        XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                }
                else {
                    if (char_no<128) {
                        XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_offcolor;
                    }
                    else {
                        XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][char_no][char_row][char_col] = XEP80_FONTS_oncolor;
                    }
                }
            }
        }
    }
    memcpy(XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][XEP80_FONTS_CHAR_COUNT/2], XEP80_FONTS_atari_fonts[0][REV_UNDER_BLK_FONT][0],
          XEP80_FONTS_CHAR_COUNT/2*XEP80_CHAR_HEIGHT*XEP80_CHAR_WIDTH); 
    /* Copy Block fonts to international fonts */
    memcpy(XEP80_FONTS_atari_fonts[1][4], XEP80_FONTS_atari_fonts[0][4],
           4*XEP80_FONTS_CHAR_COUNT*XEP80_CHAR_HEIGHT*XEP80_CHAR_WIDTH); 

    XEP80_FONTS_inited = TRUE;
}
#endif /* XEP80 */

