/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"
static void AYSound(void);
static void AYSynco(int32 ts);
static void DoAYSQ(int x);

static uint8 sunindex;
static uint8 MapperExRAM[16];

static DECLFW(Mapper69_SWL)
{
  sunindex=V&15;
}
static DECLFW(Mapper69_SWH)
{
             GameExpSound.HiFill=AYSound;
	     GameExpSound.HiSync=AYSynco;
             switch(sunindex)
             {
              case 0:
              case 1:
              case 8:DoAYSQ(0);break;
              case 2:
              case 3:
              case 9:DoAYSQ(1);break;
              case 4:
              case 5:
              case 10:DoAYSQ(2);break;
              case 7:
                     DoAYSQ(0);
                     DoAYSQ(1);
                     DoAYSQ(2);break;
             }
             MapperExRAM[sunindex]=V; 
}

static int32 CVBC[4]={0,0,0,0};
static int32 dcount[3]={0,0,0};
static int32 vcount[4]={0,0,0,0};

static void DoAYSQ(int x)
{
 int32 V;
 int32 freq=((MapperExRAM[x<<1]|((MapperExRAM[(x<<1)+1]&15)<<8))+1)<<3;
 int32 amp=(MapperExRAM[0x8+x]&15)<<7;

 if(!(MapperExRAM[0x7]&(1<<x)) && !(FSettings.disabled&(0x20<<x)))
 {
  for(V=CVBC[x];V<timestamp;V++)
  {
   if(dcount[x])
    WaveHi[V]+=amp;
   vcount[x]--;
   if(vcount[x]<=0)
   {
    dcount[x]^=1;
    vcount[x]=freq;
   }
  }
 }
 CVBC[x]=timestamp; 
}

static void AYSound(void)
{
    DoAYSQ(0);
    DoAYSQ(1);
    DoAYSQ(2);
}

static void AYSynco(int32 ts)
{
 int x;
 for(x=0;x<4;x++)
  CVBC[x]=ts;
}

static void M69SC(void)
{
 Mapper69_ESI();
}

void Mapper69_ESI(void)
{
 GameExpSound.RChange=M69SC; 
 SetWriteHandler(0xc000,0xdfff,Mapper69_SWL);
 SetWriteHandler(0xe000,0xffff,Mapper69_SWH);
}
