/*  Festalon - NSF Player
 *  Copyright (C) 2002 Ben Parnell
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "common.h"

void MMC5Sound(void);
static void Do5SQ(int P);
static int32 CVBC[3]={0,0,0};
static int32 dcount[2];
static int32 vcount[2];

static uint8 ExRAM[0x400];

static DECLFW(MMC5_ExRAMWr)
{
 ExRAM[A&0x3FF]=V;
}

static DECLFR(MMC5_ExRAMRd)
{
  return(ExRAM[A&0x3ff]);
}

static uint8 MMC5PSG[0x16];
static void Do5PCM(void)
{
   int32 V;
   if(!(MMC5PSG[0x10]&0x40) && MMC5PSG[0x11] && !(FSettings.disabled&0x80))
    for(V=CVBC[2];V<timestamp;V++)
     WaveHi[V]+=MMC5PSG[0x11]<<6;
   CVBC[2]=timestamp;
}

static void MMC5SSync(int32 ts)
{
 int x;
 for(x=0;x<3;x++) CVBC[x]=ts;
}

static DECLFW(Mapper5_SW)
{
 if(!GameExpSound.HiFill)
 {
  GameExpSound.HiFill=MMC5Sound;
  GameExpSound.HiSync=MMC5SSync;
  MMC5SSync(timestamp);
 }
 A&=0x1F;

 switch(A)
 {
  case 0x10:
  case 0x11:Do5PCM();break;

  case 0x0:Do5SQ(0);break;
  case 0x2:Do5SQ(0);break;
  case 0x3:Do5SQ(0);break;
  case 0x4:Do5SQ(1);break;
  case 0x6:Do5SQ(1);break;
  case 0x7:Do5SQ(1);break;
  case 0x15:
	  {
	   int t=V^MMC5PSG[0x15];
           if(t&1)
            Do5SQ(0);
           if(t&2)
            Do5SQ(1);
	  }
          break;
 }
 MMC5PSG[A]=V;
}

static void Do5SQ(int P)
{
 static int tal[4]={2,4,8,12};
 int32 V,amp,rthresh,wl;

 wl=(MMC5PSG[(P<<2)+0x2]|((MMC5PSG[(P<<2)+0x3]&7)<<8))+1;
 amp=(MMC5PSG[P<<2]&15)<<8;
 rthresh=tal[(MMC5PSG[(P<<2)]&0xC0)>>6];

 if(wl>=8 && (MMC5PSG[0x15]&(P+1)) && !(FSettings.disabled&(0x20<<P)))
 {
  int dc,vc;

  dc=dcount[P];
  vc=vcount[P];
  for(V=CVBC[P];V<timestamp;V++)
  {
    if(dc<rthresh)
     WaveHi[V]+=amp;
    vc--;
    if(vc<=0)	/* Less than zero when first started. */
    {
     vc=wl;
     dc=(dc+1)&15;
    }
  }
  dcount[P]=dc;
  vcount[P]=vc;
 }
 CVBC[P]=timestamp;
}

void MMC5Sound(void)
{
  Do5SQ(0);
  Do5SQ(1);
  Do5PCM();
}

static void MMC5SoundC(void)
{
 if(FSettings.SndRate)
  Mapper5_ESI();
 else
  SetWriteHandler(0x5000,0x5015,0); 
}
static uint8 mul1,mul2;
static DECLFW(Mapper5_write)
{
 switch(A)
  {
   case 0x5205:mul1=V;break;
   case 0x5206:mul2=V;break;
  }
}

static DECLFR(MMC5_read)
{
 switch(A)
 {
  default:
  case 0x5205:return (mul1*mul2);
  case 0x5206:return ((mul1*mul2)>>8);
 }
}

void Mapper5_ESI(void)
{
 GameExpSound.RChange=MMC5SoundC;

 SetWriteHandler(0x5000,0x5015,Mapper5_SW);
 SetWriteHandler(0x5205,0x5206,Mapper5_write);
 SetReadHandler(0x5205,0x5206,MMC5_read);
 SetWriteHandler(0x5c00,0x5fef,MMC5_ExRAMWr);
 SetReadHandler(0x5c00,0x5fef,MMC5_ExRAMRd);
}

