/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * This file is part of J11.                                       *
 * See the file "J11-LICENSE" for Copyright information and the    *
 * terms and conditions for copying, distribution and              *
 * modification of J11.                                            *
 *                                                                 *
 * Copied verbatim from the SableCC grammars Java 1.1 sample,      *
 * licensed under the Library General Public License.              *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

package com.bluemarsh.jswat.parser;


import com.bluemarsh.jswat.parser.unicodepreprocessor.lexer.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.node.*;
import com.bluemarsh.jswat.parser.unicodepreprocessor.analysis.*;
import java.io.*;

public class UnicodeLexer extends Lexer
{
    private PushbackReader in;

    public UnicodeLexer(PushbackReader in)
    {
        super(in);
        this.in = in;
    }

    private Token buffer;

    protected void filter()
    {
        if(state.equals(State.SUB))
        {
            if(buffer == null)
            {
                buffer = token;
                token = null;
            }
            else
            {
                if(token instanceof EOF)
                {
                    buffer = null;
                    state = State.NORMAL;
                }
                else
                {
                    try
                    {
                        // Unread the last token text.
                        in.unread(token.getText().toCharArray());
                    }
                    catch(IOException e)
                    {
                        throw new RuntimeException("Error while unreading: " + e);
                    }

                    token = buffer;
                    buffer = null;
                    state = State.NORMAL;
                }
            }
        }
        else
        {
            if(token instanceof TUnicodeEscape)
            {
                String text = token.getText();

                // Is it SUB?
                if(text.substring(text.length() - 4).equalsIgnoreCase("001a"))
                {
                    buffer = token;
                    token = null;
                    state = State.SUB;
                }
            }
        }
    }
}
