#ifdef I18N

#include <stdio.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xlocale.h>
#include "config.h"
#include "lyxim.h"
#include "LyXView.h"
#include "minibuffer.h"
#include "BufferView.h"
#include "FontLoader.h"
#include "debug.h"
#include "lyxtext.h"
#include "lyxscreen.h"
#include "WorkArea.h"
#include "BufferView_pimpl.h"

#define DUMMY_FONT_NAME       "-*-*-*-R-Normal--14-130-75-75-*-*"

//extern FD_form_main *fd_form_main;
extern MiniBuffer *minibuffer;
extern BufferView *current_view;
//extern  WorkArea *  wk;
extern FontLoader fontloader;

LyXIM lyxim;     //global
static XFontSet                fontset,statusfont;

void LyXIM::SetStatusArea()
{
   
    status_rect.x = current_view->owner()->getMiniBuffer()->the_buffer->x + (current_view->owner()->getMiniBuffer()->the_buffer->w * 4/5);
    status_rect.y = current_view->owner()->getMiniBuffer()->the_buffer->y +2;
    status_rect.width = current_view->owner()->getMiniBuffer()->the_buffer->w * 1/5 -2;
    status_rect.height = current_view->owner()->getMiniBuffer()->the_buffer->h -4;
   //  printf("status.x=%d, status.y=%d, status.width=%d, status.height=%d\n",
      //        status_rect.x, status_rect.y, status_rect.width, status_rect.height);
}
void LyXIM::SetPreeditArea()
{
    int left,right;      //margin

    left = current_view->text->LeftMargin(current_view,current_view->text->cursor.row());
    right = current_view->text->RightMargin(current_view->buffer(),current_view->text->cursor.row());
    
    input_rect.x = current_view->workarea()->xpos() + left;
    input_rect.y = current_view->workarea()->ypos();
    input_rect.width =  current_view->workarea()->workWidth() - left - right;
    input_rect.height = current_view->workarea()->height();
   // printf("edit.x=%d, edit.y=%d, edit.width=%d, edit.height=%d\n",
    //          input_rect.x, input_rect.y, input_rect.width, input_rect.height);
}

/*void LyXIM::IMDestroy(XIM xim, XPointer client_data, XPointer call_data)
{
    xic = NULL;
    XRegisterIMInstantiateCallback(fl_display, NULL, NULL, NULL, LyXIM::IMCreate, NULL);
}
*/
/*void LyXIM::SetRegister()
{
    XRegisterIMInstantiateCallback(fl_display, NULL, NULL, NULL,
					   LyXIM::IMCreate, NULL);
}
*/
void LyXIM::IMCreate(Window window)
{

    char                    **missing_list;
    int                     missing_count;
    char                    *def_string;
    XPoint                  spot;
    unsigned long           fevent;
    XVaNestedList           status_attr,preedit_attr;
    XIMCallback     ximcallback;

    
    xic = NULL;
    setlocale(LC_ALL,"");
    if (!XSupportsLocale()) {
            //    lyxerr.print("IMCreate: X does not support this locale.");
        return;
    } 
    if (!XSetLocaleModifiers("")) {
            //       lyxerr.print("IMCreate: Could not set modifiers "
            //            "for this locale.");
        return;
    }

//    ximcallback.callback = IMDestroy;
//    ximcallback.client_data = NULL;

    
    xim = XOpenIM (fl_display, NULL, NULL, NULL);

//     XSetIMValues(xim, XNDestroyCallback, &ximcallback, NULL);

    if (!xim) {
            //     lyxerr.print("IMCreate: could not open "
            //                 "an input method.");
        return;
    }
    
    {        // xim_style set
        XIMStyle preedit[]={XIMPreeditPosition,XIMPreeditNothing,NULL};
        XIMStyle status[]={XIMStatusArea,XIMStatusNothing,NULL};
        XIMStyles      *xim_styles = NULL;

        if (XGetIMValues(xim, XNQueryInputStyle, &xim_styles, NULL) || !xim_styles) {
            lyxerr << "IMCreate:input method doesn't support any style" << endl;
            XCloseIM(xim);
            return;
        }
        int i=0;
        int found=0;
        while ((preedit[i]!=0)&& (found != 1))
        {
            int j = 0;
            while((status[j]!=0)&& (found != 1))
            {
                for (int k=0;k < xim_styles->count_styles;k++)
                {
                    if ((preedit[i] | status[j])==xim_styles->supported_styles[k])
                    {
                        input_style=xim_styles->supported_styles[k];
                        found = 1;
                        break;
                    }
                }
                j++;
            }
            i++;
        }
    }
    
                
    fontset = XCreateFontSet(fl_display, DUMMY_FONT_NAME, &missing_list,
                             &missing_count, &def_string);
    statusfont = XCreateFontSet(fl_display, DUMMY_FONT_NAME, &missing_list,
                             &missing_count, &def_string);
    if (fontset == NULL)
        {
                lyxerr << "IMCreate: create dummy fontset !" << endl;
            return;
        }
    
    
    spot.x  =       current_view->workarea()->xpos() + 42;   //dummy
    spot.y  =       current_view->workarea()->ypos() + 40;

    input_rect.x =     current_view->workarea()->xpos();    //dummy
    input_rect.y =      current_view->workarea()->ypos();
    input_rect.width =  current_view->workarea()->workWidth() - 20;
    input_rect.height = current_view->workarea()->height();
    
    preedit_attr = XVaCreateNestedList(NULL,
                                       XNSpotLocation, &spot,
                                       XNFontSet, fontset,
                                           //XNBackground,fl_get_pixel(FL_WHITE),
                                           //XNBackgroundPixmap,current_view->getScreen()->getForeground(),
                                       XNForeground,BlackPixel(fl_display,DefaultScreen(fl_display)),  //for skkinput?
                                       XNBackground,WhitePixel(fl_display, DefaultScreen(fl_display)),
                                       XNArea,&input_rect,
                                       NULL);

        
    
    SetStatusArea();
    status_attr = XVaCreateNestedList(NULL,
                                      XNArea, &status_rect,
                                      XNFontSet, statusfont,      //no effect
                                      XNBackground,fl_get_pixel(FL_MCOL), //no effect
                                      NULL);

    xic = XCreateIC(xim, 
                   XNInputStyle, input_style,
                    XNClientWindow, window,
                   XNPreeditAttributes, preedit_attr,
                   XNStatusAttributes, status_attr,
                    XNDestroyCallback, &ximcallback,
                   NULL);

    XFree(preedit_attr);
    XFree(status_attr);


    if (!xic) {
        lyxerr << "IMCreate: could not create "
                     "an input context" << endl;
        XCloseIM (xim);
        xim = NULL;
        return;
    } 
    XGetICValues(xic, XNFilterEvents, &fevent, NULL);
    
}

void LyXIM::SpotandFont()
{
    
        preeditspot.x  =  current_view->text->cursor.x() + current_view->workarea()->xpos();
        preeditspot.y  = current_view->text->cursor.y() + current_view->workarea()->ypos()
            - current_view->text->first;

        current_font = current_view->text->real_current_font;
        current_fontset= fontloader.load(current_font.family(),current_font.series(),
                                                current_font.shape(),current_font.size());
}

void LyXIM::SetIMSpot()
{

    XVaNestedList           preedit_attr;
    
    
    if (xic && current_view->available() ) {
        
        SpotandFont();
        SetPreeditArea();
        
        preedit_attr = XVaCreateNestedList(NULL,
                                           XNSpotLocation, &preeditspot,
                                           XNFontSet,current_fontset,
                                           XNArea,&input_rect,
                                           XNBackgroundPixmap,current_view->color()->foreground,
                                           NULL);
        
        XSetICValues(xic,
                     XNPreeditAttributes,preedit_attr,
                     NULL);
        XFree(preedit_attr);
    }
}



void LyXIM::SetIMSpotAndArea()
{
    XVaNestedList           status_attr;
    if (xic && current_view->available() ) {
        SetIMSpot();
        SetStatusArea();
        status_attr = XVaCreateNestedList(NULL,
                                          XNArea, &status_rect,
                                          XNFontSet, statusfont,
                                          XNForeground,fl_get_pixel(FL_MCOL),
                                          NULL);
        XSetICValues(xic,
                     XNStatusAttributes, status_attr,
                     NULL);
        XFree(status_attr);
    }
}

/* $XConsortium: NextEvent.c,v 11.19 94/04/17 20:20:19 kaleb Exp $ */
/*

Copyright (c) 1986  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.

*/

#define NEED_EVENTS
extern "C" {
#include <X11/Xlibint.h>
}

/*
 * Return next event in queue, or if none, flush output and wait for
 * events.
 */

extern "C" int
XNextEvent (register Display *dpy, register XEvent *event)
{
	register _XQEvent *qelt;
	
	LockDisplay(dpy);
	
	if (dpy->head == NULL)
	    _XReadEvents(dpy);
	qelt = dpy->head;
	*event = qelt->event;
	_XDeq(dpy, NULL, qelt);
	UnlockDisplay(dpy);
	if (event->type == ClientMessage && XFilterEvent(event, None)) return XNextEvent(dpy, event);
	return NULL;
}


#endif

