(in-package "ACL2")

(include-book "floor")
(local (include-book "rationalp"))

;better conclusion?
(defthm fl-mod-0
    (implies (case-split (acl2-numberp m))
	     (iff (= (mod m n) 0)
		  (= m (* (fl (/ m n)) n))))
  :rule-classes ()
  :hints (("goal" :use (mod-fl))))

;work more?
(defthm fl-mod-1
    (implies (and (acl2-numberp m) (rationalp m)
                  (rationalp n)
                  (> n 0)
                  )
	     (<= (* (fl (/ m n)) n) m))
  :rule-classes ()
  :hints (("goal" :use (mod-fl mod>=0))))

(local
(defthm fl-mod-2
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (= (* (fl (/ m (* n p)))
		   (* n p))
		(* (* (fl (/ (fl (/ m n)) p))
		      p)
		   n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance fl/int-rewrite (x (/ m n)) (n p)))))))

(local
(defthm fl-mod-3
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (<= (* (fl (/ m (* n p)))
		    (* n p))
		 (* (fl (/ m n)) n)))
  :rule-classes ()
  :hints (("goal" :use (fl-mod-2
			(:instance fl-mod-1 (m (fl (/ m n))) (n p)))))))

(local
(defthm fl-mod-4
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (iff (= (* (fl (/ m (* n p)))
			(* n p))
		     m)
		  (and (= (* (fl (/ (fl (/ m n)) p)) p)
			  (fl (/ m n)))
		       (= (* (fl (/ m n)) n)
			  m))))
  :rule-classes ()
  :hints (("goal" :use (fl-mod-2 fl-mod-3 fl-mod-1)))))

(defthm fl-mod-5
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp p) (> p 0))
	     (iff (= (mod m (* n p)) 0)
		  (and (= (mod m n) 0)
		       (= (mod (fl (/ m n)) p) 0))))
  :rule-classes ()
  :hints (("goal" :use (fl-mod-4 
			fl-mod-0
			(:instance fl-mod-0 (n (* n p)))
			(:instance fl-mod-0 (m (fl (/ m n))) (n p))))))


(local (defthm hack6
    (implies (and (rationalp a)
		  (rationalp b)
		  (rationalp c)
		  (rationalp ap)
		  (rationalp k)
		  (= (+ a b) c)
		  (= (+ ap (* k b)) (* k c)))
	     (= ap (* k a)))
    :rule-classes ()))

(defthm mod**
    (implies (and (integerp m)
		  (>= m 0)
		  (integerp n)
		  (> n 0)
                  (integerp (* n k)) ;new
                  (integerp (* m k)) ;new
                  (rationalp k) ;new
		;  (integerp k) ;removed
		  (> k 0))
	     (= (mod (* k m) (* k n))
		(* k (mod m n))))
  :rule-classes ()
  :hints (("goal"
           :use (mod-fl
                 (:instance hack6 
                            (a (mod m n)) (b (* n (fl (/ m n)))) (c m) (ap (mod (* k m) (* k n))))
                 (:instance mod-fl (m (* k m)) (n (* k n)))))))
(local
 (defthm mod-mod-1
   (implies (and (integerp x)
                 (>= x 0)
                 (integerp b)
                 (> b 0)
                 (integerp a)
                 (>= a b))
            (>= (* (FL (* X (/ (EXPT 2 A))))
                   (EXPT 2 (+ A (* -1 B))))
                0))
   :rule-classes ()
   :hints (("Goal" :in-theory (disable )
            :use (
                  (:instance n<=fl-linear (n 0) (x (* X (/ (EXPT 2 A))))))))))

(defthm MOD-MOD
  (implies (and (integerp x)
                (>= x 0)
                (integerp b)
                (> b 0)
                (integerp a)
                (>= a b))
           (= (mod x (expt 2 b))
              (mod (mod x (expt 2 a)) (expt 2 b))))
  :rule-classes ()
  :hints (("Goal" :in-theory (disable expt-2-integerp)
           :use ((:instance mod-fl (m x) (n (expt 2 a)))
			(:instance expo+ (m b) (n (- a b)))
			(:instance mod-mod-1)
			(:instance mod>=0 (m x) (n (expt 2 a)))
			(:instance expt-2-integerp (i (- a b)))			
			(:instance mod+-thm 
				   (m (mod x (expt 2 a)))
				   (n (expt 2 b)) 
				   (a (* (expt 2 (- a b)) (fl (/ x (expt 2 a))))))))))


(local-defthm mod-minus-mod-1
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (- a (mod b n))
		(+ (- a b) (* n (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-fl (m b))))))

(local-defthm hack16
    (implies (= x y)
	     (= (mod x n) (mod y n)))
  :rule-classes ())

(local-defthm mod-minus-mod-2
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (mod (- a (mod b n)) n)
		(mod (+ (- a b) (* n (fl (/ b n)))) n)))
  :rule-classes ()
  :hints (("goal" :use (mod-minus-mod-1
			(:instance hack16 (x (- a (mod b n))) (y (+ (- a b) (* n (fl (/ b n))))))))))

(defthm mod-minus-mod
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a b)
		  (>= b 0)
		  (> n 0))
	     (= (mod (- a (mod b n)) n)
		(mod (- a b) n)))
  :rule-classes ()
  :hints (("goal" :use (mod-minus-mod-2
			(:instance mod+-thm (m (- a b)) (a (fl (/ b n))))))))

(defthm MOD012
  (implies (and (integerp x)
                (>= x 0))
           (or (= (mod x 2) 0)
               (= (mod x 2) 1)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod<n (m x) (n 2))
			(:instance mod>=0 (m x) (n 2))))))


(defthm bit+-3
  (implies (and (integerp x) (> x 0))
           (>= (* x 2) 2))
  :rule-classes ())

;not needed past bits
(defthm bit+-4
   (implies (integerp x)
            (not (= (* x 2) 1)))
   :rule-classes ()
   :hints (("Goal" :use ((:instance bit+-3)
                         (:instance bit+-3 (x (- x)))))))

(defthm MOD+1-2
  (implies (and (integerp x)
                (>= x 0))
           (not (= (mod x 2) (mod (1+ x) 2))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance mod-fl (m x) (n 2))
			(:instance bit+-4 (x (- (fl (/ (1+ x) 2)) (fl (/ x 2)))))
			(:instance mod-fl (m (1+ x)) (n 2))))))

(defthm mod<=m
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0))
	     (<= (mod m n) m))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-fl)
			(:instance n<=fl-linear (n 0) (x (/ m n)))))))

(defthm mod+mod
    (implies (and (integerp a)
		  (integerp b)
		  (integerp n)
		  (>= a 0)
		  (>= b 0)
		  (> n 0))
	     (= (mod (+ a (mod b n)) n)
		(mod (+ a b) n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-fl (m b))
			(:instance mod>=0 (m b))
			(:instance mod+-thm (m (+ a (mod b n))) (a (fl (/ b
                                                                      n))))))))

(defthm mod-x-y-x-2
    (implies (and (integerp x)
		  (>= x 0)
		  (integerp y)
		  (>= y 0))
	     (iff (= (mod (+ x y) 2) (mod x 2))
		  (= (mod y 2) 0)))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod012 (x y))
			(:instance mod+mod (a x) (b y) (n 2))
			(:instance mod+1-2)))))


(defthm mod-m=n
    (implies (and (integerp m)
		  (> m 0)
		  (integerp n)
		  (> n 0)
		  (< m (* 2 n))
		  (= (mod m n) 0))
	     (= m n))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod<)
			(:instance mod< (m (- m n)))
			(:instance mod+-thm (m (- m n)) (a 1))))))


(defthm mod-0
  (implies (natp m)
           (equal (mod m 0) m))
  :hints (("Goal" :expand (mod m 0))))





(defthm natp-mod
  (implies (and (natp m)
                (natp n))
           (natp (mod m n)))
  :rule-classes :type-prescription
  :hints (("Goal" :use mod>=0)))

(defthm natp-mod-rewrite
  (implies (and (natp m)
                (natp n))
           (natp (mod m n))))

(defthm mod-bnd-1
    (implies (and (natp m)
		  (natp n)
		  (not (= n 0)))
	     (< (mod m n) n))
  :rule-classes :linear
  :hints (("Goal" :use mod<n)))

(defthm mod-bnd-2
    (implies (and (natp m)
		  (natp n))
	     (<= (mod m n) m))
  :rule-classes :linear
  :hints (("Goal" :use mod<=m)))

(defthm quot-mod
    (implies (and (natp m)
		  (natp n))
	     (equal (+ (* n (fl (/ m n))) (mod m n))
		    m))
  :rule-classes ()
  :hints (("Goal" :use mod-fl)))

(defthm mod-mult
    (implies (and (natp m)
		  (natp a)
		  (natp n))
	     (equal (mod (+ m (* a n)) n)
		    (mod m n)))
  :hints (("Goal" :use mod+-thm)))

(in-theory (disable mod-mult))

(defthm mod-sum
    (implies (and (natp a)
		  (natp b)
		  (natp n))
	     (equal (mod (+ a (mod b n)) n)
		    (mod (+ a b) n)))
  :hints (("Goal" :use mod+mod)))

(in-theory (disable mod-sum))

(defthm mod-diff
    (implies (and (natp a)
		  (natp b)
		  (natp n)
		  (>= a b))
	     (equal (mod (- a (mod b n)) n)
		    (mod (- a b) n)))
  :hints (("Goal" :use mod-minus-mod)))

(in-theory (disable mod-diff))

(defthm mod-equal
    (implies (and ;(integerp m)
                  (natp m)
		  ;(integerp n)
                  (natp n)
		  (< m n))
	     (equal (mod m n) m))
  :hints (("Goal" :use (mod<))))

(defthm mod-1
  (implies (natp x)
           (equal (mod x 1) 0))
  :hints (("Goal"
           :use
           ((:instance mod-bnd-1
                       (m x) (n 1))))))

(defthm mod-of-mod
    (implies (and (natp x)
		  (natp a)
		  (natp b)
		  (>= a b))
	     (equal (mod (mod x (expt 2 a)) (expt 2 b))
		    (mod x (expt 2 b))))
  :hints (("Goal" :use (mod-mod))))

(in-theory (disable mod-of-mod))

(defthm mod-must-be-n
    (implies (and (natp m)
		  (natp n)
		  (not (= m 0))
		  (< m (* 2 n))
		  (= (mod m n) 0))
	     (= m n))
  :rule-classes ()
  :hints (("Goal" :use (mod-m=n))))

(defthm mod-prod
    (implies (and (natp m)
		  (natp n)
                  (integerp (* n k)) ;new
                  (integerp (* m k)) ;new
                  (rationalp k)      ;new
                  (> k 0)            ;new
		  (not (= n 0)))
	     (equal (mod (* k m) (* k n))
		    (* k (mod m n))))
  :hints (("goal" :use (mod**))))

(in-theory (disable mod-prod))

#| less general version:
(defthm mod-prod
    (implies (and (natp m)
		  (natp n)
		  (natp k)
		  (not (= n 0)))
	     (equal (mod (* k m) (* k n))
		    (* k (mod m n))))
  :hints (("Goal" :use (mod**))))
|#

(defthm mod-squeeze
    (implies (and (integerp m) (>= m 0)
		  (integerp n) (> n 0)
		  (integerp a) (>= a 0)
		  (integerp r) (>= r 0)
		  (<= (* a n) m)
		  (< m (+ (* a n) r)))
	     (< (mod m n) r))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-fl)
			(:instance n<=fl-linear (x (/ m n)) (n a))))))

(defthm mod-squeeze-2
    (implies (and (integerp m)
		  (>= m 0)
		  (integerp n)
		  (> n 0)
		  (integerp a)
		  (>= a 0)
		  (> (* (1+ a) n) m)
		  (>= m (* a n)))
	     (= (mod m n) (- m (* a n))))
  :rule-classes nil :hints
  (("goal" :use
	   ((:instance mod-fl)
	    (:instance fl-unique (x (/ m n)) (n a))))))


(defthm mod-bnd-3
    (implies (and (natp m)
		  (natp n)
		  (natp a)
		  (natp r)
		  (<= (* a n) m)
		  (< m (+ (* a n) r)))
	     (< (mod m n) r))
  ;; Free variables make this rule very weak, but it seems harmless
  ;; enough to make it a :linear rule.
  :rule-classes :linear
  :hints (("Goal" :use (mod-squeeze))))

(defthm mod-force
    (implies (and (natp m)
		  (natp n)
		  (natp a)
		  (> (* (1+ a) n) m)
		  (>= m (* a n)))
	     (= (mod m n) (- m (* a n))))
  :rule-classes ()
  :hints (("Goal" :use (mod-squeeze-2))))

;from divsqrt:

(local
(defthm mod=mod-1
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (mod a n) (mod b n)))
	     (= (- a (* n (fl (/ a n))))
		(- b (* n (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod-fl (m a))
			(:instance mod-fl (m b)))))))

(local
(defthm mod=mod-2
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (mod a n) (mod b n)))
	     (= (- a b) (* n (- (fl (/ a n)) (fl (/ b n))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod=mod-1))))))

(local
(defthm hack-m10
    (implies (and (rationalp a) (rationalp b) (rationalp c) (> b 0) (= a (* b c)))
	     (= (/ a b) c))
  :rule-classes ()))

(local
(defthm mod=mod-3
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (mod a n) (mod b n)))
	     (= (/ (- a b) n) (- (fl (/ a n)) (fl (/ b n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod=mod-2)
			(:instance hack-m10 (a (- a b)) (b n) (c (- (fl (/ a n)) (fl (/ b n))))))))))

(defthm mod=mod
    (implies (and (integerp a) (>= a 0)
		  (integerp b) (>= b 0)
		  (integerp n) (> n 0)
		  (= (mod a n) (mod b n)))
	     (integerp (/ (- a b) n)))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod=mod-3)))))


(defthm mod-equal-int
    (implies (and (natp a)
		  (natp b)
		  (natp n)
		  (= (mod a n) (mod b n)))
	     (integerp (/ (- a b) n)))
  :rule-classes ()
  :hints (("Goal" :use (mod=mod))))

(defthm mod-0-fl
    (implies (and (natp m)
		  (natp n))
	     (iff (= (mod m n) 0)
		  (= m (* (fl (/ m n)) n))))
  :rule-classes ()
  :hints (("Goal" :use (fl-mod-0))))

(defthm quot-bnd
    (implies (and (natp m)
		  (natp n))
	     (>= m (* (fl (/ m n)) n)))
  :rule-classes :linear
  :hints (("Goal" :use (fl-mod-1))))

(defthm mod-0-0
    (implies (and (natp m)
		  (natp n)
		  (natp p)
                  (not (= p 0)))
	     (iff (= (mod m (* n p)) 0)
		  (and (= (mod m n) 0)
		       (= (mod (fl (/ m n)) p) 0))))
  :rule-classes ()
  :hints (("Goal" :use (fl-mod-5))))

(local (include-book "mod"))

;had a version with natp hyps?
(defthm divides-mod-0
  (implies (and (integerp n) ;drop?
                (integerp a)
                )
           (equal (mod (* a n) n)
                  0))
  :rule-classes ()
  :hints (("goal" :use ((:instance mod+-thm (m 0))
			(:instance mod< (m 0))))))

; the lemma above is better?
(defthm mod-mult-2
    (implies (and (natp n)
		  (natp a))
	     (equal (mod (* a n) n)
		    0))
  :hints (("Goal" :use (divides-mod-0))))

(in-theory (disable mod-mult-2))


