(in-package "ACL2")

(local (include-book "predicate"))
(local (include-book "fp2"))

;make these 2 nicer? ;do we need both?
(defthm product-less-than-zero
  (implies (case-split (rationalp y))
           (equal (< (* x y) 0)
                  (or (and (< x 0) (< 0 y))
                      (and (< y 0) (< 0 x)))))
  :hints (("Goal" :cases ((rationalp x)))))

;this use hint shouldn't be needed
(defthm product-less-than-zero-2
  (implies (case-split (rationalp x))
           (equal (< (* x y) 0)
                  (or (and (< x 0) (< 0 y))
                      (and (< y 0) (< 0 x)))))
  :hints (("Goal" :in-theory (disable  product-less-than-zero)
           :use (:instance  product-less-than-zero (x y) (y x)))))

(defthm product-greater-than-zero
  (implies (case-split (rationalp y))
           (equal (< 0 (* x y))
                  (or (and (< 0 x) (< 0 y))
                      (and (< y 0) (< x 0)))))
  :hints (("Goal" :cases (complex-rationalp x))))

(defthm product-greater-than-zero-2
  (implies (case-split (rationalp x))
           (equal (< 0 (* x y))
                  (or (and (< 0 x) (< 0 y))
                      (and (< y 0) (< x 0)))))
  :hints (("Goal" :in-theory (disable  product-greater-than-zero)
           :use (:instance  product-greater-than-zero (x y) (y x)))))

(defthm product-equal-zero
  (implies (and (case-split (acl2-numberp x))
                (case-split (acl2-numberp y))
                )
           (equal (equal 0 (* x y))
                  (or (equal 0 x) (equal 0 y))))
  :hints (("Goal" :cases (complex-rationalp x))))