/*
 *  acm : an aerial combat simulator for X
 *  Copyright (C) 1991-1998  Riley Rainey
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 dated June, 1991.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program;  if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave., Cambridge, MA 02139, USA.
 */

#ifndef _init_h
#define _init_h

#include <stdio.h>

#ifdef init_IMPORT
	#define EXTERN
#else
	#define EXTERN extern
#endif

/**
 * Overall initialization of the program.
 * @param objects List of directories where to search for configuration files.
 * @param departure_date Departure zulu date and time formatted as one of:
 * - "YYYY-MM-DDThh:mm:ss"
 * - "YYYY-MM-DDThh:mm"
 * - "YYYY-MM-DD"
 * - "YYYY-MM"
 * If NULL or empty, the current zulu time is used.
 */
EXTERN void init_init(char *objects, char *departure_date);

/**
 * Terminates... the initialization module!
 */
EXTERN void init_term(void);

/**
 * Find an important configuration data file, or die trying. First tries the
 * path alone, then it tries each objects directory joined with it, in the
 * order.
 * @param path File to search.
 * @return Resolved path to an existing file as a pointer to an internal
 * statically allocated buffer; do not overwrite and copy as necessary!
 */
EXTERN char * init_findFile(char *path);

/**
 * Opens a file.
 * @param path File to open. Applies init_findFile() to the search.
 * @param access Access mode.
 * @return Opened file. If not found or access denied, its a fatal error.
 */
EXTERN FILE * init_fopen(char *path, char *access);

#undef EXTERN
#endif
