#!/bin/bash
# Find and enable/disable wireless devices

for DEVICE in /sys/class/net/*; do
    if [ -d $DEVICE/wireless ]; then
# $DEVICE is a wireless device. Check if it's powered on:
	if [ `cat $DEVICE/device/power/state` = 0 ]; then
# It's powered on. Switch it off.
	    echo -n 2 > $DEVICE/device/power/state;
	    echo 0
	else
# It's powered off. Switch it on.
	    echo -n 0 > $DEVICE/device/power/state;
	    echo 1
	fi
    fi
done	
