# Analysis phases for C language.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

require "adlint/phase"
require "adlint/error"
require "adlint/monitor"
require "adlint/c/lexer"
require "adlint/c/parser"
require "adlint/c/syntax"
require "adlint/c/interp"
require "adlint/c/code"
require "adlint/c/metric"
require "adlint/c/message"
require "adlint/c/util"

module AdLint #:nodoc:
module C #:nodoc:

  class Prepare1Phase < Phase
    private
    def do_execute(context)
      monitored_region("pr3") do
        context[:c_visitor] = SyntaxTreeMulticastVisitor.new
      end
    end
  end

  class ParsePhase < Phase
    private
    def do_execute(context)
      monitored_region("prs") do
        parser = Parser.new(context, Lexer.new(context[:c_source]))
        begin
          context[:c_syntax_tree] = parser.execute
        ensure
          context[:c_token_array] = parser.token_array
        end
      end
    ensure
      DebugUtil.dump_token_array(context)
    end
  end

  class ResolvePhase < Phase
    private
    def do_execute(context)
      monitored_region("typ") do
        resolver = StaticTypeResolver.new
        context[:c_type_table] = resolver.resolve(context[:c_syntax_tree])
      end
    end
  end

  class Prepare2Phase < Phase
    private
    def do_execute(context)
      monitored_region("pr4") do
        context[:c_interpreter] = Interpreter.new(context[:c_type_table])

        context[:c_commands] = setup_code_extractions(context) +
                               setup_metric_measurements(context) +
                               setup_message_detections(context)
      end
    end

    def setup_code_extractions(context)
      [
        FuncCallExtraction.new(context),
        CrossRefExtraction.new(context),
        TypeDeclExtraction.new(context),
        GVarDeclExtraction.new(context),
        FuncDeclExtraction.new(context),
        VarDefExtraction.new(context),
        FuncDefExtraction.new(context),
        LabelDefExtraction.new(context),
        InitializationExtraction.new(context),
        AssignmentExtraction.new(context),
        LiteralExtraction.new(context)
      ]
    end

    def setup_metric_measurements(context)
      [
        FN_UNUV.new(context),
        FN_PATH.new(context),
        FL_STMT.new(context),
        FL_FUNC.new(context),
        FN_STMT.new(context),
        FN_UNRC.new(context),
        FN_LINE.new(context),
        FN_PARA.new(context),
        FN_CSUB.new(context),
        FN_GOTO.new(context),
        FN_RETN.new(context),
        FN_UELS.new(context),
        FN_NEST.new(context),
        FN_CYCM.new(context)
      ]
    end

    def setup_message_detections(context)
      [
        W0001.new(context),
        W0002.new(context),
        W0003.new(context),
        W0007.new(context),
        W0010.new(context),
        W0013.new(context),
        W0016.new(context),
        W0017.new(context),
        W0018.new(context),
        W0019.new(context),
        W0021.new(context),
        W0023.new(context),
        W0024.new(context),
        W0027.new(context),
        W0028.new(context),
        W0030.new(context),
        W0031.new(context),
        W0033.new(context),
        W0035.new(context),
        W0036.new(context),
        W0037.new(context),
        W0038.new(context),
        W0039.new(context),
        W0040.new(context),
        W0041.new(context),
        W0042.new(context),
        W0043.new(context),
        W0049.new(context),
        W0050.new(context),
        W0051.new(context),
        W0052.new(context),
        W0058.new(context),
        W0062.new(context),
        W0063.new(context),
        W0065.new(context),
        W0066.new(context),
        W0064.new(context),
        W0067.new(context),
        W0068.new(context),
        W0070.new(context),
        W0071.new(context),
        W0076.new(context),
        W0077.new(context),
        W0078.new(context),
        W0079.new(context),
        W0080.new(context),
        W0081.new(context),
        W0082.new(context),
        W0084.new(context),
        W0085.new(context),
        W0086.new(context),
        W0087.new(context),
        W0088.new(context),
        W0093.new(context),
        W0096.new(context),
        W0097.new(context),
        W0100.new(context),
        W0101.new(context),
        W0102.new(context),
        W0103.new(context),
        W0104.new(context),
        W0105.new(context),
        W0107.new(context),
        W0108.new(context),
        W0109.new(context),
        W0110.new(context),
        W0112.new(context),
        W0114.new(context),
        W0115.new(context),
        W0116.new(context),
        W0117.new(context),
        W0118.new(context),
        W0119.new(context),
        W0120.new(context),
        W0121.new(context),
        W0122.new(context),
        W0123.new(context),
        W0124.new(context),
        W0125.new(context),
        W0126.new(context),
        W0127.new(context),
        W0128.new(context),
        W0129.new(context),
        W0130.new(context),
        W0131.new(context),
        W0132.new(context),
        W0133.new(context),
        W0134.new(context),
        W0135.new(context),
        W0136.new(context),
        W0137.new(context),
        W0138.new(context),
        W0139.new(context),
        W0140.new(context),
        W0141.new(context),
        W0142.new(context),
        W0143.new(context),
        W0144.new(context),
        W0145.new(context),
        W0146.new(context),
        W0147.new(context),
        W0148.new(context),
        W0149.new(context),
        W0150.new(context),
        W0151.new(context),
        W0152.new(context),
        W0153.new(context),
        W0154.new(context),
        W0155.new(context),
        W0156.new(context),
        W0157.new(context),
        W0158.new(context),
        W0159.new(context),
        W0160.new(context),
        W0161.new(context),
        W0162.new(context),
        W0163.new(context),
        W0164.new(context),
        W0165.new(context),
        W0166.new(context),
        W0167.new(context),
        W0168.new(context),
        W0169.new(context),
        W0170.new(context),
        W0171.new(context),
        W0172.new(context),
        W0173.new(context),
        W0174.new(context),
        W0175.new(context),
        W0176.new(context),
        W0177.new(context),
        W0178.new(context),
        W0179.new(context),
        W0180.new(context),
        W0181.new(context),
        W0182.new(context),
        W0183.new(context),
        W0184.new(context),
        W0185.new(context),
        W0186.new(context),
        W0187.new(context),
        W0188.new(context),
        W0189.new(context),
        W0190.new(context),
        W0191.new(context),
        W0192.new(context),
        W0193.new(context),
        W0194.new(context),
        W0195.new(context),
        W0196.new(context),
        W0197.new(context),
        W0198.new(context),
        W0199.new(context),
        W0200.new(context),
        W0201.new(context),
        W0202.new(context),
        W0203.new(context),
        W0204.new(context),
        W0205.new(context),
        W0206.new(context),
        W0207.new(context),
        W0208.new(context),
        W0209.new(context),
        W0210.new(context),
        W0211.new(context),
        W0212.new(context),
        W0213.new(context),
        W0214.new(context),
        W0215.new(context),
        W0216.new(context),
        W0217.new(context),
        W0218.new(context),
        W0219.new(context),
        W0220.new(context),
        W0221.new(context),
        W0222.new(context),
        W0223.new(context),
        W0224.new(context),
        W0225.new(context),
        W0226.new(context),
        W0227.new(context),
        W0228.new(context),
        W0229.new(context),
        W0230.new(context),
        W0231.new(context),
        W0232.new(context),
        W0233.new(context),
        W0234.new(context),
        W0235.new(context),
        W0236.new(context),
        W0237.new(context),
        W0238.new(context),
        W0239.new(context),
        W0240.new(context),
        W0241.new(context),
        W0242.new(context),
        W0243.new(context),
        W0244.new(context),
        W0245.new(context),
        W0246.new(context),
        W0247.new(context),
        W0248.new(context),
        W0249.new(context),
        W0250.new(context),
        W0251.new(context),
        W0252.new(context),
        W0253.new(context),
        W0254.new(context),
        W0255.new(context),
        W0256.new(context),
        W0257.new(context),
        W0258.new(context),
        W0259.new(context),
        W0260.new(context),
        W0261.new(context),
        W0262.new(context),
        W0263.new(context),
        W0264.new(context),
        W0265.new(context),
        W0266.new(context),
        W0267.new(context),
        W0268.new(context),
        W0269.new(context),
        W0270.new(context),
        W0271.new(context),
        W0272.new(context),
        W0273.new(context),
        W0274.new(context),
        W0275.new(context),
        W0276.new(context),
        W0277.new(context),
        W0278.new(context),
        W0279.new(context),
        W0280.new(context),
        W0281.new(context),
        W0282.new(context),
        W0283.new(context),
        W0284.new(context),
        W0285.new(context),
        W0286.new(context),
        W0287.new(context),
        W0288.new(context),
        W0289.new(context),
        W0290.new(context),
        W0291.new(context),
        W0292.new(context),
        W0293.new(context),
        W0294.new(context),
        W0295.new(context),
        W0296.new(context),
        W0297.new(context),
        W0298.new(context),
        W0299.new(context),
        W0300.new(context),
        W0301.new(context),
        W0302.new(context),
        W0303.new(context),
        W0304.new(context),
        W0305.new(context),
        W0306.new(context),
        W0307.new(context),
        W0308.new(context),
        W0309.new(context),
        W0310.new(context),
        W0311.new(context),
        W0312.new(context),
        W0313.new(context),
        W0314.new(context),
        W0315.new(context),
        W0316.new(context),
        W0317.new(context),
        W0318.new(context),
        W0319.new(context),
        W0320.new(context),
        W0321.new(context),
        W0322.new(context),
        W0323.new(context),
        W0324.new(context),
        W0325.new(context),
        W0326.new(context),
        W0327.new(context),
        W0328.new(context),
        W0329.new(context),
        W0330.new(context),
        W0331.new(context),
        W0332.new(context),
        W0333.new(context),
        W0334.new(context),
        W0335.new(context),
        W0336.new(context),
        W0337.new(context),
        W0338.new(context),
        W0339.new(context),
        W0340.new(context),
        W0341.new(context),
        W0342.new(context),
        W0343.new(context),
        W0344.new(context),
        W0345.new(context),
        W0346.new(context),
        W0347.new(context),
        W0348.new(context),
        W0349.new(context),
        W0350.new(context),
        W0351.new(context),
        W0352.new(context),
        W0353.new(context),
        W0354.new(context),
        W0355.new(context),
        W0356.new(context),
        W0357.new(context),
        W0358.new(context),
        W0359.new(context),
        W0360.new(context),
        W0361.new(context),
        W0362.new(context),
        W0363.new(context),
        W0364.new(context),
        W0365.new(context),
        W0366.new(context),
        W0367.new(context),
        W0368.new(context),
        W0369.new(context),
        W0370.new(context),
        W0371.new(context),
        W0372.new(context),
        W0373.new(context),
        W0374.new(context),
        W0375.new(context),
        W0376.new(context),
        W0377.new(context),
        W0378.new(context),
        W0379.new(context),
        W0380.new(context),
        W0381.new(context),
        W0382.new(context),
        W0383.new(context),
        W0384.new(context),
        W0385.new(context),
        W0386.new(context),
        W0387.new(context),
        W0388.new(context),
        W0389.new(context),
        W0390.new(context),
        W0391.new(context),
        W0392.new(context),
        W0393.new(context),
        W0394.new(context),
        W0395.new(context),
        W0396.new(context),
        W0397.new(context),
        W0398.new(context),
        W0399.new(context),
        W0400.new(context),
        W0401.new(context),
        W0402.new(context),
        W0403.new(context),
        W0404.new(context),
        W0405.new(context),
        W0406.new(context),
        W0407.new(context),
        W0408.new(context),
        W0409.new(context),
        W0410.new(context),
        W0411.new(context),
        W0413.new(context),
        W0414.new(context),
        W0421.new(context),
        W0422.new(context),
        W0423.new(context),
        W0424.new(context),
        W0425.new(context),
        W0431.new(context),
        W0432.new(context),
        W0440.new(context),
        W0441.new(context),
        W0446.new(context),
        W0447.new(context),
        W0456.new(context),
        W0457.new(context),
        W0458.new(context),
        W0459.new(context),
        W0460.new(context),
        W0461.new(context),
        W0462.new(context),
        W0488.new(context),
        W0489.new(context),
        W0490.new(context),
        W0491.new(context),
        W0492.new(context),
        W0493.new(context),
        W0495.new(context),
        W0496.new(context),
        W0497.new(context),
        W0498.new(context),
        W0499.new(context),
        W0500.new(context),
        W0501.new(context),
        W0502.new(context),
        W0508.new(context),
        W0512.new(context),
        W0525.new(context),
        W0529.new(context),
        W0530.new(context),
        W0532.new(context),
        W0534.new(context),
        W0535.new(context),
        W0538.new(context),
        W0540.new(context),
        W0542.new(context),
        W0543.new(context),
        W0544.new(context),
        W0546.new(context),
        W0551.new(context),
        W0552.new(context),
        W0553.new(context),
        W0556.new(context),
        W0559.new(context),
        W0560.new(context),
        W0561.new(context),
        W0562.new(context),
        W0563.new(context),
        W0564.new(context),
        W0565.new(context),
        W0566.new(context),
        W0567.new(context),
        W0568.new(context),
        W0569.new(context),
        W0570.new(context),
        W0571.new(context),
        W0572.new(context),
        W0573.new(context),
        W0578.new(context),
        W0579.new(context),
        W0580.new(context),
        W0581.new(context),
        W0582.new(context),
        W0583.new(context),
        W0584.new(context),
        W0585.new(context),
        W0597.new(context),
        W0598.new(context),
        W0599.new(context),
        W0600.new(context),
        W0605.new(context),
        W0606.new(context),
        W0607.new(context),
        W0608.new(context),
        W0609.new(context),
        W0610.new(context),
        W0611.new(context),
        W0612.new(context),
        W0613.new(context),
        W0614.new(context),
        W0622.new(context),
        W0623.new(context),
        W0624.new(context),
        W0625.new(context),
        W0626.new(context),
        W0627.new(context),
        W0629.new(context),
        W0635.new(context),
        W0636.new(context),
        W0637.new(context),
        W0638.new(context),
        W0639.new(context),
        W0640.new(context),
        W0642.new(context),
        W0653.new(context),
        W0654.new(context),
        W0655.new(context),
        W0656.new(context),
        W0657.new(context),
        W0658.new(context),
        W0659.new(context),
        W0660.new(context),
        W0661.new(context),
        W0662.new(context),
        W0663.new(context),
        W0664.new(context),
        W0665.new(context),
        W0666.new(context),
        W0667.new(context),
        W0668.new(context),
        W0669.new(context),
        W0670.new(context),
        W0671.new(context),
        W0672.new(context),
        W0673.new(context),
        W0674.new(context),
        W0675.new(context),
        W0676.new(context),
        W0677.new(context),
        W0678.new(context),
        W0679.new(context),
        W0680.new(context),
        W0681.new(context),
        W0682.new(context),
        W0683.new(context),
        W0684.new(context),
        W0685.new(context),
        W0686.new(context),
        W0698.new(context),
        W0699.new(context),
        W0703.new(context),
        W0704.new(context),
        W0705.new(context),
        W0708.new(context),
        W0711.new(context),
        W0712.new(context),
        W0713.new(context),
        W0714.new(context),
        W0715.new(context),
        W0716.new(context),
        W0717.new(context),
        W0718.new(context),
        W0720.new(context),
        W0721.new(context),
        W0722.new(context),
        W0723.new(context),
        W0726.new(context),
        W0727.new(context),
        W0728.new(context),
        W0729.new(context),
        W0730.new(context),
        W0731.new(context),
        W0736.new(context),
        W0737.new(context),
        W0738.new(context),
        W0739.new(context),
        W0740.new(context),
        W0741.new(context),
        W0742.new(context),
        W0743.new(context),
        W0744.new(context),
        W0745.new(context),
        W0747.new(context),
        W0748.new(context),
        W0749.new(context),
        W0750.new(context),
        W0751.new(context),
        W0752.new(context),
        W0753.new(context),
        W0754.new(context),
        W0755.new(context),
        W0756.new(context),
        W0757.new(context),
        W0758.new(context),
        W0759.new(context),
        W0760.new(context),
        W0761.new(context),
        W0762.new(context),
        W0763.new(context),
        W0764.new(context),
        W0765.new(context),
        W0766.new(context),
        W0767.new(context),
        W0768.new(context),
        W0769.new(context),
        W0771.new(context),
        W0774.new(context),
        W0775.new(context),
        W0776.new(context),
        W0777.new(context),
        W0778.new(context),
        W0779.new(context),
        W0781.new(context),
        W0785.new(context),
        W0786.new(context),
        W0787.new(context),
        W0788.new(context),
        W0789.new(context),
        W0790.new(context),
        W0795.new(context),
        W0796.new(context),
        W0797.new(context),
        W0798.new(context),
        W0799.new(context),
        W0800.new(context),
        W0801.new(context),
        W0809.new(context),
        W0810.new(context),
        W0827.new(context),
        W0828.new(context),
        W0947.new(context),
        W0948.new(context),
        W0949.new(context),
        W0950.new(context),
        W1027.new(context),
        W1028.new(context),
        W1029.new(context),
        W1030.new(context),
        W1031.new(context),
        W1032.new(context),
        W1033.new(context),
        W1034.new(context),
        W1049.new(context),
        W1050.new(context),
        W1051.new(context),
        W1052.new(context),
        W1053.new(context),
        W1054.new(context),
        W1055.new(context),
        W1056.new(context),
        W1057.new(context),
        W1058.new(context),
        W1059.new(context),
        W1060.new(context),
        W1061.new(context),
        W1062.new(context),
        W1063.new(context),
        W1064.new(context),
        W1065.new(context),
        W9001.new(context)
      ]
    end
  end

  class InterpPhase < Phase
    private
    def do_execute(context)
      monitored_region("int") do
        Program.new(context[:c_interpreter], context[:c_syntax_tree]).execute
        ValueDomain.clear_memo
      end
    ensure
      DebugUtil.dump_syntax_tree(context)
    end
  end

  class ReviewPhase < Phase
    private
    def do_execute(context)
      monitored_region("rv2") do
        context[:c_syntax_tree].accept(context[:c_visitor])
      end
    end
  end

  class CommandPhase < Phase
    private
    def do_execute(context)
      monitored_region("cm2") do
        context[:c_commands].each { |command| command.execute }
      end
    end
  end

end
end
