/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <vattribute.h>
#include <vpartattribute.h>
#include <vfolder.h>
#include <qstring.h>
#include <qcstring.h>
#include <stdio.h>

VPartAttribute::VPartAttribute(QString id):VAttribute(id)
{
}

VPartAttribute::VPartAttribute(QString id, QByteArray &_data):VAttribute(id, _data)
{
}

void VPartAttribute::_narrow(const QByteArray &data)
{
	QDataStream inStream(data, IO_ReadOnly);

	if(data.size())
	{		
		// unstream the byte array
		QString _type;
		inStream>>_type>>owner>>device>>dtype>>rtype>>size>>lmodified>>active>>flags;

		inStream>>mimetype;
		inStream>>name;
		inStream>>cid;
		inStream>>encoding;
		inStream>>charset;
		inStream>>mtype;
		inStream>>partOffset;
		inStream>>partLength;
		inStream>>embeddedPath;
	}
	else
	{
		printf("warning: vpartattribute %s attempted to unstream an empty block, bailing out\n", (const char *)path());
	}
}

QByteArray VPartAttribute::_stream()
{
	QByteArray data;
	QDataStream outStream(data, IO_WriteOnly);
	
	// stream the attribute
	outStream<<"vpartattribute"<<owner<<device<<dtype<<rtype<<size<<lmodified<<active<<flags;
	
	outStream<<mimetype;
	outStream<<name;
	outStream<<cid;
	outStream<<encoding;
	outStream<<charset;
	outStream<<mtype;
	outStream<<partOffset;
	outStream<<partLength;
	outStream<<embeddedPath;
	
	return data;
}

bool VPartAttribute::getProperty(const QString &query, Any &property)
{
	if(query=="mimetype")
	{
		property=Any(mimetype);
		return true;
	}
	if(query=="name")
	{
		property=Any(name);
		return true;
	}
	if(query=="cid")
	{
		property=Any(cid);
		return true;
	}
	if(query=="encoding")
	{
		property=Any(encoding);
		return true;
	}
	if(query=="charset")
	{
		property=Any(charset);
		return true;
	}
	if(query=="mtype")
	{
		property=Any(mtype);
		return true;
	}
	if(query=="partOffset")
	{
		property=Any(partOffset);
		return true;
	}
	if(query=="partLength")
	{
		property=Any(partLength);
		return true;
	}
	
	return VAttribute::getProperty(query, property);
}

bool VPartAttribute::setProperty(const QString &query, Any &property)
{
	return VAttribute::setProperty(query, property);
}

QueryProcessor::QueryType VPartAttribute::queryType(const QString &query)
{
	if(query=="mimetype" 
	  || query=="name" 
	  || query=="cid" 
	  || query=="encoding" 
	  || query=="charset" 
	  || query=="mtype" 
	  || query=="partOffset" || query=="partLength") 
		return QueryProcessor::ReadOnlyQuery;
	
	return QueryProcessor::InvalidQuery;
}




